/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.util.Collection;
import java.util.Random;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.savepoint.CheckpointTestUtils;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointV2;
import org.junit.Assert;
import org.junit.Test;

public class SavepointV2Test {
    @Test
    public void testSavepointV2() throws Exception {
        Random rnd = new Random();
        long checkpointId = rnd.nextInt(Integer.MAX_VALUE) + 1;
        int numTaskStates = 4;
        int numSubtaskStates = 16;
        int numMasterStates = 7;
        Collection<OperatorState> taskStates = CheckpointTestUtils.createOperatorStates(rnd, 4, 16);
        Collection<MasterState> masterStates = CheckpointTestUtils.createRandomMasterStates(rnd, 7);
        SavepointV2 checkpoint = new SavepointV2(checkpointId, taskStates, masterStates);
        Assert.assertEquals((long)2L, (long)checkpoint.getVersion());
        Assert.assertEquals((long)checkpointId, (long)checkpoint.getCheckpointId());
        Assert.assertEquals(taskStates, (Object)checkpoint.getOperatorStates());
        Assert.assertEquals(masterStates, (Object)checkpoint.getMasterStates());
        Assert.assertFalse((boolean)checkpoint.getOperatorStates().isEmpty());
        Assert.assertFalse((boolean)checkpoint.getMasterStates().isEmpty());
        checkpoint.dispose();
        Assert.assertTrue((boolean)checkpoint.getOperatorStates().isEmpty());
        Assert.assertTrue((boolean)checkpoint.getMasterStates().isEmpty());
    }
}

