/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import com.typesafe.config.Config;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.messages.StopCluster;
import org.apache.flink.runtime.clusterframework.messages.StopClusterSuccessful;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.testingUtils.TestingMessages;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.TestingResourceManager;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import scala.Option;

public class ClusterShutdownITCase
extends TestLogger {
    private static ActorSystem system;
    private static Configuration config;
    private HighAvailabilityServices highAvailabilityServices;

    @Before
    public void setupTest() {
        this.highAvailabilityServices = new EmbeddedHaServices((Executor)TestingUtils.defaultExecutor());
    }

    @After
    public void tearDownTest() throws Exception {
        this.highAvailabilityServices.closeAndCleanupAllData();
        this.highAvailabilityServices = null;
    }

    @BeforeClass
    public static void setup() {
        system = AkkaUtils.createActorSystem((Config)AkkaUtils.getDefaultAkkaConfig());
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
    }

    @Test
    public void testClusterShutdownWithoutResourceManager() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(1.duration((String)"30 seconds")){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void run() {
                        ActorGateway jobManager = null;
                        ActorGateway taskManager = null;
                        ActorGateway forwardingActor = null;
                        try {
                            jobManager = TestingUtils.createJobManager(system, TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), config, ClusterShutdownITCase.this.highAvailabilityServices, "jobmanager1");
                            forwardingActor = TestingUtils.createForwardingActor(system, this.getTestActor(), jobManager.leaderSessionID(), (Option<String>)Option.empty());
                            jobManager.tell(TestingMessages.getNotifyOfComponentShutdown(), forwardingActor);
                            taskManager = TestingUtils.createTaskManager(system, ClusterShutdownITCase.this.highAvailabilityServices, config, true, true);
                            taskManager.tell(TestingMessages.getNotifyOfComponentShutdown(), forwardingActor);
                            jobManager.tell((Object)new StopCluster(ApplicationStatus.SUCCEEDED, "Shutting down."), forwardingActor);
                            this.expectMsgAllOf(new Object[]{new TestingMessages.ComponentShutdown(taskManager.actor()), new TestingMessages.ComponentShutdown(jobManager.actor()), StopClusterSuccessful.getInstance()});
                        }
                        catch (Throwable throwable) {
                            TestingUtils.stopActorGatewaysGracefully(Arrays.asList(jobManager, taskManager, forwardingActor));
                            throw throwable;
                        }
                        TestingUtils.stopActorGatewaysGracefully(Arrays.asList(jobManager, taskManager, forwardingActor));
                    }
                };
            }
        };
    }

    @Test
    public void testClusterShutdownWithResourceManager() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(2.duration((String)"30 seconds")){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void run() {
                        ActorGateway jobManager = null;
                        ActorGateway taskManager = null;
                        ActorGateway resourceManager = null;
                        ActorGateway forwardingActor = null;
                        try {
                            jobManager = TestingUtils.createJobManager(system, TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), config, ClusterShutdownITCase.this.highAvailabilityServices, "jobmanager2");
                            forwardingActor = TestingUtils.createForwardingActor(system, this.getTestActor(), jobManager.leaderSessionID(), (Option<String>)Option.empty());
                            jobManager.tell(TestingMessages.getNotifyOfComponentShutdown(), forwardingActor);
                            taskManager = TestingUtils.createTaskManager(system, ClusterShutdownITCase.this.highAvailabilityServices, config, true, true);
                            taskManager.tell(TestingMessages.getNotifyOfComponentShutdown(), forwardingActor);
                            resourceManager = TestingUtils.createResourceManager(system, config, ClusterShutdownITCase.this.highAvailabilityServices);
                            resourceManager.tell(TestingMessages.getNotifyOfComponentShutdown(), forwardingActor);
                            resourceManager.tell((Object)new TestingResourceManager.NotifyWhenResourceManagerConnected(), forwardingActor);
                            this.expectMsgEquals(Acknowledge.get());
                            jobManager.tell((Object)new StopCluster(ApplicationStatus.SUCCEEDED, "Shutting down."), forwardingActor);
                            this.expectMsgAllOf(new Object[]{new TestingMessages.ComponentShutdown(taskManager.actor()), new TestingMessages.ComponentShutdown(jobManager.actor()), new TestingMessages.ComponentShutdown(resourceManager.actor()), StopClusterSuccessful.getInstance()});
                        }
                        catch (Throwable throwable) {
                            TestingUtils.stopActorGatewaysGracefully(Arrays.asList(jobManager, taskManager, resourceManager, forwardingActor));
                            throw throwable;
                        }
                        TestingUtils.stopActorGatewaysGracefully(Arrays.asList(jobManager, taskManager, resourceManager, forwardingActor));
                    }
                };
            }
        };
    }

    static {
        config = new Configuration();
    }
}

