/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import akka.actor.ActorSystem;
import akka.testkit.JavaTestKit;
import com.typesafe.config.Config;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedHaServices;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.RegistrationMessages;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testutils.TestingResourceManager;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import scala.Option;

public class ResourceManagerITCase
extends TestLogger {
    private static ActorSystem system;
    private static Configuration config;
    private HighAvailabilityServices highAvailabilityServices;

    @BeforeClass
    public static void setup() {
        system = AkkaUtils.createActorSystem((Config)AkkaUtils.getDefaultAkkaConfig());
    }

    @AfterClass
    public static void teardown() {
        JavaTestKit.shutdownActorSystem((ActorSystem)system);
    }

    @Before
    public void setupTest() {
        this.highAvailabilityServices = new EmbeddedHaServices((Executor)TestingUtils.defaultExecutor());
    }

    @After
    public void tearDownTest() throws Exception {
        this.highAvailabilityServices.closeAndCleanupAllData();
        this.highAvailabilityServices = null;
    }

    @Test
    public void testResourceManagerReconciliation() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(1.duration((String)"10 seconds")){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void run() {
                        ActorGateway jobManager = null;
                        ActorGateway resourceManager = null;
                        ActorGateway forwardingActor = null;
                        try {
                            jobManager = TestingUtils.createJobManager(system, TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), config, ResourceManagerITCase.this.highAvailabilityServices, "ReconciliationTest");
                            forwardingActor = TestingUtils.createForwardingActor(system, this.getTestActor(), jobManager.leaderSessionID(), (Option<String>)Option.empty());
                            ResourceID resourceID = ResourceID.generate();
                            TaskManagerLocation location = (TaskManagerLocation)Mockito.mock(TaskManagerLocation.class);
                            Mockito.when((Object)location.getResourceID()).thenReturn((Object)resourceID);
                            HardwareDescription resourceProfile = HardwareDescription.extractFromSystem((long)1000000L);
                            jobManager.tell((Object)new RegistrationMessages.RegisterTaskManager(resourceID, location, resourceProfile, 1), forwardingActor);
                            this.expectMsgClass(RegistrationMessages.AcknowledgeRegistration.class);
                            resourceManager = TestingUtils.createResourceManager(system, config, ResourceManagerITCase.this.highAvailabilityServices);
                            resourceManager.tell((Object)new TestingResourceManager.NotifyWhenResourceManagerConnected(), forwardingActor);
                            this.expectMsgEquals(Acknowledge.get());
                            resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), forwardingActor);
                            TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                            Assert.assertEquals((long)1L, (long)reply.resources.size());
                            Assert.assertTrue((boolean)reply.resources.contains(resourceID));
                        }
                        catch (Throwable throwable) {
                            TestingUtils.stopActorGatewaysGracefully(Arrays.asList(jobManager, resourceManager, forwardingActor));
                            throw throwable;
                        }
                        TestingUtils.stopActorGatewaysGracefully(Arrays.asList(jobManager, resourceManager, forwardingActor));
                    }
                };
            }
        };
    }

    @Test
    public void testResourceManagerTaskManagerRegistration() {
        new JavaTestKit(system){
            {
                new JavaTestKit.Within(2.duration((String)"30 seconds")){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void run() {
                        ActorGateway jobManager = null;
                        ActorGateway taskManager = null;
                        ActorGateway resourceManager = null;
                        ActorGateway forwardingActor = null;
                        try {
                            jobManager = TestingUtils.createJobManager(system, TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), config, ResourceManagerITCase.this.highAvailabilityServices, "RegTest");
                            forwardingActor = TestingUtils.createForwardingActor(system, this.getTestActor(), jobManager.leaderSessionID(), (Option<String>)Option.empty());
                            resourceManager = TestingUtils.createResourceManager(system, config, ResourceManagerITCase.this.highAvailabilityServices);
                            resourceManager.tell((Object)new TestingResourceManager.NotifyWhenResourceManagerConnected(), forwardingActor);
                            this.expectMsgEquals(Acknowledge.get());
                            taskManager = TestingUtils.createTaskManager(system, ResourceManagerITCase.this.highAvailabilityServices, config, true, true);
                            resourceManager.tell((Object)new TestingResourceManager.GetRegisteredResources(), forwardingActor);
                            TestingResourceManager.GetRegisteredResourcesReply reply = (TestingResourceManager.GetRegisteredResourcesReply)this.expectMsgClass(TestingResourceManager.GetRegisteredResourcesReply.class);
                            Assert.assertEquals((long)1L, (long)reply.resources.size());
                        }
                        catch (Throwable throwable) {
                            TestingUtils.stopActorGatewaysGracefully(Arrays.asList(jobManager, resourceManager, taskManager, forwardingActor));
                            throw throwable;
                        }
                        TestingUtils.stopActorGatewaysGracefully(Arrays.asList(jobManager, resourceManager, taskManager, forwardingActor));
                    }
                };
            }
        };
    }

    static {
        config = new Configuration();
    }
}

