/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.util.HashMap;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlayTestBase;
import org.apache.flink.runtime.clusterframework.overlays.FlinkDistributionOverlay;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FlinkDistributionOverlayTest
extends ContainerOverlayTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testConfigure() throws Exception {
        File binFolder = this.tempFolder.newFolder("bin");
        File libFolder = this.tempFolder.newFolder("lib");
        File confFolder = this.tempFolder.newFolder("conf");
        Path[] files = FlinkDistributionOverlayTest.createPaths(this.tempFolder.getRoot(), "bin/config.sh", "bin/taskmanager.sh", "lib/foo.jar", "lib/A/foo.jar", "lib/B/foo.jar", "lib/B/bar.jar");
        ContainerSpecification containerSpecification = new ContainerSpecification();
        FlinkDistributionOverlay overlay = new FlinkDistributionOverlay(binFolder, confFolder, libFolder);
        overlay.configure(containerSpecification);
        for (Path file : files) {
            FlinkDistributionOverlayTest.checkArtifact(containerSpecification, new Path(FlinkDistributionOverlay.TARGET_ROOT, file.toString()));
        }
    }

    @Test
    public void testBuilderFromEnvironment() throws Exception {
        Configuration conf = new Configuration();
        File binFolder = this.tempFolder.newFolder("bin");
        File libFolder = this.tempFolder.newFolder("lib");
        File confFolder = this.tempFolder.newFolder("conf");
        HashMap<String, String> map = new HashMap<String, String>(System.getenv());
        map.put("FLINK_BIN_DIR", binFolder.getAbsolutePath());
        map.put("FLINK_LIB_DIR", libFolder.getAbsolutePath());
        map.put("FLINK_CONF_DIR", confFolder.getAbsolutePath());
        CommonTestUtils.setEnv(map);
        FlinkDistributionOverlay.Builder builder = FlinkDistributionOverlay.newBuilder().fromEnvironment(conf);
        Assert.assertEquals((Object)binFolder.getAbsolutePath(), (Object)builder.flinkBinPath.getAbsolutePath());
        Assert.assertEquals((Object)libFolder.getAbsolutePath(), (Object)builder.flinkLibPath.getAbsolutePath());
        Assert.assertEquals((Object)confFolder.getAbsolutePath(), (Object)builder.flinkConfPath.getAbsolutePath());
    }

    @Test
    public void testBuilderFromEnvironmentBad() throws Exception {
        Configuration conf = new Configuration();
        HashMap<String, String> map = new HashMap<String, String>(System.getenv());
        map.remove("FLINK_BIN_DIR");
        map.remove("FLINK_LIB_DIR");
        map.remove("FLINK_CONF_DIR");
        CommonTestUtils.setEnv(map);
        try {
            FlinkDistributionOverlay.Builder builder = FlinkDistributionOverlay.newBuilder().fromEnvironment(conf);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

