/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.ContainerOverlayTestBase;
import org.apache.flink.runtime.clusterframework.overlays.SSLStoreOverlay;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SSLStoreOverlayTest
extends ContainerOverlayTestBase {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testConfigure() throws Exception {
        File keystore = this.tempFolder.newFile();
        File truststore = this.tempFolder.newFile();
        SSLStoreOverlay overlay = new SSLStoreOverlay(keystore, truststore);
        ContainerSpecification spec = new ContainerSpecification();
        overlay.configure(spec);
        Assert.assertEquals((Object)SSLStoreOverlay.TARGET_KEYSTORE_PATH.getPath(), (Object)spec.getDynamicConfiguration().getString(SecurityOptions.SSL_KEYSTORE));
        SSLStoreOverlayTest.checkArtifact(spec, SSLStoreOverlay.TARGET_KEYSTORE_PATH);
        Assert.assertEquals((Object)SSLStoreOverlay.TARGET_TRUSTSTORE_PATH.getPath(), (Object)spec.getDynamicConfiguration().getString(SecurityOptions.SSL_TRUSTSTORE));
        SSLStoreOverlayTest.checkArtifact(spec, SSLStoreOverlay.TARGET_TRUSTSTORE_PATH);
    }

    @Test
    public void testNoConf() throws Exception {
        SSLStoreOverlay overlay = new SSLStoreOverlay(null, null);
        ContainerSpecification containerSpecification = new ContainerSpecification();
        overlay.configure(containerSpecification);
    }

    @Test
    public void testBuilderFromEnvironment() throws Exception {
        Configuration conf = new Configuration();
        File keystore = this.tempFolder.newFile();
        File truststore = this.tempFolder.newFile();
        conf.setString(SecurityOptions.SSL_KEYSTORE, keystore.getAbsolutePath());
        conf.setString(SecurityOptions.SSL_TRUSTSTORE, truststore.getAbsolutePath());
        SSLStoreOverlay.Builder builder = SSLStoreOverlay.newBuilder().fromEnvironment(conf);
        Assert.assertEquals((Object)builder.keystorePath, (Object)keystore);
        Assert.assertEquals((Object)builder.truststorePath, (Object)truststore);
    }
}

