/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.util.Collections;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.junit.Assert;
import org.junit.Test;

public class ResourceProfileTest {
    @Test
    public void testMatchRequirement() throws Exception {
        ResourceProfile rp1 = new ResourceProfile(1.0, 100, 100, 100, 0, Collections.emptyMap());
        ResourceProfile rp2 = new ResourceProfile(1.0, 200, 200, 200, 0, Collections.emptyMap());
        ResourceProfile rp3 = new ResourceProfile(2.0, 100, 100, 100, 0, Collections.emptyMap());
        ResourceProfile rp4 = new ResourceProfile(2.0, 200, 200, 200, 0, Collections.emptyMap());
        Assert.assertFalse((boolean)rp1.isMatching(rp2));
        Assert.assertTrue((boolean)rp2.isMatching(rp1));
        Assert.assertFalse((boolean)rp1.isMatching(rp3));
        Assert.assertTrue((boolean)rp3.isMatching(rp1));
        Assert.assertFalse((boolean)rp2.isMatching(rp3));
        Assert.assertFalse((boolean)rp3.isMatching(rp2));
        Assert.assertTrue((boolean)rp4.isMatching(rp1));
        Assert.assertTrue((boolean)rp4.isMatching(rp2));
        Assert.assertTrue((boolean)rp4.isMatching(rp3));
        Assert.assertTrue((boolean)rp4.isMatching(rp4));
        ResourceProfile rp5 = new ResourceProfile(2.0, 100, 100, 100, 100, null);
        Assert.assertFalse((boolean)rp4.isMatching(rp5));
        ResourceSpec rs1 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).setGPUResource(2.2).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).setGPUResource(1.1).build();
        Assert.assertFalse((boolean)rp1.isMatching(ResourceProfile.fromResourceSpec((ResourceSpec)rs1, (int)0)));
        Assert.assertTrue((boolean)ResourceProfile.fromResourceSpec((ResourceSpec)rs1, (int)0).isMatching(ResourceProfile.fromResourceSpec((ResourceSpec)rs2, (int)0)));
        Assert.assertFalse((boolean)ResourceProfile.fromResourceSpec((ResourceSpec)rs2, (int)0).isMatching(ResourceProfile.fromResourceSpec((ResourceSpec)rs1, (int)0)));
    }

    @Test
    public void testUnknownMatchesUnknown() {
        Assert.assertTrue((boolean)ResourceProfile.UNKNOWN.isMatching(ResourceProfile.UNKNOWN));
    }

    @Test
    public void testEquals() throws Exception {
        ResourceSpec rs1 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).build();
        Assert.assertTrue((boolean)ResourceProfile.fromResourceSpec((ResourceSpec)rs1, (int)0).equals((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs2, (int)0)));
        ResourceSpec rs3 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).setGPUResource(2.2).build();
        ResourceSpec rs4 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).setGPUResource(1.1).build();
        Assert.assertFalse((boolean)ResourceProfile.fromResourceSpec((ResourceSpec)rs3, (int)0).equals((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs4, (int)0)));
        ResourceSpec rs5 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).setGPUResource(2.2).build();
        Assert.assertTrue((boolean)ResourceProfile.fromResourceSpec((ResourceSpec)rs3, (int)100).equals((Object)ResourceProfile.fromResourceSpec((ResourceSpec)rs5, (int)100)));
    }

    @Test
    public void testCompareTo() throws Exception {
        ResourceSpec rs1 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).build();
        ResourceSpec rs2 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).build();
        Assert.assertEquals((long)0L, (long)ResourceProfile.fromResourceSpec((ResourceSpec)rs1, (int)0).compareTo(ResourceProfile.fromResourceSpec((ResourceSpec)rs2, (int)0)));
        ResourceSpec rs3 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).setGPUResource(2.2).build();
        Assert.assertEquals((long)-1L, (long)ResourceProfile.fromResourceSpec((ResourceSpec)rs1, (int)0).compareTo(ResourceProfile.fromResourceSpec((ResourceSpec)rs3, (int)0)));
        Assert.assertEquals((long)1L, (long)ResourceProfile.fromResourceSpec((ResourceSpec)rs3, (int)0).compareTo(ResourceProfile.fromResourceSpec((ResourceSpec)rs1, (int)0)));
        ResourceSpec rs4 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).setGPUResource(1.1).build();
        Assert.assertEquals((long)1L, (long)ResourceProfile.fromResourceSpec((ResourceSpec)rs3, (int)0).compareTo(ResourceProfile.fromResourceSpec((ResourceSpec)rs4, (int)0)));
        Assert.assertEquals((long)-1L, (long)ResourceProfile.fromResourceSpec((ResourceSpec)rs4, (int)0).compareTo(ResourceProfile.fromResourceSpec((ResourceSpec)rs3, (int)0)));
        ResourceSpec rs5 = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).setGPUResource(2.2).build();
        Assert.assertEquals((long)0L, (long)ResourceProfile.fromResourceSpec((ResourceSpec)rs3, (int)0).compareTo(ResourceProfile.fromResourceSpec((ResourceSpec)rs5, (int)0)));
    }

    @Test
    public void testGet() throws Exception {
        ResourceSpec rs = ResourceSpec.newBuilder().setCpuCores(1.0).setHeapMemoryInMB(100).setGPUResource(1.6).build();
        ResourceProfile rp = ResourceProfile.fromResourceSpec((ResourceSpec)rs, (int)50);
        Assert.assertEquals((double)1.0, (double)rp.getCpuCores(), (double)1.0E-6);
        Assert.assertEquals((long)150L, (long)rp.getMemoryInMB());
        Assert.assertEquals((long)100L, (long)rp.getOperatorsMemoryInMB());
        Assert.assertEquals((double)1.6, (double)((Resource)rp.getExtendedResources().get("GPU")).getValue(), (double)1.0E-6);
    }
}

