/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.core.testutils.ManuallyTriggeredDirectExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.util.Preconditions;

public class ManuallyTriggeredScheduledExecutor
extends ManuallyTriggeredDirectExecutor
implements ScheduledExecutor {
    private final ConcurrentLinkedQueue<ScheduledTask<?>> scheduledTasks = new ConcurrentLinkedQueue();

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.insertRunnable(command, false);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledTask scheduledTask = new ScheduledTask(callable, false);
        this.scheduledTasks.offer(scheduledTask);
        return scheduledTask;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.insertRunnable(command, true);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.insertRunnable(command, true);
    }

    Collection<ScheduledFuture<?>> getScheduledTasks() {
        return new ArrayList(this.scheduledTasks);
    }

    public void triggerScheduledTasks() {
        Iterator<ScheduledTask<?>> iterator = this.scheduledTasks.iterator();
        while (iterator.hasNext()) {
            ScheduledTask<?> scheduledTask = iterator.next();
            scheduledTask.execute();
            if (((ScheduledTask)scheduledTask).isPeriodic) continue;
            iterator.remove();
        }
    }

    private ScheduledFuture<?> insertRunnable(Runnable command, boolean isPeriodic) {
        ScheduledTask scheduledTask = new ScheduledTask(() -> {
            command.run();
            return null;
        }, isPeriodic);
        this.scheduledTasks.offer(scheduledTask);
        return scheduledTask;
    }

    private static final class ScheduledTask<T>
    implements ScheduledFuture<T> {
        private final Callable<T> callable;
        private final boolean isPeriodic;
        private final CompletableFuture<T> result;

        private ScheduledTask(Callable<T> callable, boolean isPeriodic) {
            this.callable = (Callable)Preconditions.checkNotNull(callable);
            this.isPeriodic = isPeriodic;
            this.result = new CompletableFuture();
        }

        public void execute() {
            if (!this.result.isDone()) {
                if (!this.isPeriodic) {
                    try {
                        this.result.complete(this.callable.call());
                    }
                    catch (Exception e) {
                        this.result.completeExceptionally(e);
                    }
                } else {
                    try {
                        this.callable.call();
                    }
                    catch (Exception e) {
                        this.result.completeExceptionally(e);
                    }
                }
            }
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.result.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.result.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.result.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.result.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.result.get(timeout, unit);
        }
    }
}

