/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.junit.Assert;
import org.junit.Test;

public class ResultPartitionDeploymentDescriptorTest {
    @Test
    public void testSerialization() throws Exception {
        IntermediateDataSetID resultId = new IntermediateDataSetID();
        IntermediateResultPartitionID partitionId = new IntermediateResultPartitionID();
        ResultPartitionType partitionType = ResultPartitionType.PIPELINED;
        int numberOfSubpartitions = 24;
        ResultPartitionDeploymentDescriptor orig = new ResultPartitionDeploymentDescriptor(resultId, partitionId, partitionType, numberOfSubpartitions, numberOfSubpartitions, true);
        ResultPartitionDeploymentDescriptor copy = (ResultPartitionDeploymentDescriptor)CommonTestUtils.createCopySerializable((Serializable)orig);
        Assert.assertEquals((Object)resultId, (Object)copy.getResultId());
        Assert.assertEquals((Object)partitionId, (Object)copy.getPartitionId());
        Assert.assertEquals((Object)partitionType, (Object)copy.getPartitionType());
        Assert.assertEquals((long)numberOfSubpartitions, (long)copy.getNumberOfSubpartitions());
        Assert.assertTrue((boolean)copy.sendScheduleOrUpdateConsumersMessage());
    }
}

