/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.dispatcher.FileArchivedExecutionGraphStore;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.ManualTicker;
import org.apache.flink.runtime.webmonitor.WebMonitorUtils;
import org.apache.flink.shaded.guava18.com.google.common.base.Ticker;
import org.apache.flink.shaded.guava18.com.google.common.cache.LoadingCache;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileArchivedExecutionGraphStoreTest
extends TestLogger {
    private static final List<JobStatus> GLOBALLY_TERMINAL_JOB_STATUS = Arrays.stream(JobStatus.values()).filter(JobStatus::isGloballyTerminalState).collect(Collectors.toList());
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testPut() throws IOException {
        ArchivedExecutionGraph dummyExecutionGraph = new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build();
        File rootDir = temporaryFolder.newFolder();
        try (FileArchivedExecutionGraphStore executionGraphStore = this.createDefaultExecutionGraphStore(rootDir);){
            File storageDirectory = executionGraphStore.getStorageDir();
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
            executionGraphStore.put(dummyExecutionGraph);
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)executionGraphStore.get(dummyExecutionGraph.getJobID()), (Matcher)new PartialArchivedExecutionGraphMatcher(dummyExecutionGraph));
        }
    }

    @Test
    public void testUnknownGet() throws IOException {
        File rootDir = temporaryFolder.newFolder();
        try (FileArchivedExecutionGraphStore executionGraphStore = this.createDefaultExecutionGraphStore(rootDir);){
            Assert.assertThat((Object)executionGraphStore.get(new JobID()), (Matcher)Matchers.nullValue());
        }
    }

    @Test
    public void testStoredJobsOverview() throws IOException {
        int numberExecutionGraphs = 10;
        Collection<ArchivedExecutionGraph> executionGraphs = this.generateTerminalExecutionGraphs(10);
        List jobStatuses = executionGraphs.stream().map(ArchivedExecutionGraph::getState).collect(Collectors.toList());
        JobsOverview expectedJobsOverview = JobsOverview.create(jobStatuses);
        File rootDir = temporaryFolder.newFolder();
        try (FileArchivedExecutionGraphStore executionGraphStore = this.createDefaultExecutionGraphStore(rootDir);){
            for (ArchivedExecutionGraph executionGraph : executionGraphs) {
                executionGraphStore.put(executionGraph);
            }
            Assert.assertThat((Object)executionGraphStore.getStoredJobsOverview(), (Matcher)Matchers.equalTo((Object)expectedJobsOverview));
        }
    }

    @Test
    public void testAvailableJobDetails() throws IOException {
        int numberExecutionGraphs = 10;
        Collection<ArchivedExecutionGraph> executionGraphs = this.generateTerminalExecutionGraphs(10);
        Collection jobDetails = executionGraphs.stream().map(WebMonitorUtils::createDetailsForJob).collect(Collectors.toList());
        File rootDir = temporaryFolder.newFolder();
        try (FileArchivedExecutionGraphStore executionGraphStore = this.createDefaultExecutionGraphStore(rootDir);){
            for (ArchivedExecutionGraph executionGraph : executionGraphs) {
                executionGraphStore.put(executionGraph);
            }
            Assert.assertThat((Object)executionGraphStore.getAvailableJobDetails(), (Matcher)Matchers.containsInAnyOrder((Object[])jobDetails.toArray()));
        }
    }

    @Test
    public void testExecutionGraphExpiration() throws Exception {
        File rootDir = temporaryFolder.newFolder();
        Time expirationTime = Time.milliseconds((long)1L);
        ManuallyTriggeredScheduledExecutor scheduledExecutor = new ManuallyTriggeredScheduledExecutor();
        ManualTicker manualTicker = new ManualTicker();
        try (FileArchivedExecutionGraphStore executionGraphStore = new FileArchivedExecutionGraphStore(rootDir, expirationTime, 10000L, (ScheduledExecutor)scheduledExecutor, (Ticker)manualTicker);){
            ArchivedExecutionGraph executionGraph = new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build();
            executionGraphStore.put(executionGraph);
            Assert.assertThat((Object)executionGraphStore.size(), (Matcher)Matchers.equalTo((Object)1));
            manualTicker.advanceTime(expirationTime.toMilliseconds(), TimeUnit.MILLISECONDS);
            scheduledExecutor.triggerScheduledTasks();
            Assert.assertThat((Object)executionGraphStore.size(), (Matcher)Matchers.equalTo((Object)0));
            Assert.assertThat((Object)executionGraphStore.get(executionGraph.getJobID()), (Matcher)Matchers.nullValue());
            File storageDirectory = executionGraphStore.getStorageDir();
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
        }
    }

    @Test
    public void testCloseCleansUp() throws IOException {
        File rootDir = temporaryFolder.newFolder();
        Assert.assertThat((Object)rootDir.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
        try (FileArchivedExecutionGraphStore executionGraphStore = this.createDefaultExecutionGraphStore(rootDir);){
            Assert.assertThat((Object)rootDir.listFiles().length, (Matcher)Matchers.equalTo((Object)1));
            File storageDirectory = executionGraphStore.getStorageDir();
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
            executionGraphStore.put(new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build());
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)1));
        }
        Assert.assertThat((Object)rootDir.listFiles().length, (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testCacheLoading() throws IOException {
        File rootDir = temporaryFolder.newFolder();
        try (FileArchivedExecutionGraphStore executionGraphStore = new FileArchivedExecutionGraphStore(rootDir, Time.hours((long)1L), 102400L, TestingUtils.defaultScheduledExecutor(), Ticker.systemTicker());){
            LoadingCache executionGraphCache = executionGraphStore.getArchivedExecutionGraphCache();
            ArrayList<ArchivedExecutionGraph> executionGraphs = new ArrayList<ArchivedExecutionGraph>(64);
            boolean continueInserting = true;
            while (continueInserting) {
                ArchivedExecutionGraph executionGraph = new ArchivedExecutionGraphBuilder().setState(JobStatus.FINISHED).build();
                executionGraphStore.put(executionGraph);
                executionGraphs.add(executionGraph);
                continueInserting = executionGraphCache.size() == (long)executionGraphs.size();
            }
            File storageDirectory = executionGraphStore.getStorageDir();
            Assert.assertThat((Object)storageDirectory.listFiles().length, (Matcher)Matchers.equalTo((Object)executionGraphs.size()));
            for (ArchivedExecutionGraph executionGraph : executionGraphs) {
                Assert.assertThat((Object)executionGraphStore.get(executionGraph.getJobID()), FileArchivedExecutionGraphStoreTest.matchesPartiallyWith(executionGraph));
            }
        }
    }

    private Collection<ArchivedExecutionGraph> generateTerminalExecutionGraphs(int number) {
        ArrayList<ArchivedExecutionGraph> executionGraphs = new ArrayList<ArchivedExecutionGraph>(number);
        for (int i = 0; i < number; ++i) {
            JobStatus state = GLOBALLY_TERMINAL_JOB_STATUS.get(ThreadLocalRandom.current().nextInt(GLOBALLY_TERMINAL_JOB_STATUS.size()));
            executionGraphs.add(new ArchivedExecutionGraphBuilder().setState(state).build());
        }
        return executionGraphs;
    }

    private FileArchivedExecutionGraphStore createDefaultExecutionGraphStore(File storageDirectory) throws IOException {
        return new FileArchivedExecutionGraphStore(storageDirectory, Time.hours((long)1L), 10000L, TestingUtils.defaultScheduledExecutor(), Ticker.systemTicker());
    }

    private static Matcher<ArchivedExecutionGraph> matchesPartiallyWith(ArchivedExecutionGraph executionGraph) {
        return new PartialArchivedExecutionGraphMatcher(executionGraph);
    }

    private static final class PartialArchivedExecutionGraphMatcher
    extends BaseMatcher<ArchivedExecutionGraph> {
        private final ArchivedExecutionGraph archivedExecutionGraph;

        private PartialArchivedExecutionGraphMatcher(ArchivedExecutionGraph expectedArchivedExecutionGraph) {
            this.archivedExecutionGraph = (ArchivedExecutionGraph)Preconditions.checkNotNull((Object)expectedArchivedExecutionGraph);
        }

        public boolean matches(Object o) {
            if (this.archivedExecutionGraph == o) {
                return true;
            }
            if (o == null || this.archivedExecutionGraph.getClass() != o.getClass()) {
                return false;
            }
            ArchivedExecutionGraph that = (ArchivedExecutionGraph)o;
            return this.archivedExecutionGraph.isStoppable() == that.isStoppable() && Objects.equals(this.archivedExecutionGraph.getJobID(), that.getJobID()) && Objects.equals(this.archivedExecutionGraph.getJobName(), that.getJobName()) && this.archivedExecutionGraph.getState() == that.getState() && Objects.equals(this.archivedExecutionGraph.getJsonPlan(), that.getJsonPlan()) && Objects.equals(this.archivedExecutionGraph.getAccumulatorsSerialized(), that.getAccumulatorsSerialized()) && Objects.equals(this.archivedExecutionGraph.getCheckpointCoordinatorConfiguration(), that.getCheckpointCoordinatorConfiguration()) && this.archivedExecutionGraph.getAllVertices().size() == that.getAllVertices().size();
        }

        public void describeTo(Description description) {
            description.appendText("Matches against " + ArchivedExecutionGraph.class.getSimpleName() + '.');
        }
    }
}

