/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobManagerRunner;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.factories.JobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.mockito.Mockito;

class TestingJobManagerRunnerFactory
implements Dispatcher.JobManagerRunnerFactory {
    private final CompletableFuture<JobGraph> jobGraphFuture;
    private final CompletableFuture<ArchivedExecutionGraph> resultFuture;
    private final CompletableFuture<Void> terminationFuture;

    TestingJobManagerRunnerFactory(CompletableFuture<JobGraph> jobGraphFuture, CompletableFuture<ArchivedExecutionGraph> resultFuture, CompletableFuture<Void> terminationFuture) {
        this.jobGraphFuture = jobGraphFuture;
        this.resultFuture = resultFuture;
        this.terminationFuture = terminationFuture;
    }

    public JobManagerRunner createJobManagerRunner(ResourceID resourceId, JobGraph jobGraph, Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, BlobServer blobServer, JobManagerSharedServices jobManagerSharedServices, JobManagerJobMetricGroupFactory jobManagerJobMetricGroupFactory, FatalErrorHandler fatalErrorHandler) throws Exception {
        this.jobGraphFuture.complete(jobGraph);
        JobManagerRunner mock = (JobManagerRunner)Mockito.mock(JobManagerRunner.class);
        Mockito.when((Object)mock.getResultFuture()).thenReturn(this.resultFuture);
        Mockito.when((Object)mock.closeAsync()).thenReturn(this.terminationFuture);
        Mockito.when((Object)mock.getJobGraph()).thenReturn((Object)jobGraph);
        return mock;
    }
}

