/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.execution.librarycache;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerCleanupTest;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobCache;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobLibraryCacheManagerTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLibraryCacheManagerJobCleanup() throws IOException, InterruptedException {
        JobID jobId1 = new JobID();
        JobID jobId2 = new JobID();
        ArrayList<PermanentBlobKey> keys1 = new ArrayList<PermanentBlobKey>();
        ArrayList<PermanentBlobKey> keys2 = new ArrayList<PermanentBlobKey>();
        BlobServer server = null;
        PermanentBlobCache cache = null;
        BlobLibraryCacheManager libCache = null;
        byte[] buf = new byte[128];
        try {
            Configuration config = new Configuration();
            config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
            config.setLong(BlobServerOptions.CLEANUP_INTERVAL, 1L);
            server = new BlobServer(config, (BlobStore)new VoidBlobStore());
            server.start();
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            cache = new PermanentBlobCache(config, (BlobView)new VoidBlobStore(), serverAddress);
            keys1.add(server.putPermanent(jobId1, buf));
            buf[0] = (byte)(buf[0] + 1);
            keys1.add(server.putPermanent(jobId1, buf));
            keys2.add(server.putPermanent(jobId2, buf));
            libCache = new BlobLibraryCacheManager((PermanentBlobService)cache, FlinkUserCodeClassLoaders.ResolveOrder.CHILD_FIRST, new String[0]);
            cache.registerJob(jobId1);
            cache.registerJob(jobId2);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId1, (PermanentBlobService)cache);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId2, (PermanentBlobService)cache);
            libCache.registerJob(jobId1, keys1, Collections.emptyList());
            ClassLoader classLoader1 = libCache.getClassLoader(jobId1);
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId2));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId1, keys1, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)cache);
            Assert.assertEquals((long)0L, (long)BlobServerCleanupTest.checkFilesExist(jobId2, keys2, cache, false));
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId2, (PermanentBlobService)cache);
            libCache.registerJob(jobId2, keys2, Collections.emptyList());
            ClassLoader classLoader2 = libCache.getClassLoader(jobId2);
            Assert.assertNotEquals((Object)classLoader1, (Object)classLoader2);
            try {
                libCache.registerJob(jobId2, keys1, Collections.emptyList());
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                libCache.registerJob(jobId2, keys2, Collections.singletonList(new URL("file:///tmp/does-not-exist")));
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertEquals((long)2L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId2));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId1, keys1, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)cache);
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId2, keys2, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)cache);
            libCache.unregisterJob(jobId1);
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId2));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId1, keys1, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)cache);
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId2, keys2, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)cache);
            libCache.unregisterJob(jobId2);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId1));
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId2));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId1, keys1, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId1, (PermanentBlobService)cache);
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId2, keys2, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId2, (PermanentBlobService)cache);
        }
        finally {
            if (libCache != null) {
                libCache.shutdown();
            }
            if (cache != null) {
                cache.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLibraryCacheManagerTaskCleanup() throws IOException, InterruptedException {
        JobID jobId = new JobID();
        ExecutionAttemptID attempt1 = new ExecutionAttemptID();
        ExecutionAttemptID attempt2 = new ExecutionAttemptID();
        ArrayList<PermanentBlobKey> keys = new ArrayList<PermanentBlobKey>();
        BlobServer server = null;
        PermanentBlobCache cache = null;
        BlobLibraryCacheManager libCache = null;
        byte[] buf = new byte[128];
        try {
            Configuration config = new Configuration();
            config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
            config.setLong(BlobServerOptions.CLEANUP_INTERVAL, 1L);
            server = new BlobServer(config, (BlobStore)new VoidBlobStore());
            server.start();
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            cache = new PermanentBlobCache(config, (BlobView)new VoidBlobStore(), serverAddress);
            keys.add(server.putPermanent(jobId, buf));
            buf[0] = (byte)(buf[0] + 1);
            keys.add(server.putPermanent(jobId, buf));
            libCache = new BlobLibraryCacheManager((PermanentBlobService)cache, FlinkUserCodeClassLoaders.ResolveOrder.CHILD_FIRST, new String[0]);
            cache.registerJob(jobId);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
            libCache.registerTask(jobId, attempt1, keys, Collections.emptyList());
            ClassLoader classLoader1 = libCache.getClassLoader(jobId);
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
            libCache.registerTask(jobId, attempt2, keys, Collections.emptyList());
            ClassLoader classLoader2 = libCache.getClassLoader(jobId);
            Assert.assertEquals((Object)classLoader1, (Object)classLoader2);
            try {
                libCache.registerTask(jobId, new ExecutionAttemptID(), Collections.emptyList(), Collections.emptyList());
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                libCache.registerTask(jobId, new ExecutionAttemptID(), keys, Collections.singletonList(new URL("file:///tmp/does-not-exist")));
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)2L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
            libCache.unregisterTask(jobId, attempt1);
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
            libCache.unregisterTask(jobId, attempt2);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
        }
        finally {
            if (libCache != null) {
                libCache.shutdown();
            }
            if (cache != null) {
                cache.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLibraryCacheManagerMixedJobTaskCleanup() throws IOException, InterruptedException {
        JobID jobId = new JobID();
        ExecutionAttemptID attempt1 = new ExecutionAttemptID();
        ArrayList<PermanentBlobKey> keys = new ArrayList<PermanentBlobKey>();
        BlobServer server = null;
        PermanentBlobCache cache = null;
        BlobLibraryCacheManager libCache = null;
        byte[] buf = new byte[128];
        try {
            Configuration config = new Configuration();
            config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
            config.setLong(BlobServerOptions.CLEANUP_INTERVAL, 1L);
            server = new BlobServer(config, (BlobStore)new VoidBlobStore());
            server.start();
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            cache = new PermanentBlobCache(config, (BlobView)new VoidBlobStore(), serverAddress);
            keys.add(server.putPermanent(jobId, buf));
            buf[0] = (byte)(buf[0] + 1);
            keys.add(server.putPermanent(jobId, buf));
            libCache = new BlobLibraryCacheManager((PermanentBlobService)cache, FlinkUserCodeClassLoaders.ResolveOrder.CHILD_FIRST, new String[0]);
            cache.registerJob(jobId);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
            libCache.registerJob(jobId, keys, Collections.emptyList());
            ClassLoader classLoader1 = libCache.getClassLoader(jobId);
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
            libCache.registerTask(jobId, attempt1, keys, Collections.emptyList());
            ClassLoader classLoader2 = libCache.getClassLoader(jobId);
            Assert.assertEquals((Object)classLoader1, (Object)classLoader2);
            try {
                libCache.registerTask(jobId, new ExecutionAttemptID(), Collections.emptyList(), Collections.emptyList());
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                libCache.registerTask(jobId, new ExecutionAttemptID(), keys, Collections.singletonList(new URL("file:///tmp/does-not-exist")));
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)2L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
            libCache.unregisterJob(jobId);
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
            libCache.unregisterTask(jobId, attempt1);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)2L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)cache);
        }
        finally {
            if (libCache != null) {
                libCache.shutdown();
            }
            if (cache != null) {
                cache.close();
            }
            if (server != null) {
                server.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterAndDownload() throws IOException {
        Assume.assumeTrue((!OperatingSystem.isWindows() ? 1 : 0) != 0);
        JobID jobId = new JobID();
        BlobServer server = null;
        PermanentBlobCache cache = null;
        BlobLibraryCacheManager libCache = null;
        File cacheDir = null;
        try {
            Configuration config = new Configuration();
            config.setString(BlobServerOptions.STORAGE_DIRECTORY, this.temporaryFolder.newFolder().getAbsolutePath());
            config.setLong(BlobServerOptions.CLEANUP_INTERVAL, 1000000L);
            server = new BlobServer(config, (BlobStore)new VoidBlobStore());
            server.start();
            InetSocketAddress serverAddress = new InetSocketAddress("localhost", server.getPort());
            cache = new PermanentBlobCache(config, (BlobView)new VoidBlobStore(), serverAddress);
            PermanentBlobKey dataKey1 = server.putPermanent(jobId, new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
            PermanentBlobKey dataKey2 = server.putPermanent(jobId, new byte[]{11, 12, 13, 14, 15, 16, 17, 18});
            libCache = new BlobLibraryCacheManager((PermanentBlobService)cache, FlinkUserCodeClassLoaders.ResolveOrder.CHILD_FIRST, new String[0]);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(0, jobId, (PermanentBlobService)cache);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(new JobID()));
            try {
                libCache.getClassLoader(new JobID());
                Assert.fail((String)"Should fail with an IllegalStateException");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            Set<PermanentBlobKey> keys = Collections.singleton(dataKey1);
            cache.registerJob(jobId);
            ExecutionAttemptID executionId = new ExecutionAttemptID();
            libCache.registerTask(jobId, executionId, keys, Collections.emptyList());
            ClassLoader classLoader1 = libCache.getClassLoader(jobId);
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            Assert.assertNotNull((Object)libCache.getClassLoader(jobId));
            libCache.registerJob(jobId, keys, Collections.emptyList());
            ClassLoader classLoader2 = libCache.getClassLoader(jobId);
            Assert.assertEquals((Object)classLoader1, (Object)classLoader2);
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)2L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            Assert.assertNotNull((Object)libCache.getClassLoader(jobId));
            libCache.unregisterJob(jobId);
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)1L, (long)libCache.getNumberOfReferenceHolders(jobId));
            Assert.assertEquals((long)1L, (long)BlobServerCleanupTest.checkFilesExist(jobId, keys, cache, true));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            libCache.unregisterTask(jobId, executionId);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            libCache.unregisterJob(jobId);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            libCache.unregisterTask(jobId, executionId);
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfManagedJobs());
            Assert.assertEquals((long)0L, (long)libCache.getNumberOfReferenceHolders(jobId));
            cache.releaseJob(jobId);
            BlobServerCleanupTest.checkFileCountForJob(2, jobId, (PermanentBlobService)server);
            BlobServerCleanupTest.checkFileCountForJob(1, jobId, (PermanentBlobService)cache);
            cacheDir = cache.getStorageLocation(jobId, (BlobKey)new PermanentBlobKey()).getParentFile();
            Assert.assertTrue((boolean)cacheDir.exists());
            Assert.assertTrue((String)"Could not remove write permissions from cache directory", (boolean)cacheDir.setWritable(false, false));
            try {
                cache.registerJob(jobId);
                libCache.registerTask(jobId, new ExecutionAttemptID(), Collections.singleton(dataKey2), Collections.emptyList());
                Assert.fail((String)"This should fail with an IOException");
            }
            catch (IOException e) {
                cache.releaseJob(jobId);
            }
        }
        finally {
            if (cacheDir != null && !cacheDir.setWritable(true, false)) {
                System.err.println("Could not re-add write permissions to cache directory.");
            }
            if (cache != null) {
                cache.close();
            }
            if (libCache != null) {
                libCache.shutdown();
            }
            if (server != null) {
                server.close();
            }
        }
    }
}

