/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class ArchivedExecutionGraphTest
extends TestLogger {
    private static ExecutionGraph runtimeGraph;

    @BeforeClass
    public static void setupExecutionGraph() throws Exception {
        JobVertexID v1ID = new JobVertexID();
        JobVertexID v2ID = new JobVertexID();
        JobVertex v1 = new JobVertex("v1", v1ID);
        JobVertex v2 = new JobVertex("v2", v2ID);
        v1.setParallelism(1);
        v2.setParallelism(2);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        ArrayList<JobVertex> vertices = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        ExecutionConfig config = new ExecutionConfig();
        config.setExecutionMode(ExecutionMode.BATCH_FORCED);
        config.setRestartStrategy((RestartStrategies.RestartStrategyConfiguration)new RestartStrategies.NoRestartStrategyConfiguration());
        config.setParallelism(4);
        config.enableObjectReuse();
        config.setGlobalJobParameters((ExecutionConfig.GlobalJobParameters)new TestJobParameters());
        runtimeGraph = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), new JobID(), "test job", new Configuration(), new SerializedValue((Object)config), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)Mockito.mock(SlotProvider.class));
        runtimeGraph.attachJobGraph(vertices);
        ArrayList<ExecutionJobVertex> jobVertices = new ArrayList<ExecutionJobVertex>();
        jobVertices.add(runtimeGraph.getJobVertex(v1ID));
        jobVertices.add(runtimeGraph.getJobVertex(v2ID));
        CheckpointStatsTracker statsTracker = new CheckpointStatsTracker(0, jobVertices, (CheckpointCoordinatorConfiguration)Mockito.mock(CheckpointCoordinatorConfiguration.class), (MetricGroup)new UnregisteredMetricsGroup());
        runtimeGraph.enableCheckpointing(100L, 100L, 100L, 1, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (CheckpointIDCounter)new StandaloneCheckpointIDCounter(), (CompletedCheckpointStore)new StandaloneCompletedCheckpointStore(1), (StateBackend)new MemoryStateBackend(), statsTracker);
        runtimeGraph.setJsonPlan("{}");
        runtimeGraph.getJobVertex(v2ID).getTaskVertices()[0].getCurrentExecutionAttempt().fail((Throwable)new RuntimeException("This exception was thrown on purpose."));
    }

    @Test
    public void testArchive() throws IOException, ClassNotFoundException {
        ArchivedExecutionGraph archivedGraph = ArchivedExecutionGraph.createFrom((ExecutionGraph)runtimeGraph);
        ArchivedExecutionGraphTest.compareExecutionGraph((AccessExecutionGraph)runtimeGraph, (AccessExecutionGraph)archivedGraph);
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ArchivedExecutionGraph archivedGraph = ArchivedExecutionGraph.createFrom((ExecutionGraph)runtimeGraph);
        ArchivedExecutionGraphTest.verifySerializability(archivedGraph);
    }

    private static void compareExecutionGraph(AccessExecutionGraph runtimeGraph, AccessExecutionGraph archivedGraph) throws IOException, ClassNotFoundException {
        Assert.assertTrue((boolean)archivedGraph.isArchived());
        Assert.assertEquals((Object)runtimeGraph.getJsonPlan(), (Object)archivedGraph.getJsonPlan());
        Assert.assertEquals((Object)runtimeGraph.getJobID(), (Object)archivedGraph.getJobID());
        Assert.assertEquals((Object)runtimeGraph.getJobName(), (Object)archivedGraph.getJobName());
        Assert.assertEquals((Object)runtimeGraph.getState(), (Object)archivedGraph.getState());
        Assert.assertEquals((Object)runtimeGraph.getFailureInfo().getExceptionAsString(), (Object)archivedGraph.getFailureInfo().getExceptionAsString());
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.CREATED), (long)archivedGraph.getStatusTimestamp(JobStatus.CREATED));
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.RUNNING), (long)archivedGraph.getStatusTimestamp(JobStatus.RUNNING));
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.FAILING), (long)archivedGraph.getStatusTimestamp(JobStatus.FAILING));
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.FAILED), (long)archivedGraph.getStatusTimestamp(JobStatus.FAILED));
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.CANCELLING), (long)archivedGraph.getStatusTimestamp(JobStatus.CANCELLING));
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.CANCELED), (long)archivedGraph.getStatusTimestamp(JobStatus.CANCELED));
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.FINISHED), (long)archivedGraph.getStatusTimestamp(JobStatus.FINISHED));
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.RESTARTING), (long)archivedGraph.getStatusTimestamp(JobStatus.RESTARTING));
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.SUSPENDING), (long)archivedGraph.getStatusTimestamp(JobStatus.SUSPENDING));
        Assert.assertEquals((long)runtimeGraph.getStatusTimestamp(JobStatus.SUSPENDED), (long)archivedGraph.getStatusTimestamp(JobStatus.SUSPENDED));
        Assert.assertEquals((Object)runtimeGraph.isStoppable(), (Object)archivedGraph.isStoppable());
        CheckpointStatsSnapshot runtimeSnapshot = runtimeGraph.getCheckpointStatsSnapshot();
        CheckpointStatsSnapshot archivedSnapshot = archivedGraph.getCheckpointStatsSnapshot();
        Assert.assertEquals((long)runtimeSnapshot.getSummaryStats().getEndToEndDurationStats().getAverage(), (long)archivedSnapshot.getSummaryStats().getEndToEndDurationStats().getAverage());
        Assert.assertEquals((long)runtimeSnapshot.getSummaryStats().getEndToEndDurationStats().getMinimum(), (long)archivedSnapshot.getSummaryStats().getEndToEndDurationStats().getMinimum());
        Assert.assertEquals((long)runtimeSnapshot.getSummaryStats().getEndToEndDurationStats().getMaximum(), (long)archivedSnapshot.getSummaryStats().getEndToEndDurationStats().getMaximum());
        Assert.assertEquals((long)runtimeSnapshot.getSummaryStats().getStateSizeStats().getAverage(), (long)archivedSnapshot.getSummaryStats().getStateSizeStats().getAverage());
        Assert.assertEquals((long)runtimeSnapshot.getSummaryStats().getStateSizeStats().getMinimum(), (long)archivedSnapshot.getSummaryStats().getStateSizeStats().getMinimum());
        Assert.assertEquals((long)runtimeSnapshot.getSummaryStats().getStateSizeStats().getMaximum(), (long)archivedSnapshot.getSummaryStats().getStateSizeStats().getMaximum());
        Assert.assertEquals((long)runtimeSnapshot.getCounts().getTotalNumberOfCheckpoints(), (long)archivedSnapshot.getCounts().getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)runtimeSnapshot.getCounts().getNumberOfCompletedCheckpoints(), (long)archivedSnapshot.getCounts().getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)runtimeSnapshot.getCounts().getNumberOfInProgressCheckpoints(), (long)archivedSnapshot.getCounts().getNumberOfInProgressCheckpoints());
        ArchivedExecutionConfig runtimeConfig = runtimeGraph.getArchivedExecutionConfig();
        ArchivedExecutionConfig archivedConfig = archivedGraph.getArchivedExecutionConfig();
        Assert.assertEquals((Object)runtimeConfig.getExecutionMode(), (Object)archivedConfig.getExecutionMode());
        Assert.assertEquals((long)runtimeConfig.getParallelism(), (long)archivedConfig.getParallelism());
        Assert.assertEquals((Object)runtimeConfig.getObjectReuseEnabled(), (Object)archivedConfig.getObjectReuseEnabled());
        Assert.assertEquals((Object)runtimeConfig.getRestartStrategyDescription(), (Object)archivedConfig.getRestartStrategyDescription());
        Assert.assertNotNull(archivedConfig.getGlobalJobParameters().get("hello"));
        Assert.assertEquals(runtimeConfig.getGlobalJobParameters().get("hello"), archivedConfig.getGlobalJobParameters().get("hello"));
        ArchivedExecutionGraphTest.compareStringifiedAccumulators(runtimeGraph.getAccumulatorResultsStringified(), archivedGraph.getAccumulatorResultsStringified());
        ArchivedExecutionGraphTest.compareSerializedAccumulators(runtimeGraph.getAccumulatorsSerialized(), archivedGraph.getAccumulatorsSerialized());
        Map runtimeVertices = runtimeGraph.getAllVertices();
        Map archivedVertices = archivedGraph.getAllVertices();
        for (Map.Entry vertex : runtimeVertices.entrySet()) {
            ArchivedExecutionGraphTest.compareExecutionJobVertex((AccessExecutionJobVertex)vertex.getValue(), (AccessExecutionJobVertex)archivedVertices.get(vertex.getKey()));
        }
        Iterator runtimeTopologicalVertices = runtimeGraph.getVerticesTopologically().iterator();
        Iterator archiveTopologicaldVertices = archivedGraph.getVerticesTopologically().iterator();
        while (runtimeTopologicalVertices.hasNext()) {
            Assert.assertTrue((boolean)archiveTopologicaldVertices.hasNext());
            ArchivedExecutionGraphTest.compareExecutionJobVertex((AccessExecutionJobVertex)runtimeTopologicalVertices.next(), (AccessExecutionJobVertex)archiveTopologicaldVertices.next());
        }
        Iterator runtimeExecutionVertices = runtimeGraph.getAllExecutionVertices().iterator();
        Iterator archivedExecutionVertices = archivedGraph.getAllExecutionVertices().iterator();
        while (runtimeExecutionVertices.hasNext()) {
            Assert.assertTrue((boolean)archivedExecutionVertices.hasNext());
            ArchivedExecutionGraphTest.compareExecutionVertex((AccessExecutionVertex)runtimeExecutionVertices.next(), (AccessExecutionVertex)archivedExecutionVertices.next());
        }
    }

    private static void compareExecutionJobVertex(AccessExecutionJobVertex runtimeJobVertex, AccessExecutionJobVertex archivedJobVertex) {
        Assert.assertEquals((Object)runtimeJobVertex.getName(), (Object)archivedJobVertex.getName());
        Assert.assertEquals((long)runtimeJobVertex.getParallelism(), (long)archivedJobVertex.getParallelism());
        Assert.assertEquals((long)runtimeJobVertex.getMaxParallelism(), (long)archivedJobVertex.getMaxParallelism());
        Assert.assertEquals((Object)runtimeJobVertex.getJobVertexId(), (Object)archivedJobVertex.getJobVertexId());
        Assert.assertEquals((Object)runtimeJobVertex.getAggregateState(), (Object)archivedJobVertex.getAggregateState());
        ArchivedExecutionGraphTest.compareStringifiedAccumulators(runtimeJobVertex.getAggregatedUserAccumulatorsStringified(), archivedJobVertex.getAggregatedUserAccumulatorsStringified());
        AccessExecutionVertex[] runtimeExecutionVertices = runtimeJobVertex.getTaskVertices();
        AccessExecutionVertex[] archivedExecutionVertices = archivedJobVertex.getTaskVertices();
        Assert.assertEquals((long)runtimeExecutionVertices.length, (long)archivedExecutionVertices.length);
        for (int x = 0; x < runtimeExecutionVertices.length; ++x) {
            ArchivedExecutionGraphTest.compareExecutionVertex(runtimeExecutionVertices[x], archivedExecutionVertices[x]);
        }
    }

    private static void compareExecutionVertex(AccessExecutionVertex runtimeVertex, AccessExecutionVertex archivedVertex) {
        Assert.assertEquals((Object)runtimeVertex.getTaskNameWithSubtaskIndex(), (Object)archivedVertex.getTaskNameWithSubtaskIndex());
        Assert.assertEquals((long)runtimeVertex.getParallelSubtaskIndex(), (long)archivedVertex.getParallelSubtaskIndex());
        Assert.assertEquals((Object)runtimeVertex.getExecutionState(), (Object)archivedVertex.getExecutionState());
        Assert.assertEquals((long)runtimeVertex.getStateTimestamp(ExecutionState.CREATED), (long)archivedVertex.getStateTimestamp(ExecutionState.CREATED));
        Assert.assertEquals((long)runtimeVertex.getStateTimestamp(ExecutionState.SCHEDULED), (long)archivedVertex.getStateTimestamp(ExecutionState.SCHEDULED));
        Assert.assertEquals((long)runtimeVertex.getStateTimestamp(ExecutionState.DEPLOYING), (long)archivedVertex.getStateTimestamp(ExecutionState.DEPLOYING));
        Assert.assertEquals((long)runtimeVertex.getStateTimestamp(ExecutionState.RUNNING), (long)archivedVertex.getStateTimestamp(ExecutionState.RUNNING));
        Assert.assertEquals((long)runtimeVertex.getStateTimestamp(ExecutionState.FINISHED), (long)archivedVertex.getStateTimestamp(ExecutionState.FINISHED));
        Assert.assertEquals((long)runtimeVertex.getStateTimestamp(ExecutionState.CANCELING), (long)archivedVertex.getStateTimestamp(ExecutionState.CANCELING));
        Assert.assertEquals((long)runtimeVertex.getStateTimestamp(ExecutionState.CANCELED), (long)archivedVertex.getStateTimestamp(ExecutionState.CANCELED));
        Assert.assertEquals((long)runtimeVertex.getStateTimestamp(ExecutionState.FAILED), (long)archivedVertex.getStateTimestamp(ExecutionState.FAILED));
        Assert.assertEquals((Object)runtimeVertex.getFailureCauseAsString(), (Object)archivedVertex.getFailureCauseAsString());
        Assert.assertEquals((Object)runtimeVertex.getCurrentAssignedResourceLocation(), (Object)archivedVertex.getCurrentAssignedResourceLocation());
        ArchivedExecutionGraphTest.compareExecution(runtimeVertex.getCurrentExecutionAttempt(), archivedVertex.getCurrentExecutionAttempt());
    }

    private static void compareExecution(AccessExecution runtimeExecution, AccessExecution archivedExecution) {
        Assert.assertEquals((Object)runtimeExecution.getAttemptId(), (Object)archivedExecution.getAttemptId());
        Assert.assertEquals((long)runtimeExecution.getAttemptNumber(), (long)archivedExecution.getAttemptNumber());
        Assert.assertArrayEquals((long[])runtimeExecution.getStateTimestamps(), (long[])archivedExecution.getStateTimestamps());
        Assert.assertEquals((Object)runtimeExecution.getState(), (Object)archivedExecution.getState());
        Assert.assertEquals((Object)runtimeExecution.getAssignedResourceLocation(), (Object)archivedExecution.getAssignedResourceLocation());
        Assert.assertEquals((Object)runtimeExecution.getFailureCauseAsString(), (Object)archivedExecution.getFailureCauseAsString());
        Assert.assertEquals((long)runtimeExecution.getStateTimestamp(ExecutionState.CREATED), (long)archivedExecution.getStateTimestamp(ExecutionState.CREATED));
        Assert.assertEquals((long)runtimeExecution.getStateTimestamp(ExecutionState.SCHEDULED), (long)archivedExecution.getStateTimestamp(ExecutionState.SCHEDULED));
        Assert.assertEquals((long)runtimeExecution.getStateTimestamp(ExecutionState.DEPLOYING), (long)archivedExecution.getStateTimestamp(ExecutionState.DEPLOYING));
        Assert.assertEquals((long)runtimeExecution.getStateTimestamp(ExecutionState.RUNNING), (long)archivedExecution.getStateTimestamp(ExecutionState.RUNNING));
        Assert.assertEquals((long)runtimeExecution.getStateTimestamp(ExecutionState.FINISHED), (long)archivedExecution.getStateTimestamp(ExecutionState.FINISHED));
        Assert.assertEquals((long)runtimeExecution.getStateTimestamp(ExecutionState.CANCELING), (long)archivedExecution.getStateTimestamp(ExecutionState.CANCELING));
        Assert.assertEquals((long)runtimeExecution.getStateTimestamp(ExecutionState.CANCELED), (long)archivedExecution.getStateTimestamp(ExecutionState.CANCELED));
        Assert.assertEquals((long)runtimeExecution.getStateTimestamp(ExecutionState.FAILED), (long)archivedExecution.getStateTimestamp(ExecutionState.FAILED));
        ArchivedExecutionGraphTest.compareStringifiedAccumulators(runtimeExecution.getUserAccumulatorsStringified(), archivedExecution.getUserAccumulatorsStringified());
        Assert.assertEquals((long)runtimeExecution.getParallelSubtaskIndex(), (long)archivedExecution.getParallelSubtaskIndex());
    }

    private static void compareStringifiedAccumulators(StringifiedAccumulatorResult[] runtimeAccs, StringifiedAccumulatorResult[] archivedAccs) {
        Assert.assertEquals((long)runtimeAccs.length, (long)archivedAccs.length);
        for (int x = 0; x < runtimeAccs.length; ++x) {
            StringifiedAccumulatorResult runtimeResult = runtimeAccs[x];
            StringifiedAccumulatorResult archivedResult = archivedAccs[x];
            Assert.assertEquals((Object)runtimeResult.getName(), (Object)archivedResult.getName());
            Assert.assertEquals((Object)runtimeResult.getType(), (Object)archivedResult.getType());
            Assert.assertEquals((Object)runtimeResult.getValue(), (Object)archivedResult.getValue());
        }
    }

    private static void compareSerializedAccumulators(Map<String, SerializedValue<OptionalFailure<Object>>> runtimeAccs, Map<String, SerializedValue<OptionalFailure<Object>>> archivedAccs) throws IOException, ClassNotFoundException {
        Assert.assertEquals((long)runtimeAccs.size(), (long)archivedAccs.size());
        for (Map.Entry<String, SerializedValue<OptionalFailure<Object>>> runtimeAcc : runtimeAccs.entrySet()) {
            long runtimeUserAcc = (Long)((OptionalFailure)runtimeAcc.getValue().deserializeValue(ClassLoader.getSystemClassLoader())).getUnchecked();
            long archivedUserAcc = (Long)((OptionalFailure)archivedAccs.get(runtimeAcc.getKey()).deserializeValue(ClassLoader.getSystemClassLoader())).getUnchecked();
            Assert.assertEquals((long)runtimeUserAcc, (long)archivedUserAcc);
        }
    }

    private static void verifySerializability(ArchivedExecutionGraph graph) throws IOException, ClassNotFoundException {
        ArchivedExecutionGraph copy = (ArchivedExecutionGraph)CommonTestUtils.createCopySerializable((Serializable)graph);
        ArchivedExecutionGraphTest.compareExecutionGraph((AccessExecutionGraph)graph, (AccessExecutionGraph)copy);
    }

    private static class TestJobParameters
    extends ExecutionConfig.GlobalJobParameters {
        private static final long serialVersionUID = -8118611781035212808L;
        private Map<String, String> parameters = new HashMap<String, String>();

        private TestJobParameters() {
            this.parameters.put("hello", "world");
        }

        public Map<String, String> toMap() {
            return this.parameters;
        }
    }
}

