/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.junit.Assert;
import org.junit.Test;

public class ErrorInfoTest {
    @Test
    public void testSerializationWithExceptionOutsideClassLoader() throws Exception {
        ErrorInfo error = new ErrorInfo((Throwable)new ExceptionWithCustomClassLoader(), System.currentTimeMillis());
        ErrorInfo copy = (ErrorInfo)CommonTestUtils.createCopySerializable((Serializable)error);
        Assert.assertEquals((long)error.getTimestamp(), (long)copy.getTimestamp());
        Assert.assertEquals((Object)error.getExceptionAsString(), (Object)copy.getExceptionAsString());
        Assert.assertEquals((Object)error.getException().getMessage(), (Object)copy.getException().getMessage());
    }

    private static final class ExceptionWithCustomClassLoader
    extends Exception {
        private static final long serialVersionUID = 42L;
        private static final ClassLoader CUSTOM_LOADER = new URLClassLoader(new URL[0]);
        private final Serializable outOfClassLoader = CommonTestUtils.createObjectForClassNotInClassPath((ClassLoader)CUSTOM_LOADER);

        public ExceptionWithCustomClassLoader() {
            super("tada");
        }
    }
}

