/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.function.Predicate;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.SchedulerTestBase;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.util.FlinkException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionGraphCoLocationRestartTest
extends SchedulerTestBase {
    private static final int NUM_TASKS = 31;

    @Test
    public void testConstraintsAfterRestart() throws Exception {
        long timeout = 5000L;
        this.testingSlotProvider.addTaskManager(31);
        JobVertex groupVertex = ExecutionGraphTestUtils.createNoOpVertex(31);
        JobVertex groupVertex2 = ExecutionGraphTestUtils.createNoOpVertex(31);
        SlotSharingGroup sharingGroup = new SlotSharingGroup();
        groupVertex.setSlotSharingGroup(sharingGroup);
        groupVertex2.setSlotSharingGroup(sharingGroup);
        groupVertex.setStrictlyCoLocatedWith(groupVertex2);
        ExecutionGraph eg = ExecutionGraphTestUtils.createSimpleTestGraph(new JobID(), this.testingSlotProvider, (RestartStrategy)new OneTimeDirectRestartStrategy(), groupVertex, groupVertex2);
        eg.setQueuedSchedulingAllowed(true);
        Assert.assertEquals((Object)JobStatus.CREATED, (Object)eg.getState());
        eg.scheduleForExecution();
        Predicate<Execution> isDeploying = ExecutionGraphTestUtils.isInExecutionState(ExecutionState.DEPLOYING);
        ExecutionGraphTestUtils.waitForAllExecutionsPredicate(eg, isDeploying, 5000L);
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        this.validateConstraints(eg);
        ExecutionGraphTestUtils.failExecutionGraph(eg, (Exception)new FlinkException("Test exception"));
        ExecutionGraphTestUtils.waitUntilJobStatus(eg, JobStatus.RUNNING, 5000L);
        ExecutionGraphTestUtils.waitForAllExecutionsPredicate(eg, isDeploying, 5000L);
        this.validateConstraints(eg);
        ExecutionGraphTestUtils.finishAllVertices(eg);
        Assert.assertThat((Object)eg.getState(), (Matcher)Matchers.is((Object)JobStatus.FINISHED));
    }

    private void validateConstraints(ExecutionGraph eg) {
        ExecutionJobVertex[] tasks = eg.getAllVertices().values().toArray(new ExecutionJobVertex[2]);
        for (int i = 0; i < 31; ++i) {
            CoLocationConstraint constr1 = tasks[0].getTaskVertices()[i].getLocationConstraint();
            CoLocationConstraint constr2 = tasks[1].getTaskVertices()[i].getLocationConstraint();
            Assert.assertThat((Object)constr1.isAssigned(), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)constr1.getLocation(), (Matcher)Matchers.equalTo((Object)constr2.getLocation()));
        }
    }

    private static final class OneTimeDirectRestartStrategy
    implements RestartStrategy {
        private boolean hasRestarted = false;

        private OneTimeDirectRestartStrategy() {
        }

        public boolean canRestart() {
            return !this.hasRestarted;
        }

        public void restart(RestartCallback restarter, ScheduledExecutor executor) {
            this.hasRestarted = true;
            restarter.triggerFullRecovery();
        }
    }
}

