/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.net.InetAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.VoidBlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.ProgrammedSlotProvider;
import org.apache.flink.runtime.executiongraph.TestingSlotProvider;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.DummySlotOwner;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TestingSlotOwner;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SingleLogicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.Timeout;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class ExecutionGraphSchedulingTest
extends TestLogger {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    @After
    public void shutdown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testScheduleSourceBeforeTarget() throws Exception {
        boolean parallelism = true;
        JobVertex sourceVertex = new JobVertex("source");
        sourceVertex.setParallelism(1);
        sourceVertex.setInvokableClass(NoOpInvokable.class);
        JobVertex targetVertex = new JobVertex("target");
        targetVertex.setParallelism(1);
        targetVertex.setInvokableClass(NoOpInvokable.class);
        targetVertex.connectNewDataSetAsInput(sourceVertex, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
        JobID jobId = new JobID();
        JobGraph jobGraph = new JobGraph(jobId, "test", new JobVertex[]{sourceVertex, targetVertex});
        CompletableFuture<LogicalSlot> sourceFuture = new CompletableFuture<LogicalSlot>();
        CompletableFuture<LogicalSlot> targetFuture = new CompletableFuture<LogicalSlot>();
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(1);
        slotProvider.addSlot(sourceVertex.getID(), 0, sourceFuture);
        slotProvider.addSlot(targetVertex.getID(), 0, targetFuture);
        ExecutionGraph eg = this.createExecutionGraph(jobGraph, slotProvider);
        TaskManagerGateway gatewaySource = ExecutionGraphSchedulingTest.createTaskManager();
        TaskManagerGateway gatewayTarget = ExecutionGraphSchedulingTest.createTaskManager();
        SimpleSlot sourceSlot = this.createSlot(gatewaySource, jobId);
        SimpleSlot targetSlot = this.createSlot(gatewayTarget, jobId);
        eg.setScheduleMode(ScheduleMode.EAGER);
        eg.setQueuedSchedulingAllowed(true);
        eg.scheduleForExecution();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        targetFuture.complete((LogicalSlot)targetSlot);
        ((TaskManagerGateway)Mockito.verify((Object)gatewayTarget, (VerificationMode)new Timeout(50L, Mockito.times((int)0)))).submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class));
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        sourceFuture.complete((LogicalSlot)sourceSlot);
        ((TaskManagerGateway)Mockito.verify((Object)gatewaySource, (VerificationMode)Mockito.timeout((long)1000L))).submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class));
        ((TaskManagerGateway)Mockito.verify((Object)gatewayTarget, (VerificationMode)Mockito.timeout((long)1000L))).submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class));
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
    }

    @Test
    public void testDeployPipelinedConnectedComponentsTogether() throws Exception {
        int i;
        int parallelism = 8;
        JobVertex sourceVertex = new JobVertex("source");
        sourceVertex.setParallelism(8);
        sourceVertex.setInvokableClass(NoOpInvokable.class);
        JobVertex targetVertex = new JobVertex("target");
        targetVertex.setParallelism(8);
        targetVertex.setInvokableClass(NoOpInvokable.class);
        targetVertex.connectNewDataSetAsInput(sourceVertex, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
        JobID jobId = new JobID();
        JobGraph jobGraph = new JobGraph(jobId, "test", new JobVertex[]{sourceVertex, targetVertex});
        CompletableFuture[] sourceFutures = new CompletableFuture[8];
        CompletableFuture[] targetFutures = new CompletableFuture[8];
        TaskManagerGateway[] sourceTaskManagers = new TaskManagerGateway[8];
        TaskManagerGateway[] targetTaskManagers = new TaskManagerGateway[8];
        SimpleSlot[] sourceSlots = new SimpleSlot[8];
        SimpleSlot[] targetSlots = new SimpleSlot[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            sourceTaskManagers[i2] = ExecutionGraphSchedulingTest.createTaskManager();
            targetTaskManagers[i2] = ExecutionGraphSchedulingTest.createTaskManager();
            sourceSlots[i2] = this.createSlot(sourceTaskManagers[i2], jobId);
            targetSlots[i2] = this.createSlot(targetTaskManagers[i2], jobId);
            sourceFutures[i2] = new CompletableFuture();
            targetFutures[i2] = new CompletableFuture();
        }
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(8);
        slotProvider.addSlots(sourceVertex.getID(), sourceFutures);
        slotProvider.addSlots(targetVertex.getID(), targetFutures);
        ExecutionGraph eg = this.createExecutionGraph(jobGraph, slotProvider);
        for (i = 0; i < 8; i += 2) {
            sourceFutures[i].complete(sourceSlots[i]);
        }
        eg.setScheduleMode(ScheduleMode.EAGER);
        eg.setQueuedSchedulingAllowed(true);
        eg.scheduleForExecution();
        ExecutionGraphSchedulingTest.verifyNothingDeployed(eg, sourceTaskManagers);
        for (i = 1; i < 8; i += 2) {
            sourceFutures[i].complete(sourceSlots[i]);
        }
        ExecutionGraphSchedulingTest.verifyNothingDeployed(eg, sourceTaskManagers);
        for (i = 1; i < 8; ++i) {
            targetFutures[i].complete(targetSlots[i]);
        }
        ExecutionGraphSchedulingTest.verifyNothingDeployed(eg, targetTaskManagers);
        targetFutures[0].complete(targetSlots[0]);
        for (TaskManagerGateway gateway : sourceTaskManagers) {
            ((TaskManagerGateway)Mockito.verify((Object)gateway, (VerificationMode)Mockito.timeout((long)500L))).submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class));
        }
        for (TaskManagerGateway gateway : targetTaskManagers) {
            ((TaskManagerGateway)Mockito.verify((Object)gateway, (VerificationMode)Mockito.timeout((long)500L))).submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class));
        }
    }

    @Test
    public void testOneSlotFailureAbortsDeploy() throws Exception {
        int i;
        int parallelism = 6;
        JobVertex sourceVertex = new JobVertex("source");
        sourceVertex.setParallelism(6);
        sourceVertex.setInvokableClass(NoOpInvokable.class);
        JobVertex targetVertex = new JobVertex("target");
        targetVertex.setParallelism(6);
        targetVertex.setInvokableClass(NoOpInvokable.class);
        targetVertex.connectNewDataSetAsInput(sourceVertex, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        JobID jobId = new JobID();
        JobGraph jobGraph = new JobGraph(jobId, "test", new JobVertex[]{sourceVertex, targetVertex});
        TaskManagerGateway taskManager = (TaskManagerGateway)Mockito.mock(TaskManagerGateway.class);
        ArrayBlockingQueue returnedSlots = new ArrayBlockingQueue(6);
        TestingSlotOwner slotOwner = new TestingSlotOwner();
        slotOwner.setReturnAllocatedSlotConsumer(logicalSlot -> returnedSlots.offer(logicalSlot.getAllocationId()));
        SimpleSlot[] sourceSlots = new SimpleSlot[6];
        SimpleSlot[] targetSlots = new SimpleSlot[6];
        CompletableFuture[] sourceFutures = new CompletableFuture[6];
        CompletableFuture[] targetFutures = new CompletableFuture[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            sourceSlots[i2] = this.createSlot(taskManager, jobId, slotOwner);
            targetSlots[i2] = this.createSlot(taskManager, jobId, slotOwner);
            sourceFutures[i2] = new CompletableFuture();
            targetFutures[i2] = new CompletableFuture();
        }
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(6);
        slotProvider.addSlots(sourceVertex.getID(), sourceFutures);
        slotProvider.addSlots(targetVertex.getID(), targetFutures);
        ExecutionGraph eg = this.createExecutionGraph(jobGraph, slotProvider);
        for (i = 0; i < 6; i += 2) {
            sourceFutures[i].complete(sourceSlots[i]);
            targetFutures[i].complete(targetSlots[i]);
        }
        eg.setScheduleMode(ScheduleMode.EAGER);
        eg.setQueuedSchedulingAllowed(true);
        eg.scheduleForExecution();
        sourceFutures[1].completeExceptionally(new TestRuntimeException());
        eg.getTerminationFuture().get(2000L, TimeUnit.MILLISECONDS);
        for (i = 0; i < 6; ++i) {
            returnedSlots.poll(2000L, TimeUnit.MILLISECONDS);
        }
        ((TaskManagerGateway)Mockito.verify((Object)taskManager, (VerificationMode)Mockito.times((int)0))).submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class));
        for (i = 0; i < 6; i += 2) {
            Assert.assertTrue((boolean)sourceSlots[i].isCanceled());
            Assert.assertTrue((boolean)targetSlots[i].isCanceled());
        }
    }

    @Test
    public void testEagerSchedulingWithSlotTimeout() throws Exception {
        int parallelism = 3;
        JobVertex vertex = new JobVertex("task");
        vertex.setParallelism(3);
        vertex.setInvokableClass(NoOpInvokable.class);
        JobID jobId = new JobID();
        JobGraph jobGraph = new JobGraph(jobId, "test", new JobVertex[]{vertex});
        ArrayBlockingQueue returnedSlots = new ArrayBlockingQueue(2);
        TestingSlotOwner slotOwner = new TestingSlotOwner();
        slotOwner.setReturnAllocatedSlotConsumer(logicalSlot -> returnedSlots.offer(logicalSlot.getAllocationId()));
        TaskManagerGateway taskManager = (TaskManagerGateway)Mockito.mock(TaskManagerGateway.class);
        SimpleSlot[] slots = new SimpleSlot[3];
        CompletableFuture[] slotFutures = new CompletableFuture[3];
        for (int i = 0; i < 3; ++i) {
            slots[i] = this.createSlot(taskManager, jobId, slotOwner);
            slotFutures[i] = new CompletableFuture();
        }
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(3);
        slotProvider.addSlots(vertex.getID(), slotFutures);
        ExecutionGraph eg = this.createExecutionGraph(jobGraph, slotProvider);
        slotFutures[1].complete(slots[1]);
        eg.setScheduleMode(ScheduleMode.EAGER);
        eg.setQueuedSchedulingAllowed(true);
        eg.scheduleForExecution();
        slotFutures[2].complete(slots[2]);
        Assert.assertThat((Object)eg.getTerminationFuture().isDone(), (Matcher)Matchers.is((Object)false));
        slotFutures[0].completeExceptionally(new TimeoutException("Test time out"));
        Assert.assertThat(eg.getTerminationFuture().get(), (Matcher)Matchers.is((Object)JobStatus.FAILED));
        for (int i = 0; i < 2; ++i) {
            returnedSlots.poll(2000L, TimeUnit.MILLISECONDS);
        }
        ((TaskManagerGateway)Mockito.verify((Object)taskManager, (VerificationMode)Mockito.times((int)0))).submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class));
    }

    @Test
    public void testSchedulingOperationCancellationWhenCancel() throws Exception {
        JobVertex jobVertex = new JobVertex("NoOp JobVertex");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        jobVertex.setParallelism(2);
        JobGraph jobGraph = new JobGraph(new JobVertex[]{jobVertex});
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        jobGraph.setAllowQueuedScheduling(true);
        CompletableFuture<TestingLogicalSlot> slotFuture1 = new CompletableFuture<TestingLogicalSlot>();
        CompletableFuture<TestingLogicalSlot> slotFuture2 = new CompletableFuture<TestingLogicalSlot>();
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(2);
        slotProvider.addSlots(jobVertex.getID(), new CompletableFuture[]{slotFuture1, slotFuture2});
        ExecutionGraph executionGraph = this.createExecutionGraph(jobGraph, slotProvider);
        executionGraph.scheduleForExecution();
        CompletableFuture<Object> releaseFuture = new CompletableFuture<Object>();
        TestingLogicalSlot slot = ExecutionGraphSchedulingTest.createTestingSlot(releaseFuture);
        slotFuture1.complete(slot);
        executionGraph.cancel();
        slotFuture2.complete(new TestingLogicalSlot());
        Thread.sleep(1L);
        releaseFuture.complete(null);
        Assert.assertThat(executionGraph.getTerminationFuture().get(), (Matcher)Matchers.is((Object)JobStatus.CANCELED));
    }

    @Test
    public void testSlotReleasingFailsSchedulingOperation() throws Exception {
        int parallelism = 2;
        JobVertex jobVertex = new JobVertex("Testing job vertex");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        jobVertex.setParallelism(2);
        JobGraph jobGraph = new JobGraph(new JobVertex[]{jobVertex});
        jobGraph.setAllowQueuedScheduling(true);
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(2);
        SimpleSlot slot = this.createSlot(new SimpleAckingTaskManagerGateway(), jobGraph.getJobID(), new DummySlotOwner());
        slotProvider.addSlot(jobVertex.getID(), 0, CompletableFuture.completedFuture(slot));
        CompletableFuture<LogicalSlot> slotFuture = new CompletableFuture<LogicalSlot>();
        slotProvider.addSlot(jobVertex.getID(), 1, slotFuture);
        ExecutionGraph executionGraph = this.createExecutionGraph(jobGraph, slotProvider);
        executionGraph.scheduleForExecution();
        Assert.assertThat((Object)executionGraph.getState(), (Matcher)Matchers.is((Object)JobStatus.RUNNING));
        ExecutionJobVertex executionJobVertex = executionGraph.getJobVertex(jobVertex.getID());
        ExecutionVertex[] taskVertices = executionJobVertex.getTaskVertices();
        Assert.assertThat((Object)taskVertices[0].getExecutionState(), (Matcher)Matchers.is((Object)ExecutionState.SCHEDULED));
        Assert.assertThat((Object)taskVertices[1].getExecutionState(), (Matcher)Matchers.is((Object)ExecutionState.SCHEDULED));
        slot.releaseSlot((Throwable)new FlinkException("Test failure"));
        Assert.assertThat(executionGraph.getTerminationFuture().get(), (Matcher)Matchers.is((Object)JobStatus.FAILED));
    }

    @Test
    public void testCancellationOfIncompleteScheduling() throws Exception {
        int parallelism = 10;
        JobVertex jobVertex = new JobVertex("Test job vertex");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        jobVertex.setParallelism(10);
        JobGraph jobGraph = new JobGraph(new JobVertex[]{jobVertex});
        jobGraph.setAllowQueuedScheduling(true);
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        TestingSlotOwner slotOwner = new TestingSlotOwner();
        SimpleAckingTaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
        ConcurrentHashMap slotRequestIds = new ConcurrentHashMap(10);
        CountDownLatch requestedSlotsLatch = new CountDownLatch(10);
        TestingSlotProvider slotProvider = new TestingSlotProvider(slotRequestId -> {
            slotRequestIds.put(slotRequestId, 1);
            requestedSlotsLatch.countDown();
            return new CompletableFuture();
        });
        ExecutionGraph executionGraph = this.createExecutionGraph(jobGraph, slotProvider);
        executionGraph.scheduleForExecution();
        requestedSlotsLatch.await();
        ConcurrentHashMap.KeySetView slotRequestIdsToReturn = ConcurrentHashMap.newKeySet(slotRequestIds.size());
        slotRequestIdsToReturn.addAll(slotRequestIds.keySet());
        CountDownLatch countDownLatch = new CountDownLatch(slotRequestIds.size());
        slotOwner.setReturnAllocatedSlotConsumer(logicalSlot -> {
            slotRequestIdsToReturn.remove(logicalSlot.getSlotRequestId());
            countDownLatch.countDown();
        });
        slotProvider.setSlotCanceller(slotRequestId -> {
            slotRequestIdsToReturn.remove(slotRequestId);
            countDownLatch.countDown();
        });
        OneShotLatch slotRequestsBeingFulfilled = new OneShotLatch();
        this.executor.execute(() -> {
            slotRequestsBeingFulfilled.trigger();
            for (SlotRequestId slotRequestId : slotRequestIds.keySet()) {
                SingleLogicalSlot singleLogicalSlot = ExecutionGraphSchedulingTest.createSingleLogicalSlot(slotOwner, taskManagerGateway, slotRequestId);
                slotProvider.complete(slotRequestId, (LogicalSlot)singleLogicalSlot);
            }
        });
        taskManagerGateway.setCancelConsumer(executionAttemptId -> {
            Execution execution = (Execution)executionGraph.getRegisteredExecutions().get(executionAttemptId);
            if (execution != null) {
                execution.cancelingComplete();
            }
        });
        slotRequestsBeingFulfilled.await();
        executionGraph.cancel();
        countDownLatch.await();
        Assert.assertThat(slotRequestIdsToReturn, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    private ExecutionGraph createExecutionGraph(JobGraph jobGraph, SlotProvider slotProvider) throws Exception {
        return this.createExecutionGraph(jobGraph, slotProvider, Time.minutes((long)10L));
    }

    private ExecutionGraph createExecutionGraph(JobGraph jobGraph, SlotProvider slotProvider, Time timeout) throws Exception {
        return ExecutionGraphBuilder.buildGraph(null, (JobGraph)jobGraph, (Configuration)new Configuration(), (ScheduledExecutorService)this.executor, (Executor)this.executor, (SlotProvider)slotProvider, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory(), (Time)timeout, (RestartStrategy)new NoRestartStrategy(), (MetricGroup)new UnregisteredMetricsGroup(), (int)1, (BlobWriter)VoidBlobWriter.getInstance(), (Time)timeout, (Logger)this.log);
    }

    private SimpleSlot createSlot(TaskManagerGateway taskManager, JobID jobId) {
        return this.createSlot(taskManager, jobId, (SlotOwner)Mockito.mock(SlotOwner.class));
    }

    private SimpleSlot createSlot(TaskManagerGateway taskManager, JobID jobId, SlotOwner slotOwner) {
        TaskManagerLocation location = new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 12345);
        SimpleSlotContext slot = new SimpleSlotContext(new AllocationID(), location, 0, taskManager);
        return new SimpleSlot((SlotContext)slot, slotOwner, 0);
    }

    @Nonnull
    static SingleLogicalSlot createSingleLogicalSlot(SlotOwner slotOwner, TaskManagerGateway taskManagerGateway, SlotRequestId slotRequestId) {
        TaskManagerLocation location = new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 12345);
        SimpleSlotContext slotContext = new SimpleSlotContext(new AllocationID(), location, 0, taskManagerGateway);
        return new SingleLogicalSlot(slotRequestId, (SlotContext)slotContext, null, Locality.LOCAL, slotOwner);
    }

    private static TaskManagerGateway createTaskManager() {
        TaskManagerGateway tm = (TaskManagerGateway)Mockito.mock(TaskManagerGateway.class);
        Mockito.when((Object)tm.submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class))).thenReturn(CompletableFuture.completedFuture(Acknowledge.get()));
        return tm;
    }

    private static void verifyNothingDeployed(ExecutionGraph eg, TaskManagerGateway[] taskManagers) {
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        for (TaskManagerGateway gateway : taskManagers) {
            ((TaskManagerGateway)Mockito.verify((Object)gateway, (VerificationMode)new Timeout(50L, Mockito.times((int)0)))).submitTask((TaskDeploymentDescriptor)Mockito.any(TaskDeploymentDescriptor.class), (Time)Mockito.any(Time.class));
        }
    }

    @Nonnull
    private static TestingLogicalSlot createTestingSlot(@Nullable CompletableFuture<?> releaseFuture) {
        return new TestingLogicalSlot(new LocalTaskManagerLocation(), new SimpleAckingTaskManagerGateway(), 0, new AllocationID(), new SlotRequestId(), new SlotSharingGroupId(), releaseFuture);
    }

    private static class TestRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private TestRuntimeException() {
        }
    }
}

