/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import akka.actor.Status;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.blob.VoidBlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.failover.FailoverRegion;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.executiongraph.utils.SimpleSlotProvider;
import org.apache.flink.runtime.instance.BaseTestingActorGateway;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.TaskMessages;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;

public class ExecutionGraphTestUtils {
    private static final Logger TEST_LOGGER = LoggerFactory.getLogger(ExecutionGraphTestUtils.class);
    static final Predicate<Execution> hasResourceAssigned = execution -> execution.getAssignedResource() != null;
    public static final String ERROR_MESSAGE = "test_failure_error_message";

    public static void waitUntilJobStatus(ExecutionGraph eg, JobStatus status, long maxWaitMillis) throws TimeoutException {
        long deadline;
        Preconditions.checkNotNull((Object)eg);
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkArgument((maxWaitMillis >= 0L ? 1 : 0) != 0);
        long l = deadline = maxWaitMillis == 0L ? Long.MAX_VALUE : System.nanoTime() + maxWaitMillis * 1000000L;
        while (eg.getState() != status && System.nanoTime() < deadline) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (System.nanoTime() >= deadline) {
            throw new TimeoutException(String.format("The job did not reach status %s in time. Current status is %s.", status, eg.getState()));
        }
    }

    public static void waitUntilExecutionState(Execution execution, ExecutionState state, long maxWaitMillis) throws TimeoutException {
        long deadline;
        Preconditions.checkNotNull((Object)execution);
        Preconditions.checkNotNull((Object)state);
        Preconditions.checkArgument((maxWaitMillis >= 0L ? 1 : 0) != 0);
        long l = deadline = maxWaitMillis == 0L ? Long.MAX_VALUE : System.nanoTime() + maxWaitMillis * 1000000L;
        while (execution.getState() != state && System.nanoTime() < deadline) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (System.nanoTime() >= deadline) {
            throw new TimeoutException(String.format("The execution did not reach state %s in time. Current state is %s.", state, execution.getState()));
        }
    }

    public static void waitUntilExecutionVertexState(ExecutionVertex executionVertex, ExecutionState state, long maxWaitMillis) throws TimeoutException {
        Execution execution;
        long deadline;
        Preconditions.checkNotNull((Object)executionVertex);
        Preconditions.checkNotNull((Object)state);
        Preconditions.checkArgument((maxWaitMillis >= 0L ? 1 : 0) != 0);
        long l = deadline = maxWaitMillis == 0L ? Long.MAX_VALUE : System.nanoTime() + maxWaitMillis * 1000000L;
        while ((execution = executionVertex.getCurrentExecutionAttempt()) == null || execution.getState() != state && System.nanoTime() < deadline) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.nanoTime() < deadline) continue;
            if (execution != null) {
                throw new TimeoutException(String.format("The execution vertex did not reach state %s in time. Current state is %s.", state, execution.getState()));
            }
            throw new TimeoutException("Cannot get current execution attempt of " + executionVertex + '.');
        }
    }

    public static void waitForAllExecutionsPredicate(ExecutionGraph executionGraph, Predicate<Execution> executionPredicate, long maxWaitMillis) throws TimeoutException {
        boolean predicateResult;
        Iterable allExecutionVertices = executionGraph.getAllExecutionVertices();
        Deadline deadline = Deadline.fromNow((Duration)Duration.ofMillis(maxWaitMillis));
        do {
            predicateResult = true;
            for (ExecutionVertex executionVertex : allExecutionVertices) {
                Execution currentExecution = executionVertex.getCurrentExecutionAttempt();
                if (currentExecution != null && executionPredicate.test(currentExecution)) continue;
                predicateResult = false;
                break;
            }
            if (predicateResult) continue;
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        } while (!predicateResult && deadline.hasTimeLeft());
        if (!predicateResult) {
            throw new TimeoutException("Not all executions fulfilled the predicate in time.");
        }
    }

    static Predicate<Execution> isInExecutionState(ExecutionState executionState) {
        return execution -> execution.getState() == executionState;
    }

    public static void waitUntilFailoverRegionState(FailoverRegion region, JobStatus status, long maxWaitMillis) throws TimeoutException {
        long deadline;
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkArgument((maxWaitMillis >= 0L ? 1 : 0) != 0);
        long l = deadline = maxWaitMillis == 0L ? Long.MAX_VALUE : System.nanoTime() + maxWaitMillis * 1000000L;
        while (region.getState() != status && System.nanoTime() < deadline) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (System.nanoTime() >= deadline) {
            throw new TimeoutException();
        }
    }

    public static void failExecutionGraph(ExecutionGraph executionGraph, Exception cause) {
        ((ExecutionVertex)executionGraph.getAllExecutionVertices().iterator().next()).fail((Throwable)cause);
        Assert.assertEquals((Object)JobStatus.FAILING, (Object)executionGraph.getState());
        for (ExecutionVertex vertex : executionGraph.getAllExecutionVertices()) {
            vertex.getCurrentExecutionAttempt().cancelingComplete();
        }
    }

    public static void switchAllVerticesToRunning(ExecutionGraph eg) {
        for (ExecutionVertex vertex : eg.getAllExecutionVertices()) {
            vertex.getCurrentExecutionAttempt().switchToRunning();
        }
    }

    public static void completeCancellingForAllVertices(ExecutionGraph eg) {
        for (ExecutionVertex vertex : eg.getAllExecutionVertices()) {
            vertex.getCurrentExecutionAttempt().cancelingComplete();
        }
    }

    public static void finishAllVertices(ExecutionGraph eg) {
        for (ExecutionVertex vertex : eg.getAllExecutionVertices()) {
            vertex.getCurrentExecutionAttempt().markFinished();
        }
    }

    public static void switchToRunning(ExecutionGraph eg) {
        Execution exec;
        for (ExecutionVertex ev : eg.getAllExecutionVertices()) {
            exec = ev.getCurrentExecutionAttempt();
            ExecutionState executionState = exec.getState();
            assert (executionState == ExecutionState.DEPLOYING) : "Expected executionState to be DEPLOYING, was: " + executionState;
        }
        for (ExecutionVertex ev : eg.getAllExecutionVertices()) {
            exec = ev.getCurrentExecutionAttempt();
            exec.switchToRunning();
        }
    }

    public static void setVertexState(ExecutionVertex vertex, ExecutionState state) {
        try {
            Execution exec = vertex.getCurrentExecutionAttempt();
            Field f = Execution.class.getDeclaredField("state");
            f.setAccessible(true);
            f.set(exec, state);
        }
        catch (Exception e) {
            throw new RuntimeException("Modifying the state failed", e);
        }
    }

    public static void setVertexResource(ExecutionVertex vertex, SimpleSlot slot) {
        Execution exec = vertex.getCurrentExecutionAttempt();
        if (!exec.tryAssignResource((LogicalSlot)slot)) {
            throw new RuntimeException("Could not assign resource.");
        }
    }

    public static SimpleSlot createMockSimpleSlot(TaskManagerGateway gateway) {
        TaskManagerLocation location = new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 6572);
        SimpleSlotContext allocatedSlot = new SimpleSlotContext(new AllocationID(), location, 0, gateway);
        return new SimpleSlot((SlotContext)allocatedSlot, (SlotOwner)Mockito.mock(SlotOwner.class), 0);
    }

    public static ExecutionGraph createSimpleTestGraph() throws Exception {
        return ExecutionGraphTestUtils.createSimpleTestGraph((RestartStrategy)new NoRestartStrategy());
    }

    public static ExecutionGraph createSimpleTestGraph(RestartStrategy restartStrategy) throws Exception {
        JobVertex vertex = ExecutionGraphTestUtils.createNoOpVertex(10);
        return ExecutionGraphTestUtils.createSimpleTestGraph(new JobID(), new SimpleAckingTaskManagerGateway(), restartStrategy, vertex);
    }

    public static ExecutionGraph createSimpleTestGraph(JobID jid, JobVertex ... vertices) throws Exception {
        return ExecutionGraphTestUtils.createSimpleTestGraph(jid, new SimpleAckingTaskManagerGateway(), (RestartStrategy)new NoRestartStrategy(), vertices);
    }

    public static ExecutionGraph createSimpleTestGraph(JobID jid, TaskManagerGateway taskManagerGateway, RestartStrategy restartStrategy, JobVertex ... vertices) throws Exception {
        int numSlotsNeeded = 0;
        for (JobVertex vertex : vertices) {
            numSlotsNeeded += vertex.getParallelism();
        }
        SimpleSlotProvider slotProvider = new SimpleSlotProvider(jid, numSlotsNeeded, taskManagerGateway);
        return ExecutionGraphTestUtils.createSimpleTestGraph(jid, slotProvider, restartStrategy, vertices);
    }

    public static ExecutionGraph createSimpleTestGraph(JobID jid, SlotProvider slotProvider, RestartStrategy restartStrategy, JobVertex ... vertices) throws Exception {
        return ExecutionGraphTestUtils.createExecutionGraph(jid, slotProvider, restartStrategy, TestingUtils.defaultExecutor(), vertices);
    }

    public static ExecutionGraph createExecutionGraph(JobID jid, SlotProvider slotProvider, RestartStrategy restartStrategy, ScheduledExecutorService executor, JobVertex ... vertices) throws Exception {
        return ExecutionGraphTestUtils.createExecutionGraph(jid, slotProvider, restartStrategy, executor, Time.seconds((long)10L), vertices);
    }

    public static ExecutionGraph createExecutionGraph(JobID jid, SlotProvider slotProvider, RestartStrategy restartStrategy, ScheduledExecutorService executor, Time timeout, JobVertex ... vertices) throws Exception {
        Preconditions.checkNotNull((Object)jid);
        Preconditions.checkNotNull((Object)restartStrategy);
        Preconditions.checkNotNull((Object)vertices);
        Preconditions.checkNotNull((Object)timeout);
        return ExecutionGraphBuilder.buildGraph(null, (JobGraph)new JobGraph(jid, "test job", vertices), (Configuration)new Configuration(), (ScheduledExecutorService)executor, (Executor)executor, (SlotProvider)slotProvider, (ClassLoader)ExecutionGraphTestUtils.class.getClassLoader(), (CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory(), (Time)timeout, (RestartStrategy)restartStrategy, (MetricGroup)new UnregisteredMetricsGroup(), (int)1, (BlobWriter)VoidBlobWriter.getInstance(), (Time)timeout, (Logger)TEST_LOGGER);
    }

    public static JobVertex createNoOpVertex(int parallelism) {
        JobVertex vertex = new JobVertex("vertex");
        vertex.setInvokableClass(NoOpInvokable.class);
        vertex.setParallelism(parallelism);
        return vertex;
    }

    public static Instance getInstance(TaskManagerGateway gateway) throws Exception {
        return ExecutionGraphTestUtils.getInstance(gateway, 1);
    }

    public static Instance getInstance(TaskManagerGateway gateway, int numberOfSlots) throws Exception {
        ResourceID resourceID = ResourceID.generate();
        HardwareDescription hardwareDescription = new HardwareDescription(4, 0x80000000L, 0x40000000L, 0x20000000L);
        InetAddress address = InetAddress.getByName("127.0.0.1");
        TaskManagerLocation connection = new TaskManagerLocation(resourceID, address, 10001);
        return new Instance(gateway, connection, new InstanceID(), hardwareDescription, numberOfSlots);
    }

    public static JobVertex createJobVertex(String task1, int numTasks, Class<NoOpInvokable> invokable) {
        JobVertex groupVertex = new JobVertex(task1);
        groupVertex.setInvokableClass(invokable);
        groupVertex.setParallelism(numTasks);
        return groupVertex;
    }

    public static ExecutionJobVertex getExecutionVertex(JobVertexID id, ScheduledExecutorService executor) throws Exception {
        JobVertex ajv = new JobVertex("TestVertex", id);
        ajv.setInvokableClass(((AbstractInvokable)Mockito.mock(AbstractInvokable.class)).getClass());
        ExecutionGraph graph = new ExecutionGraph(executor, (Executor)executor, new JobID(), "test job", new Configuration(), new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)new Scheduler((Executor)ExecutionContext$.MODULE$.fromExecutor((Executor)executor)));
        return (ExecutionJobVertex)Mockito.spy((Object)new ExecutionJobVertex(graph, ajv, 1, AkkaUtils.getDefaultTimeout()));
    }

    public static ExecutionJobVertex getExecutionVertex(JobVertexID id) throws Exception {
        return ExecutionGraphTestUtils.getExecutionVertex(id, TestingUtils.defaultExecutor());
    }

    public static void verifyGeneratedExecutionJobVertex(ExecutionGraph executionGraph, JobVertex originJobVertex, @Nullable List<JobVertex> inputJobVertices, @Nullable List<JobVertex> outputJobVertices) {
        ExecutionJobVertex ejv = (ExecutionJobVertex)executionGraph.getAllVertices().get(originJobVertex.getID());
        Assert.assertNotNull((Object)ejv);
        Assert.assertEquals((long)originJobVertex.getParallelism(), (long)ejv.getParallelism());
        Assert.assertEquals((Object)executionGraph.getJobID(), (Object)ejv.getJobId());
        Assert.assertEquals((Object)originJobVertex.getID(), (Object)ejv.getJobVertexId());
        Assert.assertEquals((Object)originJobVertex, (Object)ejv.getJobVertex());
        if (outputJobVertices == null) {
            Assert.assertEquals((long)0L, (long)ejv.getProducedDataSets().length);
        } else {
            Assert.assertEquals((long)outputJobVertices.size(), (long)ejv.getProducedDataSets().length);
            for (int i = 0; i < outputJobVertices.size(); ++i) {
                Assert.assertEquals((Object)((IntermediateDataSet)originJobVertex.getProducedDataSets().get(i)).getId(), (Object)ejv.getProducedDataSets()[i].getId());
                Assert.assertEquals((long)originJobVertex.getParallelism(), (long)ejv.getProducedDataSets()[0].getPartitions().length);
            }
        }
        Assert.assertEquals((long)originJobVertex.getParallelism(), (long)ejv.getTaskVertices().length);
        int subtaskIndex = 0;
        for (ExecutionVertex ev : ejv.getTaskVertices()) {
            Assert.assertEquals((Object)executionGraph.getJobID(), (Object)ev.getJobId());
            Assert.assertEquals((Object)originJobVertex.getID(), (Object)ev.getJobvertexId());
            Assert.assertEquals((long)originJobVertex.getParallelism(), (long)ev.getTotalNumberOfParallelSubtasks());
            Assert.assertEquals((long)subtaskIndex, (long)ev.getParallelSubtaskIndex());
            if (inputJobVertices == null) {
                Assert.assertEquals((long)0L, (long)ev.getNumberOfInputs());
            } else {
                Assert.assertEquals((long)inputJobVertices.size(), (long)ev.getNumberOfInputs());
                for (int i = 0; i < inputJobVertices.size(); ++i) {
                    ExecutionEdge[] inputEdges = ev.getInputEdges(i);
                    Assert.assertEquals((long)inputJobVertices.get(i).getParallelism(), (long)inputEdges.length);
                    int expectedPartitionNum = 0;
                    for (ExecutionEdge inEdge : inputEdges) {
                        Assert.assertEquals((long)i, (long)inEdge.getInputNum());
                        Assert.assertEquals((long)expectedPartitionNum, (long)inEdge.getSource().getPartitionNumber());
                        ++expectedPartitionNum;
                    }
                }
            }
            ++subtaskIndex;
        }
    }

    public static class SimpleFailingActorGateway
    extends BaseTestingActorGateway {
        public SimpleFailingActorGateway(ExecutionContext executionContext) {
            super(executionContext);
        }

        @Override
        public Object handleMessage(Object message) throws Exception {
            if (message instanceof TaskMessages.SubmitTask) {
                throw new Exception(ExecutionGraphTestUtils.ERROR_MESSAGE);
            }
            if (message instanceof TaskMessages.CancelTask) {
                TaskMessages.CancelTask cancelTask = (TaskMessages.CancelTask)message;
                return Acknowledge.get();
            }
            return null;
        }
    }

    public static class SimpleActorGatewayWithTDD
    extends SimpleActorGateway {
        public TaskDeploymentDescriptor lastTDD;
        private final PermanentBlobService blobCache;

        public SimpleActorGatewayWithTDD(ExecutionContext executionContext, PermanentBlobService blobCache) {
            super(executionContext);
            this.blobCache = blobCache;
        }

        @Override
        public Object handleMessage(Object message) {
            if (message instanceof TaskMessages.SubmitTask) {
                TaskMessages.SubmitTask submitTask = (TaskMessages.SubmitTask)message;
                this.lastTDD = submitTask.tasks();
                try {
                    this.lastTDD.loadBigData(this.blobCache);
                    return Acknowledge.get();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return new Status.Failure((Throwable)e);
                }
            }
            return super.handleMessage(message);
        }
    }

    public static class SimpleActorGateway
    extends BaseTestingActorGateway {
        public SimpleActorGateway(ExecutionContext executionContext) {
            super(executionContext);
        }

        @Override
        public Object handleMessage(Object message) {
            if (message instanceof TaskMessages.SubmitTask) {
                TaskMessages.SubmitTask submitTask = (TaskMessages.SubmitTask)message;
                return Acknowledge.get();
            }
            if (message instanceof TaskMessages.CancelTask) {
                return Acknowledge.get();
            }
            if (message instanceof TaskMessages.FailIntermediateResultPartitions) {
                return new Object();
            }
            return null;
        }
    }
}

