/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class PointwisePatternTest {
    private final JobID jobId = new JobID();
    private final String jobName = "Test Job Sample Name";
    private final Configuration cfg = new Configuration();

    @Test
    public void testNToN() throws Exception {
        int N = 23;
        JobVertex v1 = new JobVertex("vertex1");
        JobVertex v2 = new JobVertex("vertex2");
        v1.setParallelism(23);
        v2.setParallelism(23);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        ExecutionGraph eg = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), this.jobId, "Test Job Sample Name", this.cfg, new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()));
        try {
            eg.attachJobGraph(ordered);
        }
        catch (JobException e) {
            e.printStackTrace();
            Assert.fail((String)("Job failed with exception: " + e.getMessage()));
        }
        ExecutionJobVertex target = (ExecutionJobVertex)eg.getAllVertices().get(v2.getID());
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ExecutionEdge[] inEdges = ev.getInputEdges(0);
            Assert.assertEquals((long)1L, (long)inEdges.length);
            Assert.assertEquals((long)ev.getParallelSubtaskIndex(), (long)inEdges[0].getSource().getPartitionNumber());
        }
    }

    @Test
    public void test2NToN() throws Exception {
        int N = 17;
        JobVertex v1 = new JobVertex("vertex1");
        JobVertex v2 = new JobVertex("vertex2");
        v1.setParallelism(34);
        v2.setParallelism(17);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        ExecutionGraph eg = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), this.jobId, "Test Job Sample Name", this.cfg, new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()));
        try {
            eg.attachJobGraph(ordered);
        }
        catch (JobException e) {
            e.printStackTrace();
            Assert.fail((String)("Job failed with exception: " + e.getMessage()));
        }
        ExecutionJobVertex target = (ExecutionJobVertex)eg.getAllVertices().get(v2.getID());
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ExecutionEdge[] inEdges = ev.getInputEdges(0);
            Assert.assertEquals((long)2L, (long)inEdges.length);
            Assert.assertEquals((long)(ev.getParallelSubtaskIndex() * 2), (long)inEdges[0].getSource().getPartitionNumber());
            Assert.assertEquals((long)(ev.getParallelSubtaskIndex() * 2 + 1), (long)inEdges[1].getSource().getPartitionNumber());
        }
    }

    @Test
    public void test3NToN() throws Exception {
        int N = 17;
        JobVertex v1 = new JobVertex("vertex1");
        JobVertex v2 = new JobVertex("vertex2");
        v1.setParallelism(51);
        v2.setParallelism(17);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        ExecutionGraph eg = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), this.jobId, "Test Job Sample Name", this.cfg, new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()));
        try {
            eg.attachJobGraph(ordered);
        }
        catch (JobException e) {
            e.printStackTrace();
            Assert.fail((String)("Job failed with exception: " + e.getMessage()));
        }
        ExecutionJobVertex target = (ExecutionJobVertex)eg.getAllVertices().get(v2.getID());
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ExecutionEdge[] inEdges = ev.getInputEdges(0);
            Assert.assertEquals((long)3L, (long)inEdges.length);
            Assert.assertEquals((long)(ev.getParallelSubtaskIndex() * 3), (long)inEdges[0].getSource().getPartitionNumber());
            Assert.assertEquals((long)(ev.getParallelSubtaskIndex() * 3 + 1), (long)inEdges[1].getSource().getPartitionNumber());
            Assert.assertEquals((long)(ev.getParallelSubtaskIndex() * 3 + 2), (long)inEdges[2].getSource().getPartitionNumber());
        }
    }

    @Test
    public void testNTo2N() throws Exception {
        int N = 41;
        JobVertex v1 = new JobVertex("vertex1");
        JobVertex v2 = new JobVertex("vertex2");
        v1.setParallelism(41);
        v2.setParallelism(82);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        ExecutionGraph eg = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), this.jobId, "Test Job Sample Name", this.cfg, new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()));
        try {
            eg.attachJobGraph(ordered);
        }
        catch (JobException e) {
            e.printStackTrace();
            Assert.fail((String)("Job failed with exception: " + e.getMessage()));
        }
        ExecutionJobVertex target = (ExecutionJobVertex)eg.getAllVertices().get(v2.getID());
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ExecutionEdge[] inEdges = ev.getInputEdges(0);
            Assert.assertEquals((long)1L, (long)inEdges.length);
            Assert.assertEquals((long)(ev.getParallelSubtaskIndex() / 2), (long)inEdges[0].getSource().getPartitionNumber());
        }
    }

    @Test
    public void testNTo7N() throws Exception {
        int N = 11;
        JobVertex v1 = new JobVertex("vertex1");
        JobVertex v2 = new JobVertex("vertex2");
        v1.setParallelism(11);
        v2.setParallelism(77);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        ExecutionGraph eg = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), this.jobId, "Test Job Sample Name", this.cfg, new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()));
        try {
            eg.attachJobGraph(ordered);
        }
        catch (JobException e) {
            e.printStackTrace();
            Assert.fail((String)("Job failed with exception: " + e.getMessage()));
        }
        ExecutionJobVertex target = (ExecutionJobVertex)eg.getAllVertices().get(v2.getID());
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ExecutionEdge[] inEdges = ev.getInputEdges(0);
            Assert.assertEquals((long)1L, (long)inEdges.length);
            Assert.assertEquals((long)(ev.getParallelSubtaskIndex() / 7), (long)inEdges[0].getSource().getPartitionNumber());
        }
    }

    @Test
    public void testLowHighIrregular() throws Exception {
        this.testLowToHigh(3, 16);
        this.testLowToHigh(19, 21);
        this.testLowToHigh(15, 20);
        this.testLowToHigh(11, 31);
    }

    @Test
    public void testHighLowIrregular() throws Exception {
        this.testHighToLow(16, 3);
        this.testHighToLow(21, 19);
        this.testHighToLow(20, 15);
        this.testHighToLow(31, 11);
    }

    private void testLowToHigh(int lowDop, int highDop) throws Exception {
        if (highDop < lowDop) {
            throw new IllegalArgumentException();
        }
        int factor = highDop / lowDop;
        int delta = highDop % lowDop == 0 ? 0 : 1;
        JobVertex v1 = new JobVertex("vertex1");
        JobVertex v2 = new JobVertex("vertex2");
        v1.setParallelism(lowDop);
        v2.setParallelism(highDop);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        ExecutionGraph eg = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), this.jobId, "Test Job Sample Name", this.cfg, new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()));
        try {
            eg.attachJobGraph(ordered);
        }
        catch (JobException e) {
            e.printStackTrace();
            Assert.fail((String)("Job failed with exception: " + e.getMessage()));
        }
        ExecutionJobVertex target = (ExecutionJobVertex)eg.getAllVertices().get(v2.getID());
        int[] timesUsed = new int[lowDop];
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ExecutionEdge[] inEdges = ev.getInputEdges(0);
            Assert.assertEquals((long)1L, (long)inEdges.length);
            int n = inEdges[0].getSource().getPartitionNumber();
            timesUsed[n] = timesUsed[n] + 1;
        }
        for (int used : timesUsed) {
            Assert.assertTrue((used >= factor && used <= factor + delta ? 1 : 0) != 0);
        }
    }

    private void testHighToLow(int highDop, int lowDop) throws Exception {
        if (highDop < lowDop) {
            throw new IllegalArgumentException();
        }
        int factor = highDop / lowDop;
        int delta = highDop % lowDop == 0 ? 0 : 1;
        JobVertex v1 = new JobVertex("vertex1");
        JobVertex v2 = new JobVertex("vertex2");
        v1.setParallelism(highDop);
        v2.setParallelism(lowDop);
        v1.setInvokableClass(AbstractInvokable.class);
        v2.setInvokableClass(AbstractInvokable.class);
        v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        ArrayList<JobVertex> ordered = new ArrayList<JobVertex>(Arrays.asList(v1, v2));
        ExecutionGraph eg = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), this.jobId, "Test Job Sample Name", this.cfg, new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()));
        try {
            eg.attachJobGraph(ordered);
        }
        catch (JobException e) {
            e.printStackTrace();
            Assert.fail((String)("Job failed with exception: " + e.getMessage()));
        }
        ExecutionJobVertex target = (ExecutionJobVertex)eg.getAllVertices().get(v2.getID());
        int[] timesUsed = new int[highDop];
        for (ExecutionVertex ev : target.getTaskVertices()) {
            Assert.assertEquals((long)1L, (long)ev.getNumberOfInputs());
            ExecutionEdge[] inEdges = ev.getInputEdges(0);
            Assert.assertTrue((inEdges.length >= factor && inEdges.length <= factor + delta ? 1 : 0) != 0);
            for (ExecutionEdge ee : inEdges) {
                int n = ee.getSource().getPartitionNumber();
                timesUsed[n] = timesUsed[n] + 1;
            }
        }
        for (int used : timesUsed) {
            Assert.assertEquals((long)1L, (long)used);
        }
    }
}

