/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.throwable.ThrowableAnnotation;
import org.apache.flink.runtime.throwable.ThrowableClassifier;
import org.apache.flink.runtime.throwable.ThrowableType;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ThrowableClassifierTest
extends TestLogger {
    @Test
    public void testThrowableType_NonRecoverable() {
        Assert.assertEquals((Object)ThrowableType.NonRecoverableError, (Object)ThrowableClassifier.getThrowableType((Throwable)new SuppressRestartsException((Throwable)new Exception(""))));
        Assert.assertEquals((Object)ThrowableType.NonRecoverableError, (Object)ThrowableClassifier.getThrowableType((Throwable)new NoResourceAvailableException()));
    }

    @Test
    public void testThrowableType_Recoverable() {
        Assert.assertEquals((Object)ThrowableType.RecoverableError, (Object)ThrowableClassifier.getThrowableType((Throwable)new Exception("")));
        Assert.assertEquals((Object)ThrowableType.RecoverableError, (Object)ThrowableClassifier.getThrowableType((Throwable)new ThrowableType_RecoverableFailure_Exception()));
    }

    @Test
    public void testThrowableType_EnvironmentError() {
        Assert.assertEquals((Object)ThrowableType.EnvironmentError, (Object)ThrowableClassifier.getThrowableType((Throwable)new ThrowableType_EnvironmentError_Exception()));
    }

    @Test
    public void testThrowableType_PartitionDataMissingError() {
        Assert.assertEquals((Object)ThrowableType.PartitionDataMissingError, (Object)ThrowableClassifier.getThrowableType((Throwable)new ThrowableType_PartitionDataMissingError_Exception()));
    }

    @Test
    public void testThrowableType_InheritError() {
        Assert.assertEquals((Object)ThrowableType.PartitionDataMissingError, (Object)ThrowableClassifier.getThrowableType((Throwable)new Sub_ThrowableType_PartitionDataMissingError_Exception()));
    }

    private class Sub_ThrowableType_PartitionDataMissingError_Exception
    extends ThrowableType_PartitionDataMissingError_Exception {
        private Sub_ThrowableType_PartitionDataMissingError_Exception() {
        }
    }

    @ThrowableAnnotation(value=ThrowableType.RecoverableError)
    private class ThrowableType_RecoverableFailure_Exception
    extends Exception {
        private ThrowableType_RecoverableFailure_Exception() {
        }
    }

    @ThrowableAnnotation(value=ThrowableType.EnvironmentError)
    private class ThrowableType_EnvironmentError_Exception
    extends Exception {
        private ThrowableType_EnvironmentError_Exception() {
        }
    }

    @ThrowableAnnotation(value=ThrowableType.PartitionDataMissingError)
    private class ThrowableType_PartitionDataMissingError_Exception
    extends Exception {
        private ThrowableType_PartitionDataMissingError_Exception() {
        }
    }
}

