/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.Scheduler;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.SerializedValue;
import org.junit.Assert;
import org.junit.Test;

public class VertexSlotSharingTest {
    @Test
    public void testAssignSlotSharingGroup() {
        try {
            JobVertex v1 = new JobVertex("v1");
            JobVertex v2 = new JobVertex("v2");
            JobVertex v3 = new JobVertex("v3");
            JobVertex v4 = new JobVertex("v4");
            JobVertex v5 = new JobVertex("v5");
            v1.setParallelism(4);
            v2.setParallelism(5);
            v3.setParallelism(7);
            v4.setParallelism(1);
            v5.setParallelism(11);
            v1.setInvokableClass(AbstractInvokable.class);
            v2.setInvokableClass(AbstractInvokable.class);
            v3.setInvokableClass(AbstractInvokable.class);
            v4.setInvokableClass(AbstractInvokable.class);
            v5.setInvokableClass(AbstractInvokable.class);
            v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            v5.connectNewDataSetAsInput(v4, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            SlotSharingGroup jg1 = new SlotSharingGroup();
            v2.setSlotSharingGroup(jg1);
            v3.setSlotSharingGroup(jg1);
            SlotSharingGroup jg2 = new SlotSharingGroup();
            v4.setSlotSharingGroup(jg2);
            v5.setSlotSharingGroup(jg2);
            ArrayList<JobVertex> vertices = new ArrayList<JobVertex>(Arrays.asList(v1, v2, v3, v4, v5));
            ExecutionGraph eg = new ExecutionGraph(TestingUtils.defaultExecutor(), (Executor)TestingUtils.defaultExecutor(), new JobID(), "test job", new Configuration(), new SerializedValue((Object)new ExecutionConfig()), AkkaUtils.getDefaultTimeout(), (RestartStrategy)new NoRestartStrategy(), (SlotProvider)new Scheduler((Executor)TestingUtils.defaultExecutionContext()));
            eg.attachJobGraph(vertices);
            SlotSharingGroup group1 = null;
            SlotSharingGroup group2 = null;
            Assert.assertNull((Object)eg.getJobVertex(v1.getID()).getSlotSharingGroup());
            group1 = eg.getJobVertex(v2.getID()).getSlotSharingGroup();
            Assert.assertNotNull((Object)group1);
            Assert.assertEquals((Object)group1, (Object)eg.getJobVertex(v3.getID()).getSlotSharingGroup());
            Assert.assertEquals((long)2L, (long)group1.getJobVertexIds().size());
            Assert.assertTrue((boolean)group1.getJobVertexIds().contains(v2.getID()));
            Assert.assertTrue((boolean)group1.getJobVertexIds().contains(v3.getID()));
            group2 = eg.getJobVertex(v4.getID()).getSlotSharingGroup();
            Assert.assertNotNull((Object)group2);
            Assert.assertEquals((Object)group2, (Object)eg.getJobVertex(v5.getID()).getSlotSharingGroup());
            Assert.assertEquals((long)2L, (long)group1.getJobVertexIds().size());
            Assert.assertTrue((boolean)group2.getJobVertexIds().contains(v4.getID()));
            Assert.assertTrue((boolean)group2.getJobVertexIds().contains(v5.getID()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

