/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.restart.FixedDelayRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.LatchedRestarter;
import org.apache.flink.runtime.executiongraph.restart.NoOpRestarter;
import org.apache.flink.runtime.executiongraph.restart.RestartCallback;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FixedDelayRestartStrategyTest {
    public final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(4);
    public final ScheduledExecutor executor = new ScheduledExecutorServiceAdapter(this.executorService);

    @After
    public void shutdownExecutor() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testNumberOfRestarts() throws Exception {
        int numberRestarts = 10;
        FixedDelayRestartStrategy strategy = new FixedDelayRestartStrategy(10, 0L);
        for (int restartsLeft = 10; restartsLeft > 0; --restartsLeft) {
            Assert.assertTrue((boolean)strategy.canRestart());
            Assert.assertTrue((boolean)strategy.canRestart());
            strategy.restart((RestartCallback)new NoOpRestarter(), this.executor);
        }
        Assert.assertFalse((boolean)strategy.canRestart());
    }

    @Test
    public void testDelay() throws Exception {
        long restartDelay = 10L;
        int numberRestarts = 10;
        FixedDelayRestartStrategy strategy = new FixedDelayRestartStrategy(10, 10L);
        for (int restartsLeft = 10; restartsLeft > 0; --restartsLeft) {
            Assert.assertTrue((boolean)strategy.canRestart());
            OneShotLatch sync = new OneShotLatch();
            LatchedRestarter restarter = new LatchedRestarter(sync);
            long time = System.nanoTime();
            strategy.restart((RestartCallback)restarter, this.executor);
            sync.await();
            long elapsed = System.nanoTime() - time;
            Assert.assertTrue((String)"Not enough delay", (elapsed >= 10000000L ? 1 : 0) != 0);
        }
        Assert.assertFalse((boolean)strategy.canRestart());
    }
}

