/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.utils;

import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlot;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.instance.Slot;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class SimpleSlotProvider
implements SlotProvider,
SlotOwner {
    private final Object lock = new Object();
    private final ArrayDeque<SlotContext> slots;
    private final HashMap<SlotRequestId, SlotContext> allocatedSlots;

    public SimpleSlotProvider(JobID jobId, int numSlots) {
        this(jobId, numSlots, new SimpleAckingTaskManagerGateway());
    }

    public SimpleSlotProvider(JobID jobId, int numSlots, TaskManagerGateway taskManagerGateway) {
        Preconditions.checkNotNull((Object)jobId, (String)"jobId");
        Preconditions.checkArgument((numSlots >= 0 ? 1 : 0) != 0, (Object)"numSlots must be >= 0");
        this.slots = new ArrayDeque(numSlots);
        for (int i = 0; i < numSlots; ++i) {
            SimpleSlotContext as = new SimpleSlotContext(new AllocationID(), new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 10000 + i), 0, taskManagerGateway);
            this.slots.add((SlotContext)as);
        }
        this.allocatedSlots = new HashMap(this.slots.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<LogicalSlot> allocateSlot(SlotRequestId slotRequestId, ScheduledUnit task, boolean allowQueued, SlotProfile slotProfile, Time allocationTimeout) {
        Object object = this.lock;
        synchronized (object) {
            SlotContext slot = this.slots.isEmpty() ? null : this.slots.removeFirst();
            if (slot != null) {
                SimpleSlot result = new SimpleSlot(slot, (SlotOwner)this, 0);
                this.allocatedSlots.put(slotRequestId, slot);
                return CompletableFuture.completedFuture(result);
            }
            return FutureUtils.completedExceptionally((Throwable)new NoResourceAvailableException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Acknowledge> cancelSlotRequest(SlotRequestId slotRequestId, @Nullable SlotSharingGroupId slotSharingGroupId, Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            SlotContext slotContext = this.allocatedSlots.remove(slotRequestId);
            if (slotContext != null) {
                this.slots.add(slotContext);
                return CompletableFuture.completedFuture(Acknowledge.get());
            }
            return FutureUtils.completedExceptionally((Throwable)new FlinkException("Unknown slot request id " + slotRequestId + '.'));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Boolean> returnAllocatedSlot(LogicalSlot logicalSlot) {
        Preconditions.checkArgument((boolean)(logicalSlot instanceof Slot));
        Slot slot = (Slot)logicalSlot;
        Object object = this.lock;
        synchronized (object) {
            this.slots.add(slot.getSlotContext());
            this.allocatedSlots.remove(logicalSlot.getSlotRequestId());
        }
        return CompletableFuture.completedFuture(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAvailableSlots() {
        Object object = this.lock;
        synchronized (object) {
            return this.slots.size();
        }
    }
}

