/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.nonha.standalone.StandaloneRunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;

public class TestingHighAvailabilityServices
implements HighAvailabilityServices {
    private volatile LeaderRetrievalService resourceManagerLeaderRetriever;
    private volatile LeaderRetrievalService dispatcherLeaderRetriever;
    private volatile LeaderRetrievalService webMonitorEndpointLeaderRetriever;
    private ConcurrentHashMap<JobID, LeaderRetrievalService> jobMasterLeaderRetrievers = new ConcurrentHashMap();
    private ConcurrentHashMap<JobID, LeaderElectionService> jobManagerLeaderElectionServices = new ConcurrentHashMap();
    private volatile LeaderElectionService resourceManagerLeaderElectionService;
    private volatile LeaderElectionService dispatcherLeaderElectionService;
    private volatile LeaderElectionService webMonitorEndpointLeaderElectionService;
    private volatile CheckpointRecoveryFactory checkpointRecoveryFactory;
    private volatile SubmittedJobGraphStore submittedJobGraphStore;
    private volatile RunningJobsRegistry runningJobsRegistry = new StandaloneRunningJobsRegistry();

    public void setResourceManagerLeaderRetriever(LeaderRetrievalService resourceManagerLeaderRetriever) {
        this.resourceManagerLeaderRetriever = resourceManagerLeaderRetriever;
    }

    public void setDispatcherLeaderRetriever(LeaderRetrievalService dispatcherLeaderRetriever) {
        this.dispatcherLeaderRetriever = dispatcherLeaderRetriever;
    }

    public void setWebMonitorEndpointLeaderRetriever(LeaderRetrievalService webMonitorEndpointLeaderRetriever) {
        this.webMonitorEndpointLeaderRetriever = webMonitorEndpointLeaderRetriever;
    }

    public void setJobMasterLeaderRetriever(JobID jobID, LeaderRetrievalService jobMasterLeaderRetriever) {
        this.jobMasterLeaderRetrievers.put(jobID, jobMasterLeaderRetriever);
    }

    public void setJobMasterLeaderElectionService(JobID jobID, LeaderElectionService leaderElectionService) {
        this.jobManagerLeaderElectionServices.put(jobID, leaderElectionService);
    }

    public void setResourceManagerLeaderElectionService(LeaderElectionService leaderElectionService) {
        this.resourceManagerLeaderElectionService = leaderElectionService;
    }

    public void setDispatcherLeaderElectionService(LeaderElectionService leaderElectionService) {
        this.dispatcherLeaderElectionService = leaderElectionService;
    }

    public void setWebMonitorEndpointLeaderElectionService(LeaderElectionService webMonitorEndpointLeaderElectionService) {
        this.webMonitorEndpointLeaderElectionService = webMonitorEndpointLeaderElectionService;
    }

    public void setCheckpointRecoveryFactory(CheckpointRecoveryFactory checkpointRecoveryFactory) {
        this.checkpointRecoveryFactory = checkpointRecoveryFactory;
    }

    public void setSubmittedJobGraphStore(SubmittedJobGraphStore submittedJobGraphStore) {
        this.submittedJobGraphStore = submittedJobGraphStore;
    }

    public void setRunningJobsRegistry(RunningJobsRegistry runningJobsRegistry) {
        this.runningJobsRegistry = runningJobsRegistry;
    }

    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        LeaderRetrievalService service = this.resourceManagerLeaderRetriever;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("ResourceManagerLeaderRetriever has not been set");
    }

    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        LeaderRetrievalService service = this.dispatcherLeaderRetriever;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("ResourceManagerLeaderRetriever has not been set");
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        LeaderRetrievalService service = this.jobMasterLeaderRetrievers.get(jobID);
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("JobMasterLeaderRetriever has not been set");
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        return this.getJobManagerLeaderRetriever(jobID);
    }

    public LeaderRetrievalService getWebMonitorLeaderRetriever() {
        return this.webMonitorEndpointLeaderRetriever;
    }

    public LeaderElectionService getResourceManagerLeaderElectionService() {
        LeaderElectionService service = this.resourceManagerLeaderElectionService;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("ResourceManagerLeaderElectionService has not been set");
    }

    public LeaderElectionService getDispatcherLeaderElectionService() {
        LeaderElectionService service = this.dispatcherLeaderElectionService;
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("DispatcherLeaderElectionService has not been set");
    }

    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        LeaderElectionService service = this.jobManagerLeaderElectionServices.get(jobID);
        if (service != null) {
            return service;
        }
        throw new IllegalStateException("JobMasterLeaderElectionService has not been set");
    }

    public LeaderElectionService getWebMonitorLeaderElectionService() {
        return this.webMonitorEndpointLeaderElectionService;
    }

    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
        CheckpointRecoveryFactory factory = this.checkpointRecoveryFactory;
        if (factory != null) {
            return factory;
        }
        throw new IllegalStateException("CheckpointRecoveryFactory has not been set");
    }

    public SubmittedJobGraphStore getSubmittedJobGraphStore() {
        SubmittedJobGraphStore store = this.submittedJobGraphStore;
        if (store != null) {
            return store;
        }
        throw new IllegalStateException("SubmittedJobGraphStore has not been set");
    }

    public RunningJobsRegistry getRunningJobsRegistry() {
        return this.runningJobsRegistry;
    }

    public BlobStore createBlobStore() throws IOException {
        return new VoidBlobStore();
    }

    public void close() throws Exception {
    }

    public void closeAndCleanupAllData() throws Exception {
    }
}

