/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.ManualLeaderService;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.nonha.standalone.StandaloneRunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.StandaloneSubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;

public class TestingManualHighAvailabilityServices
implements HighAvailabilityServices {
    private final Map<JobID, ManualLeaderService> jobManagerLeaderServices = new HashMap<JobID, ManualLeaderService>(4);
    private final ManualLeaderService resourceManagerLeaderService = new ManualLeaderService();
    private final ManualLeaderService dispatcherLeaderService = new ManualLeaderService();
    private final ManualLeaderService webMonitorEndpointLeaderService = new ManualLeaderService();

    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        return this.resourceManagerLeaderService.createLeaderRetrievalService();
    }

    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        return this.dispatcherLeaderService.createLeaderRetrievalService();
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        ManualLeaderService leaderService = this.getOrCreateJobManagerLeaderService(jobID);
        return leaderService.createLeaderRetrievalService();
    }

    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        return this.getJobManagerLeaderRetriever(jobID);
    }

    public LeaderRetrievalService getWebMonitorLeaderRetriever() {
        return this.webMonitorEndpointLeaderService.createLeaderRetrievalService();
    }

    public LeaderElectionService getResourceManagerLeaderElectionService() {
        return this.resourceManagerLeaderService.createLeaderElectionService();
    }

    public LeaderElectionService getDispatcherLeaderElectionService() {
        return this.dispatcherLeaderService.createLeaderElectionService();
    }

    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        ManualLeaderService leaderService = this.getOrCreateJobManagerLeaderService(jobID);
        return leaderService.createLeaderElectionService();
    }

    public LeaderElectionService getWebMonitorLeaderElectionService() {
        return this.webMonitorEndpointLeaderService.createLeaderElectionService();
    }

    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
        return new StandaloneCheckpointRecoveryFactory();
    }

    public SubmittedJobGraphStore getSubmittedJobGraphStore() throws Exception {
        return new StandaloneSubmittedJobGraphStore();
    }

    public RunningJobsRegistry getRunningJobsRegistry() throws Exception {
        return new StandaloneRunningJobsRegistry();
    }

    public BlobStore createBlobStore() throws IOException {
        return new VoidBlobStore();
    }

    public void close() throws Exception {
    }

    public void closeAndCleanupAllData() throws Exception {
    }

    public void grantLeadership(JobID jobId, int index, UUID leaderId) {
        ManualLeaderService manualLeaderService = this.jobManagerLeaderServices.get(jobId);
        if (manualLeaderService == null) {
            throw new IllegalStateException("No manual leader service for job id " + jobId + " has been initialized.");
        }
        manualLeaderService.grantLeadership(index, leaderId);
    }

    public void revokeLeadership(JobID jobId) {
        ManualLeaderService manualLeaderService = this.jobManagerLeaderServices.get(jobId);
        if (manualLeaderService == null) {
            throw new IllegalStateException("No manual leader service for job id " + jobId + " has been initialized.");
        }
        manualLeaderService.revokeLeadership();
    }

    public void notifyRetrievers(JobID jobId, int index, UUID leaderId) {
        ManualLeaderService manualLeaderService = this.jobManagerLeaderServices.get(jobId);
        if (manualLeaderService == null) {
            throw new IllegalStateException("No manual leader service for job id " + jobId + " has been initialized.");
        }
        manualLeaderService.notifyRetrievers(index, leaderId);
    }

    private ManualLeaderService getOrCreateJobManagerLeaderService(JobID jobId) {
        ManualLeaderService manualLeaderService = this.jobManagerLeaderServices.get(jobId);
        if (manualLeaderService == null) {
            manualLeaderService = new ManualLeaderService();
            this.jobManagerLeaderServices.put(jobId, manualLeaderService);
        }
        return manualLeaderService;
    }
}

