/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.disk.FileChannelInputView;
import org.apache.flink.runtime.io.disk.FileChannelOutputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class FileChannelStreamsTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseAndDeleteOutputView() {
        IOManagerAsync ioManager = new IOManagerAsync();
        try {
            MemoryManager memMan = new MemoryManager(65536L, 1, 16384, MemoryType.HEAP, true);
            ArrayList memory = new ArrayList();
            memMan.allocatePages((Object)new DummyInvokable(), memory, 4);
            FileIOChannel.ID channel = ioManager.createChannel();
            BlockChannelWriter writer = ioManager.createBlockChannelWriter(channel);
            FileChannelOutputView out = new FileChannelOutputView(writer, memMan, memory, memMan.getPageSize());
            new StringValue((CharSequence)"Some test text").write((DataOutputView)out);
            out.close();
            Assert.assertTrue((boolean)memMan.verifyEmpty());
            out.close();
            out.closeAndDelete();
            Assert.assertFalse((boolean)new File(channel.getPath()).exists());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            ioManager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseAndDeleteInputView() {
        IOManagerAsync ioManager = new IOManagerAsync();
        try {
            MemoryManager memMan = new MemoryManager(65536L, 1, 16384, MemoryType.HEAP, true);
            ArrayList memory = new ArrayList();
            memMan.allocatePages((Object)new DummyInvokable(), memory, 4);
            FileIOChannel.ID channel = ioManager.createChannel();
            try (FileWriter wrt = new FileWriter(channel.getPath());){
                wrt.write("test data");
            }
            BlockChannelReader reader = ioManager.createBlockChannelReader(channel);
            FileChannelInputView in = new FileChannelInputView(reader, memMan, memory, 9);
            in.readInt();
            in.close();
            Assert.assertTrue((boolean)memMan.verifyEmpty());
            in.close();
            in.closeAndDelete();
            Assert.assertFalse((boolean)new File(channel.getPath()).exists());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            ioManager.shutdown();
        }
    }
}

