/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IOManagerITCase
extends TestLogger {
    private static final long SEED = 649180756312423613L;
    private static final int MAXIMUM_NUMBER_OF_SEGMENTS_PER_CHANNEL = 10;
    private static final int MEMORY_SIZE = 0xA00000;
    private final int NUM_CHANNELS = 29;
    private final int NUMBERS_TO_BE_WRITTEN = 29000000;
    private IOManager ioManager;
    private MemoryManager memoryManager;

    @Before
    public void beforeTest() {
        this.memoryManager = new MemoryManager(0xA00000L, 1);
        this.ioManager = new IOManagerAsync();
    }

    @After
    public void afterTest() throws Exception {
        this.ioManager.shutdown();
        Assert.assertTrue((String)"IO Manager has not properly shut down.", (boolean)this.ioManager.isProperlyShutDown());
        Assert.assertTrue((String)"Not all memory was returned to the memory manager in the test.", (boolean)this.memoryManager.verifyEmpty());
        this.memoryManager.shutdown();
        this.memoryManager = null;
    }

    @Test
    public void parallelChannelsTest() throws Exception {
        int i;
        Random rnd = new Random(649180756312423613L);
        DummyInvokable memOwner = new DummyInvokable();
        FileIOChannel.ID[] ids = new FileIOChannel.ID[29];
        BlockChannelWriter[] writers = new BlockChannelWriter[29];
        BlockChannelReader[] readers = new BlockChannelReader[29];
        ChannelWriterOutputView[] outs = new ChannelWriterOutputView[29];
        ChannelReaderInputView[] ins = new ChannelReaderInputView[29];
        int[] writingCounters = new int[29];
        int[] readingCounters = new int[29];
        for (int i2 = 0; i2 < 29; ++i2) {
            ids[i2] = this.ioManager.createChannel();
            writers[i2] = this.ioManager.createBlockChannelWriter(ids[i2]);
            List memSegs = this.memoryManager.allocatePages((Object)memOwner, rnd.nextInt(9) + 1);
            outs[i2] = new ChannelWriterOutputView(writers[i2], memSegs, this.memoryManager.getPageSize());
        }
        Value val = new Value();
        for (i = 0; i < 29000000; ++i) {
            int channel;
            int n = channel = IOManagerITCase.skewedSample(rnd, 28);
            int n2 = writingCounters[n];
            writingCounters[n] = n2 + 1;
            val.value = String.valueOf(n2);
            val.write((DataOutputView)outs[channel]);
        }
        for (i = 0; i < 29; ++i) {
            this.memoryManager.release((Collection)outs[i].close());
        }
        outs = null;
        writers = null;
        for (i = 0; i < 29; ++i) {
            List memSegs = this.memoryManager.allocatePages((Object)memOwner, rnd.nextInt(9) + 1);
            BlockChannelReader reader = this.ioManager.createBlockChannelReader(ids[i]);
            ChannelReaderInputView in = new ChannelReaderInputView(reader, memSegs, false);
            int nextVal = 0;
            try {
                while (true) {
                    val.read((DataInputView)in);
                    int intValue = 0;
                    try {
                        intValue = Integer.parseInt(val.value);
                    }
                    catch (NumberFormatException nfex) {
                        Assert.fail((String)"Invalid value read from reader. Valid decimal number expected.");
                    }
                    Assert.assertEquals((String)"Written and read values do not match during sequential read.", (long)nextVal, (long)intValue);
                    ++nextVal;
                }
            }
            catch (EOFException eOFException) {
                Assert.assertEquals((String)"NUmber of written numbers differs from number of read numbers.", (long)writingCounters[i], (long)nextVal);
                this.memoryManager.release((Collection)in.close());
                continue;
            }
        }
        for (i = 0; i < 29; ++i) {
            List memSegs = this.memoryManager.allocatePages((Object)memOwner, rnd.nextInt(9) + 1);
            readers[i] = this.ioManager.createBlockChannelReader(ids[i]);
            ins[i] = new ChannelReaderInputView(readers[i], memSegs, false);
        }
        block14: for (i = 0; i < 29000000; ++i) {
            while (true) {
                int channel;
                if (ins[channel = IOManagerITCase.skewedSample(rnd, 28)] == null) {
                    continue;
                }
                try {
                    int intValue;
                    val.read((DataInputView)ins[channel]);
                    try {
                        intValue = Integer.parseInt(val.value);
                    }
                    catch (NumberFormatException nfex) {
                        Assert.fail((String)"Invalid value read from reader. Valid decimal number expected.");
                        return;
                    }
                    int n = channel;
                    int n3 = readingCounters[n];
                    readingCounters[n] = n3 + 1;
                    Assert.assertEquals((String)"Written and read values do not match.", (long)n3, (long)intValue);
                    continue block14;
                }
                catch (EOFException eofex) {
                    this.memoryManager.release((Collection)ins[channel].close());
                    ins[channel] = null;
                    continue;
                }
                break;
            }
        }
        for (i = 0; i < 29; ++i) {
            if (ins[i] != null) {
                this.memoryManager.release((Collection)ins[i].close());
            }
            readers[i].closeAndDelete();
        }
        ins = null;
        readers = null;
        for (i = 0; i < 29; ++i) {
            File f = new File(ids[i].getPath());
            Assert.assertFalse((String)"Channel file has not been deleted.", (boolean)f.exists());
        }
    }

    private static int skewedSample(Random rnd, int max) {
        double uniform = rnd.nextDouble();
        double var = Math.pow(uniform, 8.0);
        double pareto = 0.2 / var;
        int val = (int)pareto;
        return val > max ? val % max : val;
    }

    protected static class Value
    implements IOReadableWritable {
        private String value;

        public Value() {
        }

        public Value(String val) {
            this.value = val;
        }

        public void read(DataInputView in) throws IOException {
            this.value = in.readUTF();
        }

        public void write(DataOutputView out) throws IOException {
            out.writeUTF(this.value);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Value other = (Value)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

