/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.testutils.serialization.types.SerializationTestType;
import org.apache.flink.testutils.serialization.types.SerializationTestTypeFactory;
import org.apache.flink.testutils.serialization.types.Util;
import org.junit.Assert;
import org.junit.Test;

public class SpanningRecordSerializerTest {
    @Test
    public void testHasSerializedData() throws IOException {
        SpanningRecordSerializer serializer = new SpanningRecordSerializer();
        SerializationTestType randomIntRecord = Util.randomRecord((SerializationTestTypeFactory)SerializationTestTypeFactory.INT);
        Assert.assertFalse((boolean)serializer.hasSerializedData());
        serializer.serializeRecord((IOReadableWritable)randomIntRecord);
        Assert.assertTrue((boolean)serializer.hasSerializedData());
        BufferBuilder bufferBuilder1 = BufferBuilderTestUtils.createBufferBuilder(16);
        serializer.copyToBufferBuilder(bufferBuilder1);
        Assert.assertFalse((boolean)serializer.hasSerializedData());
        BufferBuilder bufferBuilder2 = BufferBuilderTestUtils.createBufferBuilder(8);
        serializer.reset();
        serializer.copyToBufferBuilder(bufferBuilder2);
        Assert.assertFalse((boolean)serializer.hasSerializedData());
        serializer.reset();
        serializer.copyToBufferBuilder(bufferBuilder2);
        Assert.assertTrue((boolean)serializer.hasSerializedData());
    }

    @Test
    public void testEmptyRecords() throws IOException {
        int segmentSize = 11;
        SpanningRecordSerializer serializer = new SpanningRecordSerializer();
        BufferBuilder bufferBuilder1 = BufferBuilderTestUtils.createBufferBuilder(11);
        Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)serializer.copyToBufferBuilder(bufferBuilder1));
        SerializationTestType emptyRecord = new SerializationTestType(){

            public SerializationTestType getRandom(Random rnd) {
                throw new UnsupportedOperationException();
            }

            public int length() {
                throw new UnsupportedOperationException();
            }

            public void write(DataOutputView out) {
            }

            public void read(DataInputView in) {
            }

            public int hashCode() {
                throw new UnsupportedOperationException();
            }

            public boolean equals(Object obj) {
                throw new UnsupportedOperationException();
            }
        };
        serializer.serializeRecord((IOReadableWritable)emptyRecord);
        Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)serializer.copyToBufferBuilder(bufferBuilder1));
        serializer.reset();
        Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)serializer.copyToBufferBuilder(bufferBuilder1));
        serializer.reset();
        Assert.assertEquals((Object)RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL, (Object)serializer.copyToBufferBuilder(bufferBuilder1));
        BufferBuilder bufferBuilder2 = BufferBuilderTestUtils.createBufferBuilder(11);
        Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)serializer.copyToBufferBuilder(bufferBuilder2));
    }

    @Test
    public void testIntRecordsSpanningMultipleSegments() throws Exception {
        boolean segmentSize = true;
        int numValues = 10;
        this.test(Util.randomRecords((int)10, (SerializationTestTypeFactory)SerializationTestTypeFactory.INT), 1);
    }

    @Test
    public void testIntRecordsWithAlignedSegments() throws Exception {
        int segmentSize = 64;
        int numValues = 64;
        this.test(Util.randomRecords((int)64, (SerializationTestTypeFactory)SerializationTestTypeFactory.INT), 64);
    }

    @Test
    public void testIntRecordsWithUnalignedSegments() throws Exception {
        int segmentSize = 31;
        int numValues = 248;
        this.test(Util.randomRecords((int)248, (SerializationTestTypeFactory)SerializationTestTypeFactory.INT), 31);
    }

    @Test
    public void testRandomRecords() throws Exception {
        int segmentSize = 127;
        int numValues = 100000;
        this.test(Util.randomRecords((int)100000), 127);
    }

    private void test(Util.MockRecords records, int segmentSize) throws Exception {
        int serializationOverhead = 4;
        SpanningRecordSerializer serializer = new SpanningRecordSerializer();
        BufferBuilder bufferBuilder = BufferBuilderTestUtils.createBufferBuilder(segmentSize);
        int numBytes = 0;
        for (SerializationTestType record : records) {
            serializer.serializeRecord((IOReadableWritable)record);
            RecordSerializer.SerializationResult result = serializer.copyToBufferBuilder(bufferBuilder);
            if ((numBytes += record.length() + 4) < segmentSize) {
                Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD, (Object)result);
                continue;
            }
            if (numBytes == segmentSize) {
                Assert.assertEquals((Object)RecordSerializer.SerializationResult.FULL_RECORD_MEMORY_SEGMENT_FULL, (Object)result);
                bufferBuilder = BufferBuilderTestUtils.createBufferBuilder(segmentSize);
                numBytes = 0;
                continue;
            }
            Assert.assertEquals((Object)RecordSerializer.SerializationResult.PARTIAL_RECORD_MEMORY_SEGMENT_FULL, (Object)result);
            while (result.isFullBuffer()) {
                numBytes -= segmentSize;
                bufferBuilder = BufferBuilderTestUtils.createBufferBuilder(segmentSize);
                result = serializer.copyToBufferBuilder(bufferBuilder);
            }
            Assert.assertTrue((boolean)result.isFullRecord());
        }
    }
}

