/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.junit.Assert;
import org.junit.Test;

public class NettyBufferPoolTest {
    @Test
    public void testNoHeapAllocations() throws Exception {
        NettyBufferPool nettyBufferPool = new NettyBufferPool(1);
        Assert.assertTrue((boolean)nettyBufferPool.buffer().isDirect());
        Assert.assertTrue((boolean)nettyBufferPool.buffer(128).isDirect());
        Assert.assertTrue((boolean)nettyBufferPool.buffer(128, 256).isDirect());
        Assert.assertTrue((boolean)nettyBufferPool.ioBuffer().isDirect());
        Assert.assertTrue((boolean)nettyBufferPool.ioBuffer(128).isDirect());
        Assert.assertTrue((boolean)nettyBufferPool.ioBuffer(128, 256).isDirect());
        try {
            nettyBufferPool.heapBuffer();
            Assert.fail((String)"Unexpected heap buffer operation");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            nettyBufferPool.heapBuffer(128);
            Assert.fail((String)"Unexpected heap buffer operation");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            nettyBufferPool.heapBuffer(128, 256);
            Assert.fail((String)"Unexpected heap buffer operation");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            nettyBufferPool.compositeHeapBuffer();
            Assert.fail((String)"Unexpected heap buffer operation");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            nettyBufferPool.compositeHeapBuffer(2);
            Assert.fail((String)"Unexpected heap buffer operation");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)nettyBufferPool.isDirectBufferPooled());
    }

    @Test
    public void testAllocationsStatistics() throws Exception {
        NettyBufferPool nettyBufferPool = new NettyBufferPool(1);
        int chunkSize = nettyBufferPool.getChunkSize();
        nettyBufferPool.directBuffer(chunkSize - 64);
        long allocated = (Long)nettyBufferPool.getNumberOfAllocatedBytes().get();
        Assert.assertEquals((long)chunkSize, (long)allocated);
        nettyBufferPool.directBuffer(128);
        allocated = (Long)nettyBufferPool.getNumberOfAllocatedBytes().get();
        Assert.assertEquals((long)(2 * chunkSize), (long)allocated);
    }
}

