/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClient;
import org.apache.flink.runtime.io.network.netty.PartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.util.TestBufferFactory;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PartitionRequestClientHandlerTest {
    @Test(timeout=60000L)
    public void testReleaseInputChannelDuringDecode() throws Exception {
        BufferProvider bufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
        Mockito.when((Object)bufferProvider.requestBuffer()).thenReturn(null);
        Mockito.when((Object)bufferProvider.isDestroyed()).thenReturn((Object)true);
        Mockito.when((Object)bufferProvider.addBufferListener((BufferListener)Matchers.any(BufferListener.class))).thenReturn((Object)false);
        RemoteInputChannel inputChannel = (RemoteInputChannel)Mockito.mock(RemoteInputChannel.class);
        Mockito.when((Object)inputChannel.getInputChannelId()).thenReturn((Object)new InputChannelID());
        Mockito.when((Object)inputChannel.getBufferProvider()).thenReturn((Object)bufferProvider);
        NettyMessage.BufferResponse receivedBuffer = PartitionRequestClientHandlerTest.createBufferResponse(TestBufferFactory.createBuffer(32768), 0, inputChannel.getInputChannelId(), 2);
        PartitionRequestClientHandler client = new PartitionRequestClientHandler();
        client.addInputChannel(inputChannel);
        client.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)receivedBuffer);
    }

    @Test
    public void testReceiveEmptyBuffer() throws Exception {
        BufferProvider bufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
        Mockito.when((Object)bufferProvider.requestBuffer()).thenReturn((Object)TestBufferFactory.createBuffer(0));
        RemoteInputChannel inputChannel = (RemoteInputChannel)Mockito.mock(RemoteInputChannel.class);
        Mockito.when((Object)inputChannel.getInputChannelId()).thenReturn((Object)new InputChannelID());
        Mockito.when((Object)inputChannel.getBufferProvider()).thenReturn((Object)bufferProvider);
        Buffer emptyBuffer = TestBufferFactory.createBuffer(0);
        int backlog = -1;
        NettyMessage.BufferResponse receivedBuffer = PartitionRequestClientHandlerTest.createBufferResponse(emptyBuffer, 0, inputChannel.getInputChannelId(), -1);
        PartitionRequestClientHandler client = new PartitionRequestClientHandler();
        client.addInputChannel(inputChannel);
        client.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)receivedBuffer);
        ((RemoteInputChannel)Mockito.verify((Object)inputChannel, (VerificationMode)Mockito.never())).onError((Throwable)Matchers.any(Throwable.class));
        ((RemoteInputChannel)Mockito.verify((Object)inputChannel, (VerificationMode)Mockito.times((int)1))).onEmptyBuffer(0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceiveBuffer() throws Exception {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(10, 32);
        SingleInputGate inputGate = PartitionRequestClientHandlerTest.createSingleInputGate();
        RemoteInputChannel inputChannel = PartitionRequestClientHandlerTest.createRemoteInputChannel(inputGate);
        try {
            BufferPool bufferPool = networkBufferPool.createBufferPool(8, 8);
            inputGate.setBufferPool(bufferPool);
            int numExclusiveBuffers = 2;
            inputGate.assignExclusiveSegments(networkBufferPool, 2);
            PartitionRequestClientHandler handler = new PartitionRequestClientHandler();
            handler.addInputChannel(inputChannel);
            int backlog = 2;
            NettyMessage.BufferResponse bufferResponse = PartitionRequestClientHandlerTest.createBufferResponse(TestBufferFactory.createBuffer(32), 0, inputChannel.getInputChannelId(), 2);
            handler.channelRead((ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class), (Object)bufferResponse);
            Assert.assertEquals((long)1L, (long)inputChannel.getNumberOfQueuedBuffers());
        }
        finally {
            inputGate.releaseAllResources();
            networkBufferPool.destroyAllBufferPools();
            networkBufferPool.destroy();
        }
    }

    @Test
    public void testReceivePartitionNotFoundException() throws Exception {
        BufferProvider bufferProvider = (BufferProvider)Mockito.mock(BufferProvider.class);
        Mockito.when((Object)bufferProvider.requestBuffer()).thenReturn((Object)TestBufferFactory.createBuffer(0));
        RemoteInputChannel inputChannel = (RemoteInputChannel)Mockito.mock(RemoteInputChannel.class);
        Mockito.when((Object)inputChannel.getInputChannelId()).thenReturn((Object)new InputChannelID());
        Mockito.when((Object)inputChannel.getBufferProvider()).thenReturn((Object)bufferProvider);
        NettyMessage.ErrorResponse partitionNotFound = new NettyMessage.ErrorResponse((Throwable)new PartitionNotFoundException(new ResultPartitionID()), inputChannel.getInputChannelId());
        PartitionRequestClientHandler client = new PartitionRequestClientHandler();
        client.addInputChannel(inputChannel);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Mockito.when((Object)ctx.channel()).thenReturn(Mockito.mock(Channel.class));
        client.channelActive(ctx);
        client.channelRead(ctx, (Object)partitionNotFound);
        ((RemoteInputChannel)Mockito.verify((Object)inputChannel, (VerificationMode)Mockito.times((int)1))).onFailedPartitionRequest();
    }

    @Test
    public void testCancelBeforeActive() throws Exception {
        RemoteInputChannel inputChannel = (RemoteInputChannel)Mockito.mock(RemoteInputChannel.class);
        Mockito.when((Object)inputChannel.getInputChannelId()).thenReturn((Object)new InputChannelID());
        PartitionRequestClientHandler client = new PartitionRequestClientHandler();
        client.addInputChannel(inputChannel);
        client.cancelRequestFor(null);
        client.cancelRequestFor(inputChannel.getInputChannelId());
    }

    static SingleInputGate createSingleInputGate() {
        return new SingleInputGate("InputGate", new JobID(), new IntermediateDataSetID(), ResultPartitionType.PIPELINED, 0, 1, (TaskActions)Mockito.mock(TaskActions.class), UnregisteredMetricGroups.createUnregisteredTaskMetricGroup().getIOMetricGroup(), true);
    }

    static RemoteInputChannel createRemoteInputChannel(SingleInputGate inputGate) throws Exception {
        return PartitionRequestClientHandlerTest.createRemoteInputChannel(inputGate, (PartitionRequestClient)Mockito.mock(PartitionRequestClient.class));
    }

    static RemoteInputChannel createRemoteInputChannel(SingleInputGate inputGate, PartitionRequestClient client) throws Exception {
        return PartitionRequestClientHandlerTest.createRemoteInputChannel(inputGate, client, 0, 0);
    }

    static RemoteInputChannel createRemoteInputChannel(SingleInputGate inputGate, PartitionRequestClient client, int initialBackoff, int maxBackoff) throws Exception {
        ConnectionManager connectionManager = (ConnectionManager)Mockito.mock(ConnectionManager.class);
        Mockito.when((Object)connectionManager.createPartitionRequestClient((ConnectionID)Matchers.any(ConnectionID.class))).thenReturn((Object)client);
        ResultPartitionID partitionId = new ResultPartitionID();
        RemoteInputChannel inputChannel = new RemoteInputChannel(inputGate, 0, partitionId, (ConnectionID)Mockito.mock(ConnectionID.class), connectionManager, initialBackoff, maxBackoff, UnregisteredMetricGroups.createUnregisteredTaskMetricGroup().getIOMetricGroup());
        inputGate.setInputChannel(partitionId.getPartitionId(), (InputChannel)inputChannel);
        return inputChannel;
    }

    static NettyMessage.BufferResponse createBufferResponse(Buffer buffer, int sequenceNumber, InputChannelID receivingChannelId, int backlog) throws IOException {
        NettyMessage.BufferResponse resp = new NettyMessage.BufferResponse(buffer, sequenceNumber, receivingChannelId, backlog);
        ByteBuf serialized = resp.write((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        serialized.readBytes(9);
        NettyMessage.BufferResponse deserialized = NettyMessage.BufferResponse.readFrom((ByteBuf)serialized);
        return deserialized;
    }
}

