/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SubpartitionTestBase;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.runtime.io.network.util.TestPooledBufferProvider;
import org.apache.flink.runtime.io.network.util.TestProducerSource;
import org.apache.flink.runtime.io.network.util.TestSubpartitionConsumer;
import org.apache.flink.runtime.io.network.util.TestSubpartitionProducer;
import org.apache.flink.util.FutureUtil;
import org.apache.flink.util.Preconditions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PipelinedSubpartitionTest
extends SubpartitionTestBase {
    private static final ExecutorService executorService = Executors.newCachedThreadPool();

    @AfterClass
    public static void shutdownExecutorService() throws Exception {
        executorService.shutdownNow();
    }

    PipelinedSubpartition createSubpartition() {
        ResultPartition parent = (ResultPartition)Mockito.mock(ResultPartition.class);
        return new PipelinedSubpartition(0, parent);
    }

    @Test
    public void testIllegalReadViewRequest() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertNotNull((Object)subpartition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener()));
        try {
            subpartition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
            Assert.fail((String)"Did not throw expected exception after duplicate notifyNonEmpty view request.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testIsReleasedChecksParent() {
        PipelinedSubpartition subpartition = (PipelinedSubpartition)Mockito.mock(PipelinedSubpartition.class);
        PipelinedSubpartitionView reader = new PipelinedSubpartitionView(subpartition, (BufferAvailabilityListener)Mockito.mock(BufferAvailabilityListener.class));
        Assert.assertFalse((boolean)reader.isReleased());
        ((PipelinedSubpartition)Mockito.verify((Object)subpartition, (VerificationMode)Mockito.times((int)1))).isReleased();
        Mockito.when((Object)subpartition.isReleased()).thenReturn((Object)true);
        Assert.assertTrue((boolean)reader.isReleased());
        ((PipelinedSubpartition)Mockito.verify((Object)subpartition, (VerificationMode)Mockito.times((int)2))).isReleased();
    }

    @Test
    public void testConcurrentFastProduceAndFastConsume() throws Exception {
        this.testProduceConsume(false, false);
    }

    @Test
    public void testConcurrentFastProduceAndSlowConsume() throws Exception {
        this.testProduceConsume(false, true);
    }

    @Test
    public void testConcurrentSlowProduceAndFastConsume() throws Exception {
        this.testProduceConsume(true, false);
    }

    @Test
    public void testConcurrentSlowProduceAndSlowConsume() throws Exception {
        this.testProduceConsume(true, true);
    }

    private void testProduceConsume(boolean isSlowProducer, boolean isSlowConsumer) throws Exception {
        int producerBufferPoolSize = 8;
        int producerNumberOfBuffersToProduce = 128;
        TestProducerSource producerSource = new TestProducerSource(){
            private BufferProvider bufferProvider = new TestPooledBufferProvider(8);
            private int numberOfBuffers;

            @Override
            public TestProducerSource.BufferConsumerAndChannel getNextBufferConsumer() throws Exception {
                if (this.numberOfBuffers == 128) {
                    return null;
                }
                BufferBuilder bufferBuilder = this.bufferProvider.requestBufferBuilderBlocking();
                int segmentSize = bufferBuilder.getMaxCapacity();
                MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize);
                int next = this.numberOfBuffers * (segmentSize / 4);
                for (int i = 0; i < segmentSize; i += 4) {
                    segment.putInt(i, next);
                    ++next;
                }
                Preconditions.checkState((bufferBuilder.appendAndCommit(ByteBuffer.wrap(segment.getArray())) == segmentSize ? 1 : 0) != 0);
                bufferBuilder.finish();
                ++this.numberOfBuffers;
                return new TestProducerSource.BufferConsumerAndChannel(bufferBuilder.createBufferConsumer(), 0);
            }
        };
        TestConsumerCallback consumerCallback = new TestConsumerCallback(){
            private int numberOfBuffers;

            @Override
            public void onBuffer(Buffer buffer) {
                MemorySegment segment = buffer.getMemorySegment();
                Assert.assertEquals((long)segment.size(), (long)buffer.getSize());
                int expected = this.numberOfBuffers * (segment.size() / 4);
                for (int i = 0; i < segment.size(); i += 4) {
                    Assert.assertEquals((long)expected, (long)segment.getInt(i));
                    ++expected;
                }
                ++this.numberOfBuffers;
                buffer.recycleBuffer();
            }

            @Override
            public void onEvent(AbstractEvent event) {
            }
        };
        PipelinedSubpartition subpartition = this.createSubpartition();
        TestSubpartitionConsumer consumer = new TestSubpartitionConsumer(isSlowConsumer, consumerCallback);
        PipelinedSubpartitionView view = subpartition.createReadView((BufferAvailabilityListener)consumer);
        consumer.setSubpartitionView((ResultSubpartitionView)view);
        Future<Boolean> producerResult = executorService.submit(new TestSubpartitionProducer((ResultSubpartition)subpartition, isSlowProducer, producerSource));
        Future<Boolean> consumerResult = executorService.submit(consumer);
        FutureUtil.waitForAll((long)60000L, (Future[])new Future[]{producerResult, consumerResult});
    }

    @Test
    public void testCleanupReleasedPartitionNoView() throws Exception {
        this.testCleanupReleasedPartition(false);
    }

    @Test
    public void testCleanupReleasedPartitionWithView() throws Exception {
        this.testCleanupReleasedPartition(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCleanupReleasedPartition(boolean createView) throws Exception {
        boolean buffer2Recycled;
        boolean buffer1Recycled;
        PipelinedSubpartition partition = this.createSubpartition();
        BufferConsumer buffer1 = BufferBuilderTestUtils.createFilledBufferConsumer(4096);
        BufferConsumer buffer2 = BufferBuilderTestUtils.createFilledBufferConsumer(4096);
        try {
            partition.add(buffer1);
            partition.add(buffer2);
            PipelinedSubpartitionView view = null;
            if (createView) {
                view = partition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
            }
            partition.release();
            Assert.assertTrue((boolean)partition.isReleased());
            if (createView) {
                Assert.assertTrue((boolean)view.isReleased());
            }
            Assert.assertTrue((boolean)buffer1.isRecycled());
        }
        finally {
            buffer1Recycled = buffer1.isRecycled();
            if (!buffer1Recycled) {
                buffer1.close();
            }
            if (!(buffer2Recycled = buffer2.isRecycled())) {
                buffer2.close();
            }
        }
        if (!buffer1Recycled) {
            Assert.fail((String)"buffer 1 not recycled");
        }
        if (!buffer2Recycled) {
            Assert.fail((String)"buffer 2 not recycled");
        }
        Assert.assertEquals((long)2L, (long)partition.getTotalNumberOfBuffers());
        Assert.assertEquals((long)0L, (long)partition.getTotalNumberOfBytes());
    }
}

