/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class SubpartitionTestBase
extends TestLogger {
    abstract ResultSubpartition createSubpartition();

    @Test
    public void testAddAfterFinish() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.finish();
            Assert.assertEquals((long)1L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBytes());
            Assert.assertEquals((long)1L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getBuffersInBacklog());
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBytes());
            BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledBufferConsumer(4096, 4096);
            Assert.assertFalse((boolean)subpartition.add(bufferConsumer));
            Assert.assertEquals((long)1L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getBuffersInBacklog());
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBytes());
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @Test
    public void testAddAfterRelease() throws Exception {
        ResultSubpartition subpartition = this.createSubpartition();
        try {
            subpartition.release();
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBytes());
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getBuffersInBacklog());
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBytes());
            BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledBufferConsumer(4096, 4096);
            Assert.assertFalse((boolean)subpartition.add(bufferConsumer));
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBuffers());
            Assert.assertEquals((long)0L, (long)subpartition.getBuffersInBacklog());
            Assert.assertEquals((long)0L, (long)subpartition.getTotalNumberOfBytes());
        }
        finally {
            if (subpartition != null) {
                subpartition.release();
            }
        }
    }

    @Test
    public void testReleaseParent() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        this.verifyViewReleasedAfterParentRelease(partition);
    }

    @Test
    public void testReleaseParentAfterSpilled() throws Exception {
        ResultSubpartition partition = this.createSubpartition();
        partition.releaseMemory();
        this.verifyViewReleasedAfterParentRelease(partition);
    }

    private void verifyViewReleasedAfterParentRelease(ResultSubpartition partition) throws Exception {
        BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledBufferConsumer(32768);
        partition.add(bufferConsumer);
        partition.finish();
        BufferAvailabilityListener listener = (BufferAvailabilityListener)Mockito.mock(BufferAvailabilityListener.class);
        ResultSubpartitionView view = partition.createReadView(listener);
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertFalse((boolean)view.isReleased());
        partition.release();
        Assert.assertTrue((boolean)view.isReleased());
    }

    static void assertNextBuffer(ResultSubpartitionView readView, int expectedReadableBufferSize, boolean expectedIsMoreAvailable, int expectedBuffersInBacklog, boolean expectedNextBufferIsEvent, boolean expectedRecycledAfterRecycle) throws IOException, InterruptedException {
        SubpartitionTestBase.assertNextBufferOrEvent(readView, expectedReadableBufferSize, true, null, expectedIsMoreAvailable, expectedBuffersInBacklog, expectedNextBufferIsEvent, expectedRecycledAfterRecycle);
    }

    static void assertNextEvent(ResultSubpartitionView readView, int expectedReadableBufferSize, Class<? extends AbstractEvent> expectedEventClass, boolean expectedIsMoreAvailable, int expectedBuffersInBacklog, boolean expectedNextBufferIsEvent, boolean expectedRecycledAfterRecycle) throws IOException, InterruptedException {
        SubpartitionTestBase.assertNextBufferOrEvent(readView, expectedReadableBufferSize, false, expectedEventClass, expectedIsMoreAvailable, expectedBuffersInBacklog, expectedNextBufferIsEvent, expectedRecycledAfterRecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertNextBufferOrEvent(ResultSubpartitionView readView, int expectedReadableBufferSize, boolean expectedIsBuffer, @Nullable Class<? extends AbstractEvent> expectedEventClass, boolean expectedIsMoreAvailable, int expectedBuffersInBacklog, boolean expectedNextBufferIsEvent, boolean expectedRecycledAfterRecycle) throws IOException, InterruptedException {
        Preconditions.checkArgument((expectedEventClass == null || !expectedIsBuffer ? 1 : 0) != 0);
        ResultSubpartition.BufferAndBacklog bufferAndBacklog = readView.getNextBuffer();
        Assert.assertNotNull((Object)bufferAndBacklog);
        try {
            Assert.assertEquals((String)"buffer size", (long)expectedReadableBufferSize, (long)bufferAndBacklog.buffer().readableBytes());
            Assert.assertEquals((String)"buffer or event", (Object)expectedIsBuffer, (Object)bufferAndBacklog.buffer().isBuffer());
            if (expectedEventClass != null) {
                Assert.assertThat((Object)EventSerializer.fromBuffer((Buffer)bufferAndBacklog.buffer(), (ClassLoader)ClassLoader.getSystemClassLoader()), (Matcher)IsInstanceOf.instanceOf(expectedEventClass));
            }
            Assert.assertEquals((String)"more available", (Object)expectedIsMoreAvailable, (Object)bufferAndBacklog.isMoreAvailable());
            Assert.assertEquals((String)"more available", (Object)expectedIsMoreAvailable, (Object)readView.isAvailable());
            Assert.assertEquals((String)"backlog", (long)expectedBuffersInBacklog, (long)bufferAndBacklog.buffersInBacklog());
            Assert.assertEquals((String)"next is event", (Object)expectedNextBufferIsEvent, (Object)bufferAndBacklog.nextBufferIsEvent());
            Assert.assertEquals((String)"next is event", (Object)expectedNextBufferIsEvent, (Object)readView.nextBufferIsEvent());
            Assert.assertFalse((String)"not recycled", (boolean)bufferAndBacklog.buffer().isRecycled());
        }
        finally {
            bufferAndBacklog.buffer().recycleBuffer();
        }
        Assert.assertEquals((String)"recycled", (Object)expectedRecycledAfterRecycle, (Object)bufferAndBacklog.buffer().isRecycled());
    }

    static void assertNoNextBuffer(ResultSubpartitionView readView) throws IOException, InterruptedException {
        Assert.assertNull((Object)readView.getNextBuffer());
    }
}

