/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.TestSingleInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.MutableObjectIterator;

public class IteratorWrappingTestSingleInputGate<T extends IOReadableWritable>
extends TestSingleInputGate {
    private final TestInputChannel inputChannel;
    private final int bufferSize;
    private MutableObjectIterator<T> inputIterator;
    private RecordSerializer<T> serializer;
    private final T reuse;

    public IteratorWrappingTestSingleInputGate(int bufferSize, Class<T> recordType, MutableObjectIterator<T> iterator) throws IOException, InterruptedException {
        super(1, false);
        this.inputChannel = new TestInputChannel(this.inputGate, 0);
        this.bufferSize = bufferSize;
        this.reuse = (IOReadableWritable)InstantiationUtil.instantiate(recordType);
        this.wrapIterator(iterator);
    }

    private IteratorWrappingTestSingleInputGate<T> wrapIterator(MutableObjectIterator<T> iterator) throws IOException, InterruptedException {
        this.inputIterator = iterator;
        this.serializer = new SpanningRecordSerializer();
        TestInputChannel.BufferAndAvailabilityProvider answer = new TestInputChannel.BufferAndAvailabilityProvider(){
            private boolean hasData;
            {
                this.hasData = IteratorWrappingTestSingleInputGate.this.inputIterator.next((Object)IteratorWrappingTestSingleInputGate.this.reuse) != null;
            }

            @Override
            public Optional<InputChannel.BufferAndAvailability> getBufferAvailability() throws IOException {
                if (this.hasData) {
                    IteratorWrappingTestSingleInputGate.this.serializer.serializeRecord(IteratorWrappingTestSingleInputGate.this.reuse);
                    BufferBuilder bufferBuilder = BufferBuilderTestUtils.createBufferBuilder(IteratorWrappingTestSingleInputGate.this.bufferSize);
                    IteratorWrappingTestSingleInputGate.this.serializer.copyToBufferBuilder(bufferBuilder);
                    this.hasData = IteratorWrappingTestSingleInputGate.this.inputIterator.next((Object)IteratorWrappingTestSingleInputGate.this.reuse) != null;
                    return Optional.of(new InputChannel.BufferAndAvailability(BufferBuilderTestUtils.buildSingleBuffer(bufferBuilder), true, 0));
                }
                IteratorWrappingTestSingleInputGate.this.inputChannel.setReleased();
                return Optional.of(new InputChannel.BufferAndAvailability(EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE), false, 0));
            }
        };
        this.inputChannel.addBufferAndAvailability(answer);
        this.inputGate.setInputChannel(new IntermediateResultPartitionID(), (InputChannel)this.inputChannel);
        return this;
    }

    public IteratorWrappingTestSingleInputGate<T> notifyNonEmpty() {
        this.inputGate.notifyChannelNonEmpty((InputChannel)this.inputChannel);
        return this;
    }
}

