/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.Preconditions;
import org.mockito.Mockito;

public class TestInputChannel
extends InputChannel {
    private final Queue<BufferAndAvailabilityProvider> buffers = new ConcurrentLinkedQueue<BufferAndAvailabilityProvider>();
    private BufferAndAvailabilityProvider lastProvider = null;
    private boolean isReleased = false;

    TestInputChannel(SingleInputGate inputGate, int channelIndex) {
        super(inputGate, channelIndex, new ResultPartitionID(), 0, 0, (Counter)new SimpleCounter(), (Counter)new SimpleCounter());
    }

    public TestInputChannel read(Buffer buffer) throws IOException, InterruptedException {
        return this.read(buffer, true);
    }

    public TestInputChannel read(Buffer buffer, boolean moreAvailable) throws IOException, InterruptedException {
        this.addBufferAndAvailability(new InputChannel.BufferAndAvailability(buffer, moreAvailable, 0));
        return this;
    }

    TestInputChannel readBuffer() throws IOException, InterruptedException {
        return this.readBuffer(true);
    }

    TestInputChannel readBuffer(boolean moreAvailable) throws IOException, InterruptedException {
        Buffer buffer = (Buffer)Mockito.mock(Buffer.class);
        Mockito.when((Object)buffer.isBuffer()).thenReturn((Object)true);
        return this.read(buffer, moreAvailable);
    }

    TestInputChannel readEndOfPartitionEvent() throws InterruptedException {
        this.addBufferAndAvailability(() -> {
            this.setReleased();
            return Optional.of(new InputChannel.BufferAndAvailability(EventSerializer.toBuffer((AbstractEvent)EndOfPartitionEvent.INSTANCE), false, 0));
        });
        return this;
    }

    void addBufferAndAvailability(InputChannel.BufferAndAvailability bufferAndAvailability) {
        this.buffers.add(() -> Optional.of(bufferAndAvailability));
    }

    void addBufferAndAvailability(BufferAndAvailabilityProvider bufferAndAvailability) {
        this.buffers.add(bufferAndAvailability);
    }

    static TestInputChannel[] createInputChannels(SingleInputGate inputGate, int numberOfInputChannels) {
        Preconditions.checkNotNull((Object)inputGate);
        Preconditions.checkArgument((numberOfInputChannels > 0 ? 1 : 0) != 0);
        TestInputChannel[] mocks = new TestInputChannel[numberOfInputChannels];
        for (int i = 0; i < numberOfInputChannels; ++i) {
            mocks[i] = new TestInputChannel(inputGate, i);
            inputGate.setInputChannel(new IntermediateResultPartitionID(), (InputChannel)mocks[i]);
        }
        return mocks;
    }

    void requestSubpartition(int subpartitionIndex) throws IOException, InterruptedException {
    }

    Optional<InputChannel.BufferAndAvailability> getNextBuffer() throws IOException, InterruptedException {
        BufferAndAvailabilityProvider provider = this.buffers.poll();
        if (provider != null) {
            this.lastProvider = provider;
            return provider.getBufferAvailability();
        }
        if (this.lastProvider != null) {
            return this.lastProvider.getBufferAvailability();
        }
        return Optional.empty();
    }

    void sendTaskEvent(TaskEvent event) throws IOException {
    }

    boolean isReleased() {
        return this.isReleased;
    }

    void setReleased() {
        this.isReleased = true;
    }

    void notifySubpartitionConsumed() throws IOException {
    }

    void releaseAllResources() throws IOException {
    }

    protected void notifyChannelNonEmpty() {
    }

    static interface BufferAndAvailabilityProvider {
        public Optional<InputChannel.BufferAndAvailability> getBufferAvailability() throws IOException, InterruptedException;
    }
}

