/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.GenericInputFormat;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.InputFormatVertex;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OutputFormatVertex;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Test;

public class JobTaskVertexTest {
    @Test
    public void testConnectDirectly() {
        JobVertex source = new JobVertex("source");
        JobVertex target = new JobVertex("target");
        target.connectNewDataSetAsInput(source, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        Assert.assertTrue((boolean)source.isInputVertex());
        Assert.assertFalse((boolean)source.isOutputVertex());
        Assert.assertFalse((boolean)target.isInputVertex());
        Assert.assertTrue((boolean)target.isOutputVertex());
        Assert.assertEquals((long)1L, (long)source.getNumberOfProducedIntermediateDataSets());
        Assert.assertEquals((long)1L, (long)target.getNumberOfInputs());
        Assert.assertEquals((Object)((JobEdge)target.getInputs().get(0)).getSource(), source.getProducedDataSets().get(0));
        Assert.assertEquals((long)1L, (long)((IntermediateDataSet)source.getProducedDataSets().get(0)).getConsumers().size());
        Assert.assertEquals((Object)target, (Object)((JobEdge)((IntermediateDataSet)source.getProducedDataSets().get(0)).getConsumers().get(0)).getTarget());
    }

    @Test
    public void testConnectMultipleTargets() {
        JobVertex source = new JobVertex("source");
        JobVertex target1 = new JobVertex("target1");
        JobVertex target2 = new JobVertex("target2");
        target1.connectNewDataSetAsInput(source, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        target2.connectDataSetAsInput((IntermediateDataSet)source.getProducedDataSets().get(0), DistributionPattern.ALL_TO_ALL);
        Assert.assertTrue((boolean)source.isInputVertex());
        Assert.assertFalse((boolean)source.isOutputVertex());
        Assert.assertFalse((boolean)target1.isInputVertex());
        Assert.assertTrue((boolean)target1.isOutputVertex());
        Assert.assertFalse((boolean)target2.isInputVertex());
        Assert.assertTrue((boolean)target2.isOutputVertex());
        Assert.assertEquals((long)1L, (long)source.getNumberOfProducedIntermediateDataSets());
        Assert.assertEquals((long)2L, (long)((IntermediateDataSet)source.getProducedDataSets().get(0)).getConsumers().size());
        Assert.assertEquals((Object)((JobEdge)target1.getInputs().get(0)).getSource(), source.getProducedDataSets().get(0));
        Assert.assertEquals((Object)((JobEdge)target2.getInputs().get(0)).getSource(), source.getProducedDataSets().get(0));
    }

    @Test
    public void testOutputFormatVertex() {
        try {
            TestingOutputFormat outputFormat = new TestingOutputFormat();
            OutputFormatVertex of = new OutputFormatVertex("Name");
            new TaskConfig(of.getConfiguration()).setStubWrapper((UserCodeWrapper)new UserCodeObjectWrapper((Object)outputFormat));
            TestClassLoader cl = new TestClassLoader();
            try {
                of.initializeOnMaster((ClassLoader)cl);
                Assert.fail((String)"Did not throw expected exception.");
            }
            catch (TestException testException) {
                // empty catch block
            }
            OutputFormatVertex copy = (OutputFormatVertex)InstantiationUtil.clone((Serializable)of);
            ClassLoader ctxCl = Thread.currentThread().getContextClassLoader();
            try {
                copy.initializeOnMaster((ClassLoader)cl);
                Assert.fail((String)"Did not throw expected exception.");
            }
            catch (TestException testException) {
                // empty catch block
            }
            Assert.assertEquals((String)"Previous classloader was not restored.", (Object)ctxCl, (Object)Thread.currentThread().getContextClassLoader());
            try {
                copy.finalizeOnMaster((ClassLoader)cl);
                Assert.fail((String)"Did not throw expected exception.");
            }
            catch (TestException testException) {
                // empty catch block
            }
            Assert.assertEquals((String)"Previous classloader was not restored.", (Object)ctxCl, (Object)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testInputFormatVertex() {
        try {
            TestInputFormat inputFormat = new TestInputFormat();
            InputFormatVertex vertex = new InputFormatVertex("Name");
            new TaskConfig(vertex.getConfiguration()).setStubWrapper((UserCodeWrapper)new UserCodeObjectWrapper((Object)inputFormat));
            ClassLoader cl = this.getClass().getClassLoader();
            vertex.initializeOnMaster(cl);
            InputSplit[] splits = vertex.getInputSplitSource().createInputSplits(77);
            Assert.assertNotNull((Object)splits);
            Assert.assertEquals((long)1L, (long)splits.length);
            Assert.assertEquals(TestSplit.class, splits[0].getClass());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private static class TestClassLoader
    extends URLClassLoader {
        public TestClassLoader() {
            super(new URL[0], Thread.currentThread().getContextClassLoader());
        }
    }

    private static final class TestingOutputFormat
    extends DiscardingOutputFormat<Object>
    implements InitializeOnMaster,
    FinalizeOnMaster {
        private boolean isConfigured = false;

        private TestingOutputFormat() {
        }

        public void initializeGlobal(int parallelism) throws IOException {
            if (!this.isConfigured) {
                throw new IllegalStateException("OutputFormat was not configured before initializeGlobal was called.");
            }
            if (!(Thread.currentThread().getContextClassLoader() instanceof TestClassLoader)) {
                throw new IllegalStateException("Context ClassLoader was not correctly switched.");
            }
            throw new TestException();
        }

        public void finalizeGlobal(int parallelism) throws IOException {
            if (!this.isConfigured) {
                throw new IllegalStateException("OutputFormat was not configured before finalizeGlobal was called.");
            }
            if (!(Thread.currentThread().getContextClassLoader() instanceof TestClassLoader)) {
                throw new IllegalStateException("Context ClassLoader was not correctly switched.");
            }
            throw new TestException();
        }

        public void configure(Configuration parameters) {
            if (this.isConfigured) {
                throw new IllegalStateException("OutputFormat is already configured.");
            }
            if (!(Thread.currentThread().getContextClassLoader() instanceof TestClassLoader)) {
                throw new IllegalStateException("Context ClassLoader was not correctly switched.");
            }
            this.isConfigured = true;
        }
    }

    private static final class TestInputFormat
    extends GenericInputFormat<Object> {
        private TestInputFormat() {
        }

        public boolean reachedEnd() {
            return false;
        }

        public Object nextRecord(Object reuse) {
            return null;
        }

        public GenericInputSplit[] createInputSplits(int numSplits) throws IOException {
            return new GenericInputSplit[]{new TestSplit(0, 1)};
        }
    }

    private static final class TestSplit
    extends GenericInputSplit {
        public TestSplit(int partitionNumber, int totalNumberOfPartitions) {
            super(partitionNumber, totalNumberOfPartitions);
        }
    }

    private static final class TestException
    extends IOException {
        private TestException() {
        }
    }
}

