/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.restart.NoOrFixedIfCheckpointingEnabledRestartStrategyFactory;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.BackPressureStatsTracker;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.StackTraceSampleCoordinator;
import org.apache.flink.runtime.rest.handler.legacy.backpressure.VoidBackPressureStatsTracker;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.mockito.Mockito;

public class TestingJobManagerSharedServicesBuilder {
    private ScheduledExecutorService scheduledExecutorService = TestingUtils.defaultExecutor();
    private LibraryCacheManager libraryCacheManager = (LibraryCacheManager)Mockito.mock(LibraryCacheManager.class);
    private RestartStrategyFactory restartStrategyFactory = new NoOrFixedIfCheckpointingEnabledRestartStrategyFactory();
    private StackTraceSampleCoordinator stackTraceSampleCoordinator = (StackTraceSampleCoordinator)Mockito.mock(StackTraceSampleCoordinator.class);
    private BackPressureStatsTracker backPressureStatsTracker = VoidBackPressureStatsTracker.INSTANCE;

    public TestingJobManagerSharedServicesBuilder setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public TestingJobManagerSharedServicesBuilder setLibraryCacheManager(LibraryCacheManager libraryCacheManager) {
        this.libraryCacheManager = libraryCacheManager;
        return this;
    }

    public TestingJobManagerSharedServicesBuilder setRestartStrategyFactory(RestartStrategyFactory restartStrategyFactory) {
        this.restartStrategyFactory = restartStrategyFactory;
        return this;
    }

    public TestingJobManagerSharedServicesBuilder setStackTraceSampleCoordinator(StackTraceSampleCoordinator stackTraceSampleCoordinator) {
        this.stackTraceSampleCoordinator = stackTraceSampleCoordinator;
        return this;
    }

    public TestingJobManagerSharedServicesBuilder setBackPressureStatsTracker(BackPressureStatsTracker backPressureStatsTracker) {
        this.backPressureStatsTracker = backPressureStatsTracker;
        return this;
    }

    public JobManagerSharedServices build() {
        return new JobManagerSharedServices(this.scheduledExecutorService, this.libraryCacheManager, this.restartStrategyFactory, this.stackTraceSampleCoordinator, this.backPressureStatsTracker);
    }
}

