/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class TestingLogicalSlot
implements LogicalSlot {
    private final TaskManagerLocation taskManagerLocation;
    private final TaskManagerGateway taskManagerGateway;
    private final AtomicReference<LogicalSlot.Payload> payloadReference;
    private final int slotNumber;
    private final CompletableFuture<?> releaseFuture;
    @Nullable
    private final CompletableFuture<?> customReleaseFuture;
    private final AllocationID allocationId;
    private final SlotRequestId slotRequestId;
    private final SlotSharingGroupId slotSharingGroupId;

    public TestingLogicalSlot() {
        this(new LocalTaskManagerLocation(), new SimpleAckingTaskManagerGateway(), 0, new AllocationID(), new SlotRequestId(), new SlotSharingGroupId(), null);
    }

    public TestingLogicalSlot(TaskManagerLocation taskManagerLocation, TaskManagerGateway taskManagerGateway, int slotNumber, AllocationID allocationId, SlotRequestId slotRequestId, SlotSharingGroupId slotSharingGroupId, @Nullable CompletableFuture<?> customReleaseFuture) {
        this.taskManagerLocation = (TaskManagerLocation)Preconditions.checkNotNull((Object)taskManagerLocation);
        this.taskManagerGateway = (TaskManagerGateway)Preconditions.checkNotNull((Object)taskManagerGateway);
        this.payloadReference = new AtomicReference();
        this.slotNumber = slotNumber;
        this.allocationId = (AllocationID)Preconditions.checkNotNull((Object)allocationId);
        this.slotRequestId = (SlotRequestId)Preconditions.checkNotNull((Object)slotRequestId);
        this.slotSharingGroupId = (SlotSharingGroupId)Preconditions.checkNotNull((Object)slotSharingGroupId);
        this.releaseFuture = new CompletableFuture();
        this.customReleaseFuture = customReleaseFuture;
    }

    public TaskManagerLocation getTaskManagerLocation() {
        return this.taskManagerLocation;
    }

    public TaskManagerGateway getTaskManagerGateway() {
        return this.taskManagerGateway;
    }

    public Locality getLocality() {
        return Locality.UNKNOWN;
    }

    public boolean isAlive() {
        if (this.customReleaseFuture != null) {
            return !this.customReleaseFuture.isDone();
        }
        return !this.releaseFuture.isDone();
    }

    public boolean tryAssignPayload(LogicalSlot.Payload payload) {
        return this.payloadReference.compareAndSet(null, payload);
    }

    @Nullable
    public LogicalSlot.Payload getPayload() {
        return this.payloadReference.get();
    }

    public CompletableFuture<?> releaseSlot(@Nullable Throwable cause) {
        if (this.customReleaseFuture != null) {
            return this.customReleaseFuture;
        }
        this.releaseFuture.complete(null);
        return this.releaseFuture;
    }

    public int getPhysicalSlotNumber() {
        return this.slotNumber;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public SlotRequestId getSlotRequestId() {
        return this.slotRequestId;
    }

    @Nullable
    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }
}

