/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlot;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SchedulingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotAndLocality;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class AvailableSlotsTest
extends TestLogger {
    static final ResourceProfile DEFAULT_TESTING_PROFILE = new ResourceProfile(1.0, 512);
    static final ResourceProfile DEFAULT_TESTING_BIG_PROFILE = new ResourceProfile(2.0, 1024);

    @Test
    public void testAddAndRemove() throws Exception {
        SlotPool.AvailableSlots availableSlots = new SlotPool.AvailableSlots();
        ResourceID resource1 = new ResourceID("resource1");
        ResourceID resource2 = new ResourceID("resource2");
        AllocatedSlot slot1 = AvailableSlotsTest.createAllocatedSlot(resource1);
        AllocatedSlot slot2 = AvailableSlotsTest.createAllocatedSlot(resource1);
        AllocatedSlot slot3 = AvailableSlotsTest.createAllocatedSlot(resource2);
        availableSlots.add(slot1, 1L);
        availableSlots.add(slot2, 2L);
        availableSlots.add(slot3, 3L);
        Assert.assertEquals((long)3L, (long)availableSlots.size());
        Assert.assertTrue((boolean)availableSlots.contains(slot1.getAllocationId()));
        Assert.assertTrue((boolean)availableSlots.contains(slot2.getAllocationId()));
        Assert.assertTrue((boolean)availableSlots.contains(slot3.getAllocationId()));
        Assert.assertTrue((boolean)availableSlots.containsTaskManager(resource1));
        Assert.assertTrue((boolean)availableSlots.containsTaskManager(resource2));
        availableSlots.removeAllForTaskManager(resource1);
        Assert.assertEquals((long)1L, (long)availableSlots.size());
        Assert.assertFalse((boolean)availableSlots.contains(slot1.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.contains(slot2.getAllocationId()));
        Assert.assertTrue((boolean)availableSlots.contains(slot3.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.containsTaskManager(resource1));
        Assert.assertTrue((boolean)availableSlots.containsTaskManager(resource2));
        availableSlots.removeAllForTaskManager(resource2);
        Assert.assertEquals((long)0L, (long)availableSlots.size());
        Assert.assertFalse((boolean)availableSlots.contains(slot1.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.contains(slot2.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.contains(slot3.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.containsTaskManager(resource1));
        Assert.assertFalse((boolean)availableSlots.containsTaskManager(resource2));
    }

    @Test
    public void testPollFreeSlot() {
        SlotPool.AvailableSlots availableSlots = new SlotPool.AvailableSlots();
        ResourceID resource1 = new ResourceID("resource1");
        AllocatedSlot slot1 = AvailableSlotsTest.createAllocatedSlot(resource1);
        availableSlots.add(slot1, 1L);
        Assert.assertEquals((long)1L, (long)availableSlots.size());
        Assert.assertTrue((boolean)availableSlots.contains(slot1.getAllocationId()));
        Assert.assertTrue((boolean)availableSlots.containsTaskManager(resource1));
        Assert.assertNull((Object)availableSlots.poll((SchedulingStrategy)LocationPreferenceSchedulingStrategy.getInstance(), SlotProfile.noLocality((ResourceProfile)DEFAULT_TESTING_BIG_PROFILE)));
        SlotAndLocality slotAndLocality = availableSlots.poll((SchedulingStrategy)LocationPreferenceSchedulingStrategy.getInstance(), SlotProfile.noLocality((ResourceProfile)DEFAULT_TESTING_PROFILE));
        Assert.assertEquals((Object)slot1, (Object)slotAndLocality.getSlot());
        Assert.assertEquals((long)0L, (long)availableSlots.size());
        Assert.assertFalse((boolean)availableSlots.contains(slot1.getAllocationId()));
        Assert.assertFalse((boolean)availableSlots.containsTaskManager(resource1));
    }

    static AllocatedSlot createAllocatedSlot(ResourceID resourceId) {
        TaskManagerLocation mockTaskManagerLocation = (TaskManagerLocation)Mockito.mock(TaskManagerLocation.class);
        Mockito.when((Object)mockTaskManagerLocation.getResourceID()).thenReturn((Object)resourceId);
        TaskManagerGateway mockTaskManagerGateway = (TaskManagerGateway)Mockito.mock(TaskManagerGateway.class);
        return new AllocatedSlot(new AllocationID(), mockTaskManagerLocation, 0, DEFAULT_TESTING_PROFILE, mockTaskManagerGateway);
    }
}

