/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.HashSet;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.jobmaster.slotpool.DualKeyMap;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DualKeyMapTest
extends TestLogger {
    @Test
    public void testKeySets() {
        Random random = new Random();
        int capacity = 10;
        HashSet<Tuple2> keys = new HashSet<Tuple2>(10);
        for (int i = 0; i < 10; ++i) {
            int keyA = random.nextInt();
            int keyB = random.nextInt();
            keys.add(Tuple2.of((Object)keyA, (Object)keyB));
        }
        DualKeyMap dualKeyMap = new DualKeyMap(10);
        for (Tuple2 key : keys) {
            dualKeyMap.put(key.f0, key.f1, (Object)"foobar");
        }
        MatcherAssert.assertThat((Object)dualKeyMap.keySetA(), (Matcher)Matchers.equalTo(keys.stream().map(t -> (Integer)t.f0).collect(Collectors.toSet())));
        MatcherAssert.assertThat((Object)dualKeyMap.keySetB(), (Matcher)Matchers.equalTo(keys.stream().map(t -> (Integer)t.f1).collect(Collectors.toSet())));
    }
}

