/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import org.apache.curator.test.TestingServer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedLeaderService;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElectionService;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LeaderElectionTest
extends TestLogger {
    private final ServiceClass serviceClass;

    @Parameterized.Parameters(name="Leader election: {0}")
    public static Collection<LeaderElectionType> parameters() {
        return Arrays.asList(LeaderElectionType.values());
    }

    public LeaderElectionTest(LeaderElectionType leaderElectionType) {
        switch (leaderElectionType) {
            case ZooKeeper: {
                this.serviceClass = new ZooKeeperServiceClass();
                break;
            }
            case Embedded: {
                this.serviceClass = new EmbeddedServiceClass();
                break;
            }
            case Standalone: {
                this.serviceClass = new StandaloneServiceClass();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown leader election type: %s.", new Object[]{leaderElectionType}));
            }
        }
    }

    @Before
    public void setup() throws Exception {
        this.serviceClass.setup();
    }

    @After
    public void teardown() throws Exception {
        this.serviceClass.teardown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHasLeadership() throws Exception {
        LeaderElectionService leaderElectionService = this.serviceClass.createLeaderElectionService();
        ManualLeaderContender manualLeaderContender = new ManualLeaderContender();
        try {
            Assert.assertThat((Object)leaderElectionService.hasLeadership(UUID.randomUUID()), (Matcher)Matchers.is((Object)false));
            leaderElectionService.start((LeaderContender)manualLeaderContender);
            UUID leaderSessionId = manualLeaderContender.waitForLeaderSessionId();
            Assert.assertThat((Object)leaderElectionService.hasLeadership(leaderSessionId), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((Object)leaderElectionService.hasLeadership(UUID.randomUUID()), (Matcher)Matchers.is((Object)false));
            leaderElectionService.confirmLeaderSessionID(leaderSessionId);
            Assert.assertThat((Object)leaderElectionService.hasLeadership(leaderSessionId), (Matcher)Matchers.is((Object)true));
            leaderElectionService.stop();
            Assert.assertThat((Object)leaderElectionService.hasLeadership(leaderSessionId), (Matcher)Matchers.is((Object)false));
        }
        finally {
            manualLeaderContender.rethrowError();
        }
    }

    private static final class StandaloneServiceClass
    implements ServiceClass {
        private StandaloneServiceClass() {
        }

        @Override
        public void setup() throws Exception {
        }

        @Override
        public void teardown() throws Exception {
        }

        @Override
        public LeaderElectionService createLeaderElectionService() throws Exception {
            return new StandaloneLeaderElectionService();
        }
    }

    private static final class EmbeddedServiceClass
    implements ServiceClass {
        private EmbeddedLeaderService embeddedLeaderService;

        private EmbeddedServiceClass() {
        }

        @Override
        public void setup() {
            this.embeddedLeaderService = new EmbeddedLeaderService((Executor)TestingUtils.defaultExecutionContext());
        }

        @Override
        public void teardown() {
            if (this.embeddedLeaderService != null) {
                this.embeddedLeaderService.shutdown();
                this.embeddedLeaderService = null;
            }
        }

        @Override
        public LeaderElectionService createLeaderElectionService() throws Exception {
            return this.embeddedLeaderService.createLeaderElectionService();
        }
    }

    private static final class ZooKeeperServiceClass
    implements ServiceClass {
        private TestingServer testingServer;
        private CuratorFramework client;
        private Configuration configuration;

        private ZooKeeperServiceClass() {
        }

        @Override
        public void setup() throws Exception {
            try {
                this.testingServer = new TestingServer();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not start ZooKeeper testing cluster.", e);
            }
            this.configuration = new Configuration();
            this.configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.testingServer.getConnectString());
            this.configuration.setString(HighAvailabilityOptions.HA_MODE, "zookeeper");
            this.client = ZooKeeperUtils.startCuratorFramework((Configuration)this.configuration);
        }

        @Override
        public void teardown() throws Exception {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
            if (this.testingServer != null) {
                this.testingServer.stop();
                this.testingServer = null;
            }
        }

        @Override
        public LeaderElectionService createLeaderElectionService() throws Exception {
            return ZooKeeperUtils.createLeaderElectionService((CuratorFramework)this.client, (Configuration)this.configuration);
        }
    }

    private static interface ServiceClass {
        public void setup() throws Exception;

        public void teardown() throws Exception;

        public LeaderElectionService createLeaderElectionService() throws Exception;
    }

    private static final class ManualLeaderContender
    implements LeaderContender {
        private static final UUID NULL_LEADER_SESSION_ID = new UUID(0L, 0L);
        private final ArrayBlockingQueue<UUID> leaderSessionIds = new ArrayBlockingQueue(10);
        private volatile Exception exception;

        private ManualLeaderContender() {
        }

        public void grantLeadership(UUID leaderSessionID) {
            this.leaderSessionIds.offer(leaderSessionID);
        }

        public void revokeLeadership() {
            this.leaderSessionIds.offer(NULL_LEADER_SESSION_ID);
        }

        public String getAddress() {
            return "foobar";
        }

        public void handleError(Exception exception) {
            this.exception = exception;
        }

        void rethrowError() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        UUID waitForLeaderSessionId() throws InterruptedException {
            return this.leaderSessionIds.take();
        }
    }

    static enum LeaderElectionType {
        ZooKeeper,
        Embedded,
        Standalone;

    }
}

