/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.memory;

import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemorySegmentSimpleTest {
    public static final long RANDOM_SEED = 643196033469871L;
    public static final int MANAGED_MEMORY_SIZE = 0x1000000;
    public static final int PAGE_SIZE = 524288;
    private MemoryManager manager;
    private MemorySegment segment;
    private Random random;

    @Before
    public void setUp() throws Exception {
        try {
            this.manager = new MemoryManager(0x1000000L, 1, 524288, MemoryType.HEAP, true);
            this.segment = (MemorySegment)this.manager.allocatePages((Object)new DummyInvokable(), 1).get(0);
            this.random = new Random(643196033469871L);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Test setup failed.");
        }
    }

    @After
    public void tearDown() {
        this.manager.release(this.segment);
        this.random = null;
        this.segment = null;
        if (!this.manager.verifyEmpty()) {
            Assert.fail((String)"Not all memory has been properly released.");
        }
        this.manager = null;
    }

    @Test
    public void bulkByteAccess() {
        byte[] bytes = new byte[131072];
        try {
            this.segment.put(393217, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.put(458753, bytes, 0, bytes.length / 2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        byte[] src = new byte[65536];
        for (int i = 0; i < 8; ++i) {
            this.random.nextBytes(src);
            this.segment.put(i * 65536, src);
        }
        this.random.setSeed(seed);
        byte[] expected = new byte[65536];
        byte[] actual = new byte[65536];
        for (int i = 0; i < 8; ++i) {
            this.random.nextBytes(expected);
            this.segment.get(i * 65536, actual);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
        byte[] expected2 = new byte[524288];
        this.random.nextBytes(expected2);
        for (int i = 0; i < 16; ++i) {
            this.segment.put(i * 32768, expected2, i * 32768, 32768);
        }
        byte[] actual2 = new byte[524288];
        for (int i = 0; i < 16; ++i) {
            this.segment.get(i * 32768, actual2, i * 32768, 32768);
        }
        Assert.assertArrayEquals((byte[])expected2, (byte[])actual2);
    }

    @Test
    public void byteAccess() {
        int i;
        try {
            this.segment.put(-1, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.put(524288, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.get(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.get(524288);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i < 524288; ++i) {
            this.segment.put(i, (byte)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i = 0; i < 524288; ++i) {
            Assert.assertEquals((long)((byte)this.random.nextInt()), (long)this.segment.get(i));
        }
    }

    @Test
    public void booleanAccess() {
        int i;
        try {
            this.segment.putBoolean(-1, false);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.putBoolean(524288, false);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getBoolean(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getBoolean(524288);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i < 524288; ++i) {
            this.segment.putBoolean(i, this.random.nextBoolean());
        }
        this.random.setSeed(seed);
        for (i = 0; i < 524288; ++i) {
            Assert.assertEquals((Object)this.random.nextBoolean(), (Object)this.segment.getBoolean(i));
        }
    }

    @Test
    public void charAccess() {
        int i;
        try {
            this.segment.putChar(-1, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.putChar(524288, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getChar(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getChar(524288);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524286; i += 2) {
            this.segment.putChar(i, (char)(97 + this.random.nextInt(26)));
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524286; i += 2) {
            Assert.assertEquals((long)((char)(97 + this.random.nextInt(26))), (long)this.segment.getChar(i));
        }
    }

    @Test
    public void doubleAccess() {
        int i;
        try {
            this.segment.putDouble(-1, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.putDouble(524288, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getDouble(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getDouble(524288);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524280; i += 8) {
            this.segment.putDouble(i, this.random.nextDouble());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524280; i += 8) {
            Assert.assertEquals((double)this.random.nextDouble(), (double)this.segment.getDouble(i), (double)0.0);
        }
    }

    public void floatAccess() {
        int i;
        try {
            this.segment.putFloat(-1, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.putFloat(524288, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getFloat(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getFloat(524288);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524284; i += 4) {
            this.segment.putFloat(i, this.random.nextFloat());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524284; i += 4) {
            Assert.assertEquals((double)this.random.nextFloat(), (double)this.segment.getFloat(i), (double)0.0);
        }
    }

    @Test
    public void longAccess() {
        int offset;
        int i;
        try {
            this.segment.putLong(-1, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.putLong(524288, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getLong(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getLong(524288);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524280; i += 8) {
            this.segment.putLong(i, this.random.nextLong());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524280; i += 8) {
            Assert.assertEquals((long)this.random.nextLong(), (long)this.segment.getLong(i));
        }
        seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (offset = 0; offset < 524280; offset += this.random.nextInt(24) + 8) {
            long value = this.random.nextLong();
            this.segment.putLong(offset, value);
        }
        this.random.setSeed(seed);
        for (offset = 0; offset < 524280; offset += this.random.nextInt(24) + 8) {
            long shouldValue = this.random.nextLong();
            long isValue = this.segment.getLong(offset);
            Assert.assertEquals((long)shouldValue, (long)isValue);
        }
    }

    @Test
    public void intAccess() {
        int i;
        try {
            this.segment.putInt(-1, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.putInt(524288, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getInt(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getInt(524288);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524284; i += 4) {
            this.segment.putInt(i, this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524284; i += 4) {
            Assert.assertEquals((long)this.random.nextInt(), (long)this.segment.getInt(i));
        }
    }

    @Test
    public void shortAccess() {
        int i;
        try {
            this.segment.putShort(-1, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.putShort(524288, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getShort(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            this.segment.getShort(524288);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i = 0; i <= 524286; i += 2) {
            this.segment.putShort(i, (short)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i = 0; i <= 524286; i += 2) {
            Assert.assertEquals((long)((short)this.random.nextInt()), (long)this.segment.getShort(i));
        }
    }

    @Test
    public void testByteBufferWrapping() {
        try {
            MemorySegment seg = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
            ByteBuffer buf1 = seg.wrap(13, 47);
            Assert.assertEquals((long)13L, (long)buf1.position());
            Assert.assertEquals((long)60L, (long)buf1.limit());
            Assert.assertEquals((long)47L, (long)buf1.remaining());
            ByteBuffer buf2 = seg.wrap(500, 267);
            Assert.assertEquals((long)500L, (long)buf2.position());
            Assert.assertEquals((long)767L, (long)buf2.limit());
            Assert.assertEquals((long)267L, (long)buf2.remaining());
            ByteBuffer buf3 = seg.wrap(0, 1024);
            Assert.assertEquals((long)0L, (long)buf3.position());
            Assert.assertEquals((long)1024L, (long)buf3.limit());
            Assert.assertEquals((long)1024L, (long)buf3.remaining());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

