/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.testkit.TestActorRef;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.util.TestHistogram;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.dump.MetricDumpSerialization;
import org.apache.flink.runtime.metrics.dump.MetricQueryService;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class MetricQueryServiceTest
extends TestLogger {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateDump() throws Exception {
        ActorSystem s = AkkaUtils.createLocalActorSystem((Configuration)new Configuration());
        ActorRef serviceActor = MetricQueryService.startMetricQueryService((ActorSystem)s, null, (long)Long.MAX_VALUE);
        TestActorRef testActorRef = TestActorRef.create((ActorSystem)s, (Props)Props.create(TestActor.class, (Object[])new Object[0]));
        TestActor testActor = (TestActor)testActorRef.underlyingActor();
        SimpleCounter c = new SimpleCounter();
        Gauge<String> g = new Gauge<String>(){

            public String getValue() {
                return "Hello";
            }
        };
        TestHistogram h = new TestHistogram();
        Meter m = new Meter(){

            public void markEvent() {
            }

            public void markEvent(long n) {
            }

            public double getRate() {
                return 5.0;
            }

            public long getCount() {
                return 10L;
            }
        };
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        TaskManagerMetricGroup tm = new TaskManagerMetricGroup((MetricRegistry)registry, "host", "id");
        MetricQueryService.notifyOfAddedMetric((ActorRef)serviceActor, (Metric)c, (String)"counter", (AbstractMetricGroup)tm);
        MetricQueryService.notifyOfAddedMetric((ActorRef)serviceActor, (Metric)g, (String)"gauge", (AbstractMetricGroup)tm);
        MetricQueryService.notifyOfAddedMetric((ActorRef)serviceActor, (Metric)h, (String)"histogram", (AbstractMetricGroup)tm);
        MetricQueryService.notifyOfAddedMetric((ActorRef)serviceActor, (Metric)m, (String)"meter", (AbstractMetricGroup)tm);
        serviceActor.tell(MetricQueryService.getCreateDump(), (ActorRef)testActorRef);
        Object object = testActor.lock;
        synchronized (object) {
            if (testActor.message == null) {
                testActor.lock.wait();
            }
        }
        MetricDumpSerialization.MetricSerializationResult dump = (MetricDumpSerialization.MetricSerializationResult)testActor.message;
        testActor.message = null;
        Assert.assertTrue((dump.serializedCounters.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dump.serializedGauges.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dump.serializedHistograms.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dump.serializedMeters.length > 0 ? 1 : 0) != 0);
        MetricQueryService.notifyOfRemovedMetric((ActorRef)serviceActor, (Metric)c);
        MetricQueryService.notifyOfRemovedMetric((ActorRef)serviceActor, (Metric)g);
        MetricQueryService.notifyOfRemovedMetric((ActorRef)serviceActor, (Metric)h);
        MetricQueryService.notifyOfRemovedMetric((ActorRef)serviceActor, (Metric)m);
        serviceActor.tell(MetricQueryService.getCreateDump(), (ActorRef)testActorRef);
        Object object2 = testActor.lock;
        synchronized (object2) {
            if (testActor.message == null) {
                testActor.lock.wait();
            }
        }
        MetricDumpSerialization.MetricSerializationResult emptyDump = (MetricDumpSerialization.MetricSerializationResult)testActor.message;
        testActor.message = null;
        Assert.assertEquals((long)0L, (long)emptyDump.serializedCounters.length);
        Assert.assertEquals((long)0L, (long)emptyDump.serializedGauges.length);
        Assert.assertEquals((long)0L, (long)emptyDump.serializedHistograms.length);
        Assert.assertEquals((long)0L, (long)emptyDump.serializedMeters.length);
        s.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandleOversizedMetricMessage() throws Exception {
        ActorSystem s = AkkaUtils.createLocalActorSystem((Configuration)new Configuration());
        long sizeLimit = 200L;
        ActorRef serviceActor = MetricQueryService.startMetricQueryService((ActorSystem)s, null, (long)200L);
        TestActorRef testActorRef = TestActorRef.create((ActorSystem)s, (Props)Props.create(TestActor.class, (Object[])new Object[0]));
        TestActor testActor = (TestActor)testActorRef.underlyingActor();
        SimpleCounter c = new SimpleCounter();
        TestHistogram h = new TestHistogram();
        Meter m = new Meter(){

            public void markEvent() {
            }

            public void markEvent(long n) {
            }

            public double getRate() {
                return 5.0;
            }

            public long getCount() {
                return 10L;
            }
        };
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
        TaskManagerMetricGroup tm = new TaskManagerMetricGroup((MetricRegistry)registry, "host", "id");
        String gaugeValue = "Hello";
        long requiredGaugesToExceedLimit = 200L / (long)"Hello".length() + 1L;
        List<Tuple2> gauges = LongStream.range(0L, requiredGaugesToExceedLimit).mapToObj(x -> Tuple2.of((Object)("gauge" + x), () -> "Hello" + x)).collect(Collectors.toList());
        gauges.forEach(gauge -> MetricQueryService.notifyOfAddedMetric((ActorRef)serviceActor, (Metric)((Metric)gauge.f1), (String)((String)gauge.f0), (AbstractMetricGroup)tm));
        MetricQueryService.notifyOfAddedMetric((ActorRef)serviceActor, (Metric)c, (String)"counter", (AbstractMetricGroup)tm);
        MetricQueryService.notifyOfAddedMetric((ActorRef)serviceActor, (Metric)h, (String)"histogram", (AbstractMetricGroup)tm);
        MetricQueryService.notifyOfAddedMetric((ActorRef)serviceActor, (Metric)m, (String)"meter", (AbstractMetricGroup)tm);
        serviceActor.tell(MetricQueryService.getCreateDump(), (ActorRef)testActorRef);
        Object object = testActor.lock;
        synchronized (object) {
            if (testActor.message == null) {
                testActor.lock.wait();
            }
        }
        MetricDumpSerialization.MetricSerializationResult dump = (MetricDumpSerialization.MetricSerializationResult)testActor.message;
        testActor.message = null;
        Assert.assertTrue((dump.serializedCounters.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dump.numCounters);
        Assert.assertTrue((dump.serializedMeters.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dump.numMeters);
        Assert.assertEquals((long)0L, (long)dump.serializedGauges.length);
        Assert.assertEquals((long)0L, (long)dump.numGauges);
        Assert.assertTrue((dump.serializedHistograms.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)dump.numHistograms);
        for (int x2 = 1; x2 < gauges.size(); ++x2) {
            MetricQueryService.notifyOfRemovedMetric((ActorRef)serviceActor, (Metric)((Metric)((Tuple2)gauges.get((int)x2)).f1));
        }
        serviceActor.tell(MetricQueryService.getCreateDump(), (ActorRef)testActorRef);
        Object x2 = testActor.lock;
        synchronized (x2) {
            if (testActor.message == null) {
                testActor.lock.wait();
            }
        }
        MetricDumpSerialization.MetricSerializationResult recoveredDump = (MetricDumpSerialization.MetricSerializationResult)testActor.message;
        testActor.message = null;
        Assert.assertTrue((recoveredDump.serializedCounters.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)recoveredDump.numCounters);
        Assert.assertTrue((recoveredDump.serializedMeters.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)recoveredDump.numMeters);
        Assert.assertTrue((recoveredDump.serializedGauges.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)recoveredDump.numGauges);
        Assert.assertTrue((recoveredDump.serializedHistograms.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)recoveredDump.numHistograms);
        s.terminate();
    }

    private static class TestActor
    extends UntypedActor {
        public Object message;
        public Object lock = new Object();

        private TestActor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Object message) throws Exception {
            Object object = this.lock;
            synchronized (object) {
                this.message = message;
                this.lock.notifyAll();
            }
        }
    }
}

