/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryConfiguration;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OperatorGroupTest
extends TestLogger {
    private MetricRegistryImpl registry;

    @Before
    public void setup() {
        this.registry = new MetricRegistryImpl(MetricRegistryConfiguration.defaultMetricRegistryConfiguration());
    }

    @After
    public void teardown() throws Exception {
        if (this.registry != null) {
            this.registry.shutdown().get();
        }
    }

    @Test
    public void testGenerateScopeDefault() throws Exception {
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)this.registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tmGroup, new JobID(), "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup((MetricRegistry)this.registry, jmGroup, new JobVertexID(), new AbstractID(), "aTaskName", 11, 0);
        OperatorMetricGroup opGroup = new OperatorMetricGroup((MetricRegistry)this.registry, taskGroup, new OperatorID(), "myOpName");
        Assert.assertArrayEquals((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", "myOpName", "11"}, (Object[])opGroup.getScopeComponents());
        Assert.assertEquals((Object)"theHostName.taskmanager.test-tm-id.myJobName.myOpName.11.name", (Object)opGroup.getMetricIdentifier("name"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_OPERATOR, "<tm_id>.<job_id>.<task_id>.<operator_name>.<operator_id>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryConfiguration.fromConfiguration((Configuration)cfg));
        try {
            String tmID = "test-tm-id";
            JobID jid = new JobID();
            JobVertexID vertexId = new JobVertexID();
            OperatorID operatorID = new OperatorID();
            String operatorName = "operatorName";
            OperatorMetricGroup operatorGroup = new TaskManagerMetricGroup((MetricRegistry)registry, "theHostName", tmID).addTaskForJob(jid, "myJobName", vertexId, new ExecutionAttemptID(), "aTaskname", 13, 2).getOrAddOperator(operatorID, operatorName);
            Assert.assertArrayEquals((Object[])new String[]{tmID, jid.toString(), vertexId.toString(), operatorName, operatorID.toString()}, (Object[])operatorGroup.getScopeComponents());
            Assert.assertEquals((Object)String.format("%s.%s.%s.%s.%s.name", tmID, jid, vertexId, operatorName, operatorID), (Object)operatorGroup.getMetricIdentifier("name"));
        }
        finally {
            registry.shutdown().get();
        }
    }

    @Test
    public void testIOMetricGroupInstantiation() throws Exception {
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)this.registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tmGroup, new JobID(), "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup((MetricRegistry)this.registry, jmGroup, new JobVertexID(), new AbstractID(), "aTaskName", 11, 0);
        OperatorMetricGroup opGroup = new OperatorMetricGroup((MetricRegistry)this.registry, taskGroup, new OperatorID(), "myOpName");
        Assert.assertNotNull((Object)opGroup.getIOMetricGroup());
        Assert.assertNotNull((Object)opGroup.getIOMetricGroup().getNumRecordsInCounter());
        Assert.assertNotNull((Object)opGroup.getIOMetricGroup().getNumRecordsOutCounter());
    }

    @Test
    public void testVariables() {
        JobID jid = new JobID();
        JobVertexID tid = new JobVertexID();
        AbstractID eid = new AbstractID();
        OperatorID oid = new OperatorID();
        TaskManagerMetricGroup tmGroup = new TaskManagerMetricGroup((MetricRegistry)this.registry, "theHostName", "test-tm-id");
        TaskManagerJobMetricGroup jmGroup = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tmGroup, jid, "myJobName");
        TaskMetricGroup taskGroup = new TaskMetricGroup((MetricRegistry)this.registry, jmGroup, tid, eid, "aTaskName", 11, 0);
        OperatorMetricGroup opGroup = new OperatorMetricGroup((MetricRegistry)this.registry, taskGroup, oid, "myOpName");
        Map variables = opGroup.getAllVariables();
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_HOST, "theHostName");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASKMANAGER_ID, "test-tm-id");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_JOB_ID, jid.toString());
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_JOB_NAME, "myJobName");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_VERTEX_ID, tid.toString());
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_NAME, "aTaskName");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_ATTEMPT_ID, eid.toString());
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_SUBTASK_INDEX, "11");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_TASK_ATTEMPT_NUM, "0");
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_OPERATOR_ID, oid.toString());
        OperatorGroupTest.testVariable(variables, ScopeFormat.SCOPE_OPERATOR_NAME, "myOpName");
    }

    private static void testVariable(Map<String, String> variables, String key, String expectedValue) {
        String actualValue = variables.get(key);
        Assert.assertNotNull((Object)actualValue);
        Assert.assertEquals((Object)expectedValue, (Object)actualValue);
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        JobVertexID vid = new JobVertexID();
        AbstractID eid = new AbstractID();
        OperatorID oid = new OperatorID();
        TaskManagerMetricGroup tm = new TaskManagerMetricGroup((MetricRegistry)this.registry, "host", "id");
        TaskManagerJobMetricGroup job = new TaskManagerJobMetricGroup((MetricRegistry)this.registry, tm, jid, "jobname");
        TaskMetricGroup task = new TaskMetricGroup((MetricRegistry)this.registry, job, vid, eid, "taskName", 4, 5);
        OperatorMetricGroup operator = new OperatorMetricGroup((MetricRegistry)this.registry, task, oid, "operator");
        QueryScopeInfo.OperatorQueryScopeInfo info = operator.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)jid.toString(), (Object)info.jobID);
        Assert.assertEquals((Object)vid.toString(), (Object)info.vertexID);
        Assert.assertEquals((long)4L, (long)info.subtaskIndex);
        Assert.assertEquals((Object)"operator", (Object)info.operatorName);
    }
}

