/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import akka.actor.ActorSystem;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.metrics.util.MetricUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtilsTest
extends TestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(MetricUtilsTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartMetricActorSystemRespectsThreadPriority() throws Exception {
        Configuration configuration = new Configuration();
        int expectedThreadPriority = 3;
        configuration.setInteger(MetricOptions.QUERY_SERVICE_THREAD_PRIORITY, 3);
        ActorSystem actorSystem = MetricUtils.startMetricsActorSystem((Configuration)configuration, (String)"localhost", (Logger)LOG);
        try {
            int threadPriority = actorSystem.settings().config().getInt("akka.actor.default-dispatcher.thread-priority");
            Assert.assertThat((Object)threadPriority, (Matcher)Matchers.is((Object)3));
        }
        finally {
            AkkaUtils.terminateActorSystem((ActorSystem)actorSystem).get();
        }
    }
}

