/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.net;

import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.io.network.netty.SSLHandlerFactory;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslHandler;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SSLUtilsTest
extends TestLogger {
    private static final String TRUST_STORE_PATH = SSLUtilsTest.class.getResource("/local127.truststore").getFile();
    private static final String KEY_STORE_PATH = SSLUtilsTest.class.getResource("/local127.keystore").getFile();
    private static final String TRUST_STORE_PASSWORD = "password";
    private static final String KEY_STORE_PASSWORD = "password";
    private static final String KEY_PASSWORD = "password";

    @Test
    public void checkEnableSSL() {
        Configuration oldConf = new Configuration();
        oldConf.setBoolean(SecurityOptions.SSL_ENABLED, true);
        Assert.assertTrue((boolean)SSLUtils.isInternalSSLEnabled((Configuration)oldConf));
        Assert.assertTrue((boolean)SSLUtils.isRestSSLEnabled((Configuration)oldConf));
        Configuration newOptions = new Configuration();
        newOptions.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        newOptions.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        Assert.assertTrue((boolean)SSLUtils.isInternalSSLEnabled((Configuration)newOptions));
        Assert.assertFalse((boolean)SSLUtils.isRestSSLEnabled((Configuration)newOptions));
        Configuration precedence = new Configuration();
        precedence.setBoolean(SecurityOptions.SSL_ENABLED, true);
        precedence.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, false);
        precedence.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        Assert.assertFalse((boolean)SSLUtils.isInternalSSLEnabled((Configuration)precedence));
        Assert.assertFalse((boolean)SSLUtils.isRestSSLEnabled((Configuration)precedence));
    }

    @Test
    public void checkEnableRestSSLAuthentication() {
        Configuration noSSLOptions = new Configuration();
        noSSLOptions.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        noSSLOptions.setBoolean(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, true);
        Assert.assertFalse((boolean)SSLUtils.isRestSSLAuthenticationEnabled((Configuration)noSSLOptions));
        Configuration defaultOptions = new Configuration();
        defaultOptions.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        Assert.assertFalse((boolean)SSLUtils.isRestSSLAuthenticationEnabled((Configuration)defaultOptions));
        Configuration options = new Configuration();
        noSSLOptions.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        noSSLOptions.setBoolean(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, true);
        Assert.assertTrue((boolean)SSLUtils.isRestSSLAuthenticationEnabled((Configuration)noSSLOptions));
    }

    @Test
    public void testSocketFactoriesWhenSslDisabled() throws Exception {
        Configuration config = new Configuration();
        try {
            SSLUtils.createSSLServerSocketFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
        try {
            SSLUtils.createSSLClientSocketFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTClientSSL() throws Exception {
        Configuration clientConfig = SSLUtilsTest.createRestSslConfigWithTrustStore();
        SSLHandlerFactory ssl = SSLUtils.createRestClientSSLEngineFactory((Configuration)clientConfig);
        Assert.assertNotNull((Object)ssl);
    }

    @Test
    public void testRESTClientSSLDisabled() throws Exception {
        Configuration clientConfig = SSLUtilsTest.createRestSslConfigWithTrustStore();
        clientConfig.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        try {
            SSLUtils.createRestClientSSLEngineFactory((Configuration)clientConfig);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTClientSSLMissingTrustStore() throws Exception {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        config.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "some password");
        try {
            SSLUtils.createRestClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTClientSSLMissingPassword() throws Exception {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        config.setString(SecurityOptions.SSL_REST_TRUSTSTORE, TRUST_STORE_PATH);
        try {
            SSLUtils.createRestClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTClientSSLWrongPassword() throws Exception {
        Configuration clientConfig = SSLUtilsTest.createRestSslConfigWithTrustStore();
        clientConfig.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "badpassword");
        try {
            SSLUtils.createRestClientSSLEngineFactory((Configuration)clientConfig);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRESTServerSSL() throws Exception {
        Configuration serverConfig = SSLUtilsTest.createRestSslConfigWithKeyStore();
        SSLHandlerFactory ssl = SSLUtils.createRestServerSSLEngineFactory((Configuration)serverConfig);
        Assert.assertNotNull((Object)ssl);
    }

    @Test
    public void testRESTServerSSLDisabled() throws Exception {
        Configuration serverConfig = SSLUtilsTest.createRestSslConfigWithKeyStore();
        serverConfig.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        try {
            SSLUtils.createRestServerSSLEngineFactory((Configuration)serverConfig);
            Assert.fail((String)"exception expected");
        }
        catch (IllegalConfigurationException illegalConfigurationException) {
            // empty catch block
        }
    }

    @Test
    public void testRESTServerSSLBadKeystorePassword() {
        Configuration serverConfig = SSLUtilsTest.createRestSslConfigWithKeyStore();
        serverConfig.setString(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, "badpassword");
        try {
            SSLUtils.createRestServerSSLEngineFactory((Configuration)serverConfig);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRESTServerSSLBadKeyPassword() {
        Configuration serverConfig = SSLUtilsTest.createRestSslConfigWithKeyStore();
        serverConfig.setString(SecurityOptions.SSL_REST_KEY_PASSWORD, "badpassword");
        try {
            SSLUtils.createRestServerSSLEngineFactory((Configuration)serverConfig);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSL() throws Exception {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores();
        Assert.assertNotNull((Object)SSLUtils.createInternalServerSSLEngineFactory((Configuration)config));
        Assert.assertNotNull((Object)SSLUtils.createInternalClientSSLEngineFactory((Configuration)config));
    }

    @Test
    public void testInternalSSLDisables() throws Exception {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, false);
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLKeyStoreOnly() throws Exception {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyStore();
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLTrustStoreOnly() throws Exception {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithTrustStore();
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLWrongKeystorePassword() throws Exception {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores();
        config.setString(SecurityOptions.SSL_INTERNAL_KEYSTORE_PASSWORD, "badpw");
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLWrongTruststorePassword() throws Exception {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores();
        config.setString(SecurityOptions.SSL_INTERNAL_TRUSTSTORE_PASSWORD, "badpw");
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testInternalSSLWrongKeyPassword() throws Exception {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores();
        config.setString(SecurityOptions.SSL_INTERNAL_KEY_PASSWORD, "badpw");
        try {
            SSLUtils.createInternalServerSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SSLUtils.createInternalClientSSLEngineFactory((Configuration)config);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSetSSLVersionAndCipherSuitesForSSLServerSocket() throws Exception {
        Configuration serverConfig = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores();
        serverConfig.setString(SecurityOptions.SSL_PROTOCOL, "TLSv1.1");
        serverConfig.setString(SecurityOptions.SSL_ALGORITHMS, "TLS_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA256");
        try (ServerSocket socket = SSLUtils.createSSLServerSocketFactory((Configuration)serverConfig).createServerSocket(0);){
            Assert.assertTrue((boolean)(socket instanceof SSLServerSocket));
            SSLServerSocket sslSocket = (SSLServerSocket)socket;
            String[] protocols = sslSocket.getEnabledProtocols();
            String[] algorithms = sslSocket.getEnabledCipherSuites();
            Assert.assertEquals((long)1L, (long)protocols.length);
            Assert.assertEquals((Object)"TLSv1.1", (Object)protocols[0]);
            Assert.assertEquals((long)2L, (long)algorithms.length);
            Assert.assertThat((Object)algorithms, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA256"}));
        }
    }

    @Test
    public void testCreateSSLEngineFactory() throws Exception {
        Configuration serverConfig = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores();
        serverConfig.setString(SecurityOptions.SSL_PROTOCOL, "TLSv1");
        serverConfig.setString(SecurityOptions.SSL_ALGORITHMS, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA,TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
        SSLHandlerFactory serverSSLHandlerFactory = SSLUtils.createInternalServerSSLEngineFactory((Configuration)serverConfig);
        SslHandler sslHandler = serverSSLHandlerFactory.createNettySSLHandler();
        Assert.assertEquals((long)1L, (long)sslHandler.engine().getEnabledProtocols().length);
        Assert.assertEquals((Object)"TLSv1", (Object)sslHandler.engine().getEnabledProtocols()[0]);
        Assert.assertEquals((long)2L, (long)sslHandler.engine().getEnabledCipherSuites().length);
        Assert.assertThat((Object)sslHandler.engine().getEnabledCipherSuites(), (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new String[]{"TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256"}));
    }

    public static Configuration createRestSslConfigWithKeyStore() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        SSLUtilsTest.addRestKeyStoreConfig(config);
        return config;
    }

    public static Configuration createRestSslConfigWithTrustStore() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        SSLUtilsTest.addRestTrustStoreConfig(config);
        return config;
    }

    public static Configuration createRestSslConfigWithKeyAndTrustStores() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        SSLUtilsTest.addRestKeyStoreConfig(config);
        SSLUtilsTest.addRestTrustStoreConfig(config);
        return config;
    }

    public static Configuration createInternalSslConfigWithKeyStore() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        SSLUtilsTest.addInternalKeyStoreConfig(config);
        return config;
    }

    public static Configuration createInternalSslConfigWithTrustStore() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        SSLUtilsTest.addInternalTrustStoreConfig(config);
        return config;
    }

    public static Configuration createInternalSslConfigWithKeyAndTrustStores() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        SSLUtilsTest.addInternalKeyStoreConfig(config);
        SSLUtilsTest.addInternalTrustStoreConfig(config);
        return config;
    }

    private static void addRestKeyStoreConfig(Configuration config) {
        config.setString(SecurityOptions.SSL_REST_KEYSTORE, KEY_STORE_PATH);
        config.setString(SecurityOptions.SSL_REST_KEYSTORE_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_REST_KEY_PASSWORD, "password");
    }

    private static void addRestTrustStoreConfig(Configuration config) {
        config.setString(SecurityOptions.SSL_REST_TRUSTSTORE, TRUST_STORE_PATH);
        config.setString(SecurityOptions.SSL_REST_TRUSTSTORE_PASSWORD, "password");
    }

    private static void addInternalKeyStoreConfig(Configuration config) {
        config.setString(SecurityOptions.SSL_INTERNAL_KEYSTORE, KEY_STORE_PATH);
        config.setString(SecurityOptions.SSL_INTERNAL_KEYSTORE_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_INTERNAL_KEY_PASSWORD, "password");
    }

    private static void addInternalTrustStoreConfig(Configuration config) {
        config.setString(SecurityOptions.SSL_INTERNAL_TRUSTSTORE, TRUST_STORE_PATH);
        config.setString(SecurityOptions.SSL_INTERNAL_TRUSTSTORE_PASSWORD, "password");
    }
}

