/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeutils.GenericPairComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.hash.NonReusingHashJoinIteratorITCase;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ReOpenableHashTableTestBase
extends TestLogger {
    protected static final int PAGE_SIZE = 8192;
    protected static final long MEMORY_SIZE = 0x7D0000L;
    protected static final long SEED1 = 561349061987311L;
    protected static final long SEED2 = 231434613412342L;
    protected static final int NUM_PROBES = 3;
    protected final AbstractInvokable parentTask = new DummyInvokable();
    protected IOManager ioManager;
    protected MemoryManager memoryManager;
    protected TypeSerializer<Tuple2<Integer, String>> recordSerializer;
    protected TypeComparator<Tuple2<Integer, String>> record1Comparator;
    protected TypeComparator<Tuple2<Integer, String>> record2Comparator;
    protected TypePairComparator<Tuple2<Integer, String>, Tuple2<Integer, String>> recordPairComparator;
    protected TypeSerializer<Tuple2<Integer, Integer>> recordBuildSideAccesssor;
    protected TypeSerializer<Tuple2<Integer, Integer>> recordProbeSideAccesssor;
    protected TypeComparator<Tuple2<Integer, Integer>> recordBuildSideComparator;
    protected TypeComparator<Tuple2<Integer, Integer>> recordProbeSideComparator;
    protected TypePairComparator<Tuple2<Integer, Integer>, Tuple2<Integer, Integer>> pactRecordComparator;

    @Before
    public void beforeTest() {
        this.recordSerializer = TestData.getIntStringTupleSerializer();
        this.record1Comparator = TestData.getIntStringTupleComparator();
        this.record2Comparator = TestData.getIntStringTupleComparator();
        this.recordPairComparator = new GenericPairComparator(this.record1Comparator, this.record2Comparator);
        this.recordBuildSideAccesssor = TestData.getIntIntTupleSerializer();
        this.recordProbeSideAccesssor = TestData.getIntIntTupleSerializer();
        this.recordBuildSideComparator = TestData.getIntIntTupleComparator();
        this.recordProbeSideComparator = TestData.getIntIntTupleComparator();
        this.pactRecordComparator = new GenericPairComparator(this.recordBuildSideComparator, this.recordProbeSideComparator);
        this.memoryManager = new MemoryManager(0x7D0000L, 1, 8192, MemoryType.HEAP, true);
        this.ioManager = new IOManagerAsync();
    }

    @After
    public void afterTest() {
        if (this.ioManager != null) {
            this.ioManager.shutdown();
            if (!this.ioManager.isProperlyShutDown()) {
                Assert.fail((String)"I/O manager failed to properly shut down.");
            }
            this.ioManager = null;
        }
        if (this.memoryManager != null) {
            Assert.assertTrue((String)"Memory Leak: Not all memory has been returned to the memory manager.", (boolean)this.memoryManager.verifyEmpty());
            this.memoryManager.shutdown();
            this.memoryManager = null;
        }
    }

    @Test
    public void testOverflow() {
        int buildSize = 1000;
        int probeSize = 1000;
        try {
            TestData.TupleGenerator bgen = new TestData.TupleGenerator(561349061987311L, 200, 1024, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
            TestData.TupleGenerator pgen = new TestData.TupleGenerator(231434613412342L, 0, 1024, TestData.TupleGenerator.KeyMode.SORTED, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
            TestData.TupleGeneratorIterator buildInput = new TestData.TupleGeneratorIterator(bgen, buildSize);
            TestData.TupleGeneratorIterator probeInput = new TestData.TupleGeneratorIterator(pgen, probeSize);
            this.doTest(buildInput, probeInput, bgen, pgen);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    public void testDoubleProbeSpilling() {
        int buildSize = 1000;
        int probeSize = 1000;
        try {
            TestData.TupleGenerator bgen = new TestData.TupleGenerator(561349061987311L, 0, 1024, TestData.TupleGenerator.KeyMode.SORTED, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
            TestData.TupleGenerator pgen = new TestData.TupleGenerator(231434613412342L, 0, 1024, TestData.TupleGenerator.KeyMode.SORTED, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
            TestData.TupleGeneratorIterator buildInput = new TestData.TupleGeneratorIterator(bgen, buildSize);
            TestData.TupleGeneratorIterator probeInput = new TestData.TupleGeneratorIterator(pgen, probeSize);
            this.doTest(buildInput, probeInput, bgen, pgen);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    @Test
    public void testDoubleProbeInMemory() {
        int buildSize = 1000;
        int probeSize = 1000;
        try {
            TestData.TupleGenerator bgen = new TestData.TupleGenerator(561349061987311L, 0, 28, TestData.TupleGenerator.KeyMode.SORTED, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
            TestData.TupleGenerator pgen = new TestData.TupleGenerator(231434613412342L, 0, 28, TestData.TupleGenerator.KeyMode.SORTED, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
            TestData.TupleGeneratorIterator buildInput = new TestData.TupleGeneratorIterator(bgen, buildSize);
            TestData.TupleGeneratorIterator probeInput = new TestData.TupleGeneratorIterator(pgen, probeSize);
            this.doTest(buildInput, probeInput, bgen, pgen);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("An exception occurred during the test: " + e.getMessage()));
        }
    }

    protected abstract void doTest(TestData.TupleGeneratorIterator var1, TestData.TupleGeneratorIterator var2, TestData.TupleGenerator var3, TestData.TupleGenerator var4) throws Exception;

    static Map<Integer, Collection<NonReusingHashJoinIteratorITCase.TupleMatch>> deepCopy(Map<Integer, Collection<NonReusingHashJoinIteratorITCase.TupleMatch>> expectedSecondMatchesMap) {
        HashMap<Integer, Collection<NonReusingHashJoinIteratorITCase.TupleMatch>> copy = new HashMap<Integer, Collection<NonReusingHashJoinIteratorITCase.TupleMatch>>(expectedSecondMatchesMap.size());
        for (Map.Entry<Integer, Collection<NonReusingHashJoinIteratorITCase.TupleMatch>> entry : expectedSecondMatchesMap.entrySet()) {
            ArrayList<NonReusingHashJoinIteratorITCase.TupleMatch> matches = new ArrayList<NonReusingHashJoinIteratorITCase.TupleMatch>(entry.getValue().size());
            for (NonReusingHashJoinIteratorITCase.TupleMatch m : entry.getValue()) {
                matches.add(m);
            }
            copy.put(entry.getKey(), matches);
        }
        return copy;
    }
}

