/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.resettable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntValueSerializer;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.resettable.SpillingResettableIterator;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.types.IntValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpillingResettableIteratorTest {
    private static final int NUM_TESTRECORDS = 50000;
    private static final int MEMORY_CAPACITY = 0xA00000;
    private final AbstractInvokable memOwner = new DummyInvokable();
    private IOManager ioman;
    private MemoryManager memman;
    private Iterator<IntValue> reader;
    private final TypeSerializer<IntValue> serializer = new IntValueSerializer();

    @Before
    public void startup() {
        this.memman = new MemoryManager(0xA00000L, 1, 32768, MemoryType.HEAP, true);
        this.ioman = new IOManagerAsync();
        ArrayList<IntValue> objects = new ArrayList<IntValue>(50000);
        for (int i = 0; i < 50000; ++i) {
            IntValue tmp = new IntValue(i);
            objects.add(tmp);
        }
        this.reader = objects.iterator();
    }

    @After
    public void shutdown() {
        this.ioman.shutdown();
        if (!this.ioman.isProperlyShutDown()) {
            Assert.fail((String)"I/O Manager Shutdown was not completed properly.");
        }
        this.ioman = null;
        if (!this.memman.verifyEmpty()) {
            Assert.fail((String)"A memory leak has occurred: Not all memory was properly returned to the memory manager.");
        }
        this.memman.shutdown();
        this.memman = null;
    }

    @Test
    public void testResettableIterator() {
        try {
            SpillingResettableIterator iterator = new SpillingResettableIterator(this.reader, this.serializer, this.memman, this.ioman, 2, this.memOwner);
            iterator.open();
            int count = 0;
            while (iterator.hasNext()) {
                Assert.assertEquals((String)("In initial run, element " + count + " does not match expected value!"), (long)count++, (long)((IntValue)iterator.next()).getValue());
            }
            Assert.assertEquals((String)"Too few elements were deserialzied in initial run!", (long)50000L, (long)count);
            for (int j = 0; j < 10; ++j) {
                count = 0;
                iterator.reset();
                while (iterator.hasNext()) {
                    Assert.assertEquals((String)("After reset nr. " + j + 1 + " element " + count + " does not match expected value!"), (long)count++, (long)((IntValue)iterator.next()).getValue());
                }
                Assert.assertEquals((String)("Too few elements were deserialzied after reset nr. " + j + 1 + "!"), (long)50000L, (long)count);
            }
            iterator.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Test encountered an exception.");
        }
    }

    @Test
    public void testResettableIteratorInMemory() {
        try {
            SpillingResettableIterator iterator = new SpillingResettableIterator(this.reader, this.serializer, this.memman, this.ioman, 20, this.memOwner);
            iterator.open();
            int count = 0;
            while (iterator.hasNext()) {
                Assert.assertEquals((String)("In initial run, element " + count + " does not match expected value!"), (long)count++, (long)((IntValue)iterator.next()).getValue());
            }
            Assert.assertEquals((String)"Too few elements were deserialzied in initial run!", (long)50000L, (long)count);
            for (int j = 0; j < 10; ++j) {
                count = 0;
                iterator.reset();
                while (iterator.hasNext()) {
                    Assert.assertEquals((String)("After reset nr. " + j + 1 + " element " + count + " does not match expected value!"), (long)count++, (long)((IntValue)iterator.next()).getValue());
                }
                Assert.assertEquals((String)("Too few elements were deserialzied after reset nr. " + j + 1 + "!"), (long)50000L, (long)count);
            }
            iterator.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Test encountered an exception.");
        }
    }

    @Test
    public void testHasNext() {
        try {
            SpillingResettableIterator iterator = new SpillingResettableIterator(this.reader, this.serializer, this.memman, this.ioman, 2, this.memOwner);
            iterator.open();
            int cnt = 0;
            while (iterator.hasNext()) {
                iterator.hasNext();
                iterator.next();
                ++cnt;
            }
            Assert.assertTrue((String)(cnt + " elements read from iterator, but " + 50000 + " expected"), (cnt == 50000 ? 1 : 0) != 0);
            iterator.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Test encountered an exception.");
        }
    }

    @Test
    public void testNext() {
        try {
            IntValue record;
            SpillingResettableIterator iterator = new SpillingResettableIterator(this.reader, this.serializer, this.memman, this.ioman, 2, this.memOwner);
            iterator.open();
            for (int cnt = 0; cnt < 50000; ++cnt) {
                record = (IntValue)iterator.next();
                Assert.assertTrue((String)"Record was not read from iterator", (record != null ? 1 : 0) != 0);
            }
            try {
                record = (IntValue)iterator.next();
                Assert.fail((String)"Too many records were read from iterator.");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            iterator.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Test encountered an exception.");
        }
    }
}

