/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemoryType;
import org.apache.flink.runtime.io.disk.ChannelReaderInputViewIterator;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.ChannelWriterOutputView;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.sort.FixedLengthRecordSorter;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.RandomIntPairGenerator;
import org.apache.flink.runtime.operators.testutils.UniformIntPairGenerator;
import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.runtime.operators.testutils.types.IntPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairSerializer;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FixedLengthRecordSorterTest {
    private static final long SEED = 649180756312423613L;
    private static final int MEMORY_SIZE = 0x4000000;
    private static final int MEMORY_PAGE_SIZE = 32768;
    private MemoryManager memoryManager;
    private IOManager ioManager;
    private TypeSerializer<IntPair> serializer;
    private TypeComparator<IntPair> comparator;

    @Before
    public void beforeTest() {
        this.memoryManager = new MemoryManager(0x4000000L, 1, 32768, MemoryType.HEAP, true);
        this.ioManager = new IOManagerAsync();
        this.serializer = new IntPairSerializer();
        this.comparator = new IntPairComparator();
    }

    @After
    public void afterTest() {
        if (!this.memoryManager.verifyEmpty()) {
            Assert.fail((String)"Memory Leak: Some memory has not been returned to the memory manager.");
        }
        if (this.ioManager != null) {
            this.ioManager.shutdown();
            this.ioManager = null;
        }
        if (this.memoryManager != null) {
            this.memoryManager.shutdown();
            this.memoryManager = null;
        }
    }

    private FixedLengthRecordSorter<IntPair> newSortBuffer(List<MemorySegment> memory) throws Exception {
        return new FixedLengthRecordSorter(this.serializer, this.comparator, memory);
    }

    @Test
    public void testWriteAndRead() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        FixedLengthRecordSorter<IntPair> sorter = this.newSortBuffer(memory);
        RandomIntPairGenerator generator = new RandomIntPairGenerator(649180756312423613L);
        IntPair record = new IntPair();
        int num = -1;
        do {
            generator.next(record);
        } while (sorter.write((Object)record) && ++num < 0x333000);
        generator.reset();
        IntPair readTarget = new IntPair();
        int i = 0;
        while (i < num) {
            generator.next(record);
            readTarget = (IntPair)sorter.getRecord((Object)readTarget, i++);
            int rk = readTarget.getKey();
            int gk = record.getKey();
            int rv = readTarget.getValue();
            int gv = record.getValue();
            if (gk != rk) {
                Assert.fail((String)("The re-read key is wrong " + i));
            }
            if (gv == rv) continue;
            Assert.fail((String)"The re-read value is wrong");
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    public void testWriteAndIterator() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        FixedLengthRecordSorter<IntPair> sorter = this.newSortBuffer(memory);
        RandomIntPairGenerator generator = new RandomIntPairGenerator(649180756312423613L);
        IntPair record = new IntPair();
        int num = -1;
        do {
            generator.next(record);
            ++num;
        } while (sorter.write((Object)record));
        generator.reset();
        MutableObjectIterator iter = sorter.getIterator();
        IntPair readTarget = new IntPair();
        int count = 0;
        while ((readTarget = (IntPair)iter.next((Object)readTarget)) != null) {
            ++count;
            generator.next(record);
            int rk = readTarget.getKey();
            int gk = record.getKey();
            int rv = readTarget.getValue();
            int gv = record.getValue();
            Assert.assertEquals((String)"The re-read key is wrong", (long)gk, (long)rk);
            Assert.assertEquals((String)"The re-read value is wrong", (long)gv, (long)rv);
        }
        Assert.assertEquals((String)"Incorrect number of records", (long)num, (long)count);
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    public void testReset() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        FixedLengthRecordSorter<IntPair> sorter = this.newSortBuffer(memory);
        RandomIntPairGenerator generator = new RandomIntPairGenerator(649180756312423613L);
        IntPair record = new IntPair();
        int num = -1;
        do {
            generator.next(record);
        } while (sorter.write((Object)record) && ++num < 0x333000);
        sorter.reset();
        generator.reset();
        int num2 = -1;
        do {
            generator.next(record);
        } while (sorter.write((Object)record) && ++num2 < 0x333000);
        Assert.assertEquals((String)"The number of records written after the reset was not the same as before.", (long)num, (long)num2);
        generator.reset();
        IntPair readTarget = new IntPair();
        int i = 0;
        while (i < num) {
            generator.next(record);
            readTarget = (IntPair)sorter.getRecord((Object)readTarget, i++);
            int rk = readTarget.getKey();
            int gk = record.getKey();
            int rv = readTarget.getValue();
            int gv = record.getValue();
            Assert.assertEquals((String)"The re-read key is wrong", (long)gk, (long)rk);
            Assert.assertEquals((String)"The re-read value is wrong", (long)gv, (long)rv);
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    public void testSwap() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        FixedLengthRecordSorter<IntPair> sorter = this.newSortBuffer(memory);
        RandomIntPairGenerator generator = new RandomIntPairGenerator(649180756312423613L);
        IntPair record = new IntPair();
        int num = -1;
        do {
            generator.next(record);
        } while (sorter.write((Object)record) && ++num < 0x333000);
        int start = 0;
        int end = num - 1;
        while (start < end) {
            sorter.swap(start++, end--);
        }
        generator.reset();
        IntPair readTarget = new IntPair();
        int i = num - 1;
        while (i >= 0) {
            generator.next(record);
            readTarget = (IntPair)sorter.getRecord((Object)readTarget, i--);
            int rk = readTarget.getKey();
            int gk = record.getKey();
            int rv = readTarget.getValue();
            int gv = record.getValue();
            Assert.assertEquals((String)"The re-read key is wrong", (long)gk, (long)rk);
            Assert.assertEquals((String)"The re-read value is wrong", (long)gv, (long)rv);
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    public void testCompare() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        FixedLengthRecordSorter<IntPair> sorter = this.newSortBuffer(memory);
        UniformIntPairGenerator generator = new UniformIntPairGenerator(Integer.MAX_VALUE, 1, true);
        IntPair record = new IntPair();
        int num = -1;
        do {
            generator.next(record);
        } while (sorter.write((Object)record) && ++num < 0x333000);
        Random rnd = new Random(1298361512624847226L);
        for (int i = 0; i < 2 * num; ++i) {
            int pos1 = rnd.nextInt(num);
            int pos2 = rnd.nextInt(num);
            int cmp = sorter.compare(pos1, pos2);
            if (pos1 < pos2) {
                Assert.assertTrue((cmp <= 0 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((cmp >= 0 ? 1 : 0) != 0);
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    public void testSort() throws Exception {
        int NUM_RECORDS = 559273;
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        FixedLengthRecordSorter<IntPair> sorter = this.newSortBuffer(memory);
        RandomIntPairGenerator generator = new RandomIntPairGenerator(649180756312423613L);
        IntPair record = new IntPair();
        int num = -1;
        do {
            generator.next(record);
        } while (sorter.write((Object)record) && ++num < 559273);
        QuickSort qs = new QuickSort();
        qs.sort(sorter);
        MutableObjectIterator iter = sorter.getIterator();
        IntPair readTarget = new IntPair();
        iter.next((Object)readTarget);
        int last = readTarget.getKey();
        while ((readTarget = (IntPair)iter.next((Object)readTarget)) != null) {
            int current = readTarget.getKey();
            int cmp = last - current;
            if (cmp > 0) {
                Assert.fail((String)"Next key is not larger or equal to previous key.");
            }
            last = current;
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    public void testFlushFullMemoryPage() throws Exception {
        int NUM_RECORDS = 8192;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 3);
        FixedLengthRecordSorter<IntPair> sorter = this.newSortBuffer(memory);
        UniformIntPairGenerator generator = new UniformIntPairGenerator(Integer.MAX_VALUE, 1, false);
        IntPair record = new IntPair();
        int num = -1;
        do {
            generator.next(record);
        } while (sorter.write((Object)record) && ++num < 8192);
        FileIOChannel.ID channelID = this.ioManager.createChannelEnumerator().next();
        BlockChannelWriter blockChannelWriter = this.ioManager.createBlockChannelWriter(channelID);
        List writeBuffer = this.memoryManager.allocatePages((Object)new DummyInvokable(), 3);
        ChannelWriterOutputView outputView = new ChannelWriterOutputView(blockChannelWriter, writeBuffer, ((MemorySegment)writeBuffer.get(0)).size());
        sorter.writeToOutput(outputView, 0, 8192);
        this.memoryManager.release((Collection)outputView.close());
        BlockChannelReader blockChannelReader = this.ioManager.createBlockChannelReader(channelID);
        List readBuffer = this.memoryManager.allocatePages((Object)new DummyInvokable(), 3);
        ChannelReaderInputView readerInputView = new ChannelReaderInputView(blockChannelReader, readBuffer, false);
        List dataBuffer = this.memoryManager.allocatePages((Object)new DummyInvokable(), 3);
        ChannelReaderInputViewIterator iterator = new ChannelReaderInputViewIterator(readerInputView, dataBuffer, this.serializer);
        record = (IntPair)iterator.next((Object)record);
        int i = 0;
        while (record != null) {
            Assert.assertEquals((long)i, (long)record.getKey());
            record = (IntPair)iterator.next((Object)record);
            ++i;
        }
        Assert.assertEquals((long)8192L, (long)i);
        this.memoryManager.release((Collection)dataBuffer);
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    public void testFlushPartialMemoryPage() throws Exception {
        int NUM_RECORDS = 8192;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 3);
        FixedLengthRecordSorter<IntPair> sorter = this.newSortBuffer(memory);
        UniformIntPairGenerator generator = new UniformIntPairGenerator(Integer.MAX_VALUE, 1, false);
        IntPair record = new IntPair();
        int num = -1;
        do {
            generator.next(record);
        } while (sorter.write((Object)record) && ++num < 8192);
        FileIOChannel.ID channelID = this.ioManager.createChannelEnumerator().next();
        BlockChannelWriter blockChannelWriter = this.ioManager.createBlockChannelWriter(channelID);
        List writeBuffer = this.memoryManager.allocatePages((Object)new DummyInvokable(), 3);
        ChannelWriterOutputView outputView = new ChannelWriterOutputView(blockChannelWriter, writeBuffer, ((MemorySegment)writeBuffer.get(0)).size());
        sorter.writeToOutput(outputView, 1, 8191);
        this.memoryManager.release((Collection)outputView.close());
        BlockChannelReader blockChannelReader = this.ioManager.createBlockChannelReader(channelID);
        List readBuffer = this.memoryManager.allocatePages((Object)new DummyInvokable(), 3);
        ChannelReaderInputView readerInputView = new ChannelReaderInputView(blockChannelReader, readBuffer, false);
        List dataBuffer = this.memoryManager.allocatePages((Object)new DummyInvokable(), 3);
        ChannelReaderInputViewIterator iterator = new ChannelReaderInputViewIterator(readerInputView, dataBuffer, this.serializer);
        record = (IntPair)iterator.next((Object)record);
        int i = 1;
        while (record != null) {
            Assert.assertEquals((long)i, (long)record.getKey());
            record = (IntPair)iterator.next((Object)record);
            ++i;
        }
        Assert.assertEquals((long)8192L, (long)i);
        this.memoryManager.release((Collection)dataBuffer);
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }
}

