/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.RecordCollectingResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.IteratorWrappingTestSingleInputGate;
import org.apache.flink.runtime.io.network.util.TestPooledBufferProvider;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.operators.testutils.MockEnvironmentBuilder;
import org.apache.flink.runtime.operators.testutils.MockInputSplitProvider;
import org.apache.flink.runtime.query.KvStateRegistry;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.types.Record;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;

public class MockEnvironment
implements Environment,
AutoCloseable {
    private final TaskInfo taskInfo;
    private final ExecutionConfig executionConfig;
    private final MemoryManager memManager;
    private final IOManager ioManager;
    private final TaskStateManager taskStateManager;
    private final InputSplitProvider inputSplitProvider;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final List<InputGate> inputs;
    private final List<ResultPartitionWriter> outputs;
    private final JobID jobID;
    private final JobVertexID jobVertexID;
    private final TaskManagerRuntimeInfo taskManagerRuntimeInfo;
    private final BroadcastVariableManager bcVarManager = new BroadcastVariableManager();
    private final AccumulatorRegistry accumulatorRegistry;
    private final TaskKvStateRegistry kvStateRegistry;
    private final int bufferSize;
    private final ClassLoader userCodeClassLoader;
    private final TaskEventDispatcher taskEventDispatcher = new TaskEventDispatcher();
    private Optional<Class<Throwable>> expectedExternalFailureCause = Optional.empty();
    private Optional<Throwable> actualExternalFailureCause = Optional.empty();
    private final TaskMetricGroup taskMetricGroup;

    public static MockEnvironmentBuilder builder() {
        return new MockEnvironmentBuilder();
    }

    protected MockEnvironment(JobID jobID, JobVertexID jobVertexID, String taskName, long memorySize, MockInputSplitProvider inputSplitProvider, int bufferSize, Configuration taskConfiguration, ExecutionConfig executionConfig, TaskStateManager taskStateManager, int maxParallelism, int parallelism, int subtaskIndex, ClassLoader userCodeClassLoader, TaskMetricGroup taskMetricGroup, TaskManagerRuntimeInfo taskManagerRuntimeInfo) {
        this.jobID = jobID;
        this.jobVertexID = jobVertexID;
        this.taskInfo = new TaskInfo(taskName, maxParallelism, subtaskIndex, parallelism, 0);
        this.jobConfiguration = new Configuration();
        this.taskConfiguration = taskConfiguration;
        this.inputs = new LinkedList<InputGate>();
        this.outputs = new LinkedList<ResultPartitionWriter>();
        this.memManager = new MemoryManager(memorySize, 1);
        this.ioManager = new IOManagerAsync();
        this.taskManagerRuntimeInfo = taskManagerRuntimeInfo;
        this.executionConfig = executionConfig;
        this.inputSplitProvider = inputSplitProvider;
        this.bufferSize = bufferSize;
        this.accumulatorRegistry = new AccumulatorRegistry(jobID, this.getExecutionId());
        KvStateRegistry registry = new KvStateRegistry();
        this.kvStateRegistry = registry.createTaskRegistry(jobID, this.getJobVertexId());
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        this.taskStateManager = (TaskStateManager)Preconditions.checkNotNull((Object)taskStateManager);
        this.taskMetricGroup = taskMetricGroup;
    }

    public IteratorWrappingTestSingleInputGate<Record> addInput(MutableObjectIterator<Record> inputIterator) {
        try {
            IteratorWrappingTestSingleInputGate<Record> reader = new IteratorWrappingTestSingleInputGate<Record>(this.bufferSize, Record.class, inputIterator);
            this.inputs.add((InputGate)reader.getInputGate());
            return reader;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error setting up mock readers: " + t.getMessage(), t);
        }
    }

    public void addOutput(List<Record> outputList) {
        try {
            this.outputs.add(new RecordCollectingResultPartitionWriter(outputList, new TestPooledBufferProvider(Integer.MAX_VALUE)));
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public MemoryManager getMemoryManager() {
        return this.memManager;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public TaskManagerRuntimeInfo getTaskManagerInfo() {
        return this.taskManagerRuntimeInfo;
    }

    public TaskMetricGroup getMetricGroup() {
        return this.taskMetricGroup;
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.inputSplitProvider;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public ClassLoader getUserClassLoader() {
        return this.userCodeClassLoader;
    }

    public Map<String, Future<Path>> getDistributedCacheEntries() {
        return Collections.emptyMap();
    }

    public ResultPartitionWriter getWriter(int index) {
        return this.outputs.get(index);
    }

    public ResultPartitionWriter[] getAllWriters() {
        return this.outputs.toArray(new ResultPartitionWriter[this.outputs.size()]);
    }

    public InputGate getInputGate(int index) {
        return this.inputs.get(index);
    }

    public InputGate[] getAllInputGates() {
        InputGate[] gates = new InputGate[this.inputs.size()];
        this.inputs.toArray(gates);
        return gates;
    }

    public TaskEventDispatcher getTaskEventDispatcher() {
        return this.taskEventDispatcher;
    }

    public JobVertexID getJobVertexId() {
        return this.jobVertexID;
    }

    public ExecutionAttemptID getExecutionId() {
        return new ExecutionAttemptID(0L, 0L);
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.bcVarManager;
    }

    public TaskStateManager getTaskStateManager() {
        return this.taskStateManager;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public TaskKvStateRegistry getTaskKvStateRegistry() {
        return this.kvStateRegistry;
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics) {
        throw new UnsupportedOperationException();
    }

    public void acknowledgeCheckpoint(long checkpointId, CheckpointMetrics checkpointMetrics, TaskStateSnapshot subtaskState) {
        throw new UnsupportedOperationException();
    }

    public void declineCheckpoint(long checkpointId, Throwable cause) {
        throw new UnsupportedOperationException();
    }

    public void failExternally(Throwable cause) {
        if (!this.expectedExternalFailureCause.isPresent()) {
            throw new UnsupportedOperationException("MockEnvironment does not support external task failure.");
        }
        Preconditions.checkArgument((boolean)this.expectedExternalFailureCause.get().isInstance(Preconditions.checkNotNull((Object)cause)));
        Preconditions.checkState((!this.actualExternalFailureCause.isPresent() ? 1 : 0) != 0);
        this.actualExternalFailureCause = Optional.of(cause);
    }

    @Override
    public void close() {
        if (!this.memManager.isShutdown()) {
            Preconditions.checkState((boolean)this.memManager.verifyEmpty(), (Object)"Memory Manager managed memory was not completely freed.");
        }
        this.memManager.shutdown();
        this.ioManager.shutdown();
        Preconditions.checkState((boolean)this.ioManager.isProperlyShutDown(), (Object)"IO Manager has not properly shut down.");
    }

    public void setExpectedExternalFailureCause(Class<Throwable> expectedThrowableClass) {
        this.expectedExternalFailureCause = Optional.of(expectedThrowableClass);
    }

    public Optional<Throwable> getActualExternalFailureCause() {
        return this.actualExternalFailureCause;
    }
}

