/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.registration.RegisteredRpcConnection;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.registration.RetryingRegistrationTest;
import org.apache.flink.runtime.registration.TestRegistrationGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.LoggerFactory;

public class RegisteredRpcConnectionTest
extends TestLogger {
    private TestingRpcService rpcService;

    @Before
    public void setup() {
        this.rpcService = new TestingRpcService();
    }

    @After
    public void tearDown() throws ExecutionException, InterruptedException {
        if (this.rpcService != null) {
            this.rpcService.stopService().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessfulRpcConnection() throws Exception {
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        String connectionID = "Test RPC Connection ID";
        TestRegistrationGateway testGateway = new TestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID")});
        try {
            this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
            TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, this.rpcService.getExecutor(), (RpcService)this.rpcService);
            connection.start();
            String actualConnectionId = connection.getConnectionFuture().get();
            Assert.assertTrue((boolean)connection.isConnected());
            Assert.assertEquals((Object)"<TestRpcConnectionEndpointAddress>", (Object)connection.getTargetAddress());
            Assert.assertEquals((Object)leaderId, (Object)connection.getTargetLeaderId());
            Assert.assertEquals((Object)testGateway, (Object)connection.getTargetGateway());
            Assert.assertEquals((Object)"Test RPC Connection ID", (Object)actualConnectionId);
        }
        finally {
            testGateway.stop();
        }
    }

    @Test
    public void testRpcConnectionFailures() throws Exception {
        String connectionFailureMessage = "Test RPC Connection failure";
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        TestRegistrationGateway testGateway = (TestRegistrationGateway)Mockito.mock(TestRegistrationGateway.class);
        RuntimeException registrationException = new RuntimeException("Test RPC Connection failure");
        Mockito.when(testGateway.registrationCall((UUID)Matchers.any(UUID.class), Matchers.anyLong())).thenThrow(new Throwable[]{registrationException});
        this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
        TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, this.rpcService.getExecutor(), (RpcService)this.rpcService);
        connection.start();
        try {
            connection.getConnectionFuture().get();
            Assert.fail((String)"expected failure.");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals((Object)registrationException, (Object)ee.getCause());
        }
        Assert.assertFalse((boolean)connection.isConnected());
        Assert.assertEquals((Object)"<TestRpcConnectionEndpointAddress>", (Object)connection.getTargetAddress());
        Assert.assertEquals((Object)leaderId, (Object)connection.getTargetLeaderId());
        Assert.assertNull((Object)connection.getTargetGateway());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcConnectionClose() throws Exception {
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        String connectionID = "Test RPC Connection ID";
        TestRegistrationGateway testGateway = new TestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID")});
        try {
            this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
            TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, this.rpcService.getExecutor(), (RpcService)this.rpcService);
            connection.start();
            connection.close();
            Assert.assertEquals((Object)"<TestRpcConnectionEndpointAddress>", (Object)connection.getTargetAddress());
            Assert.assertEquals((Object)leaderId, (Object)connection.getTargetLeaderId());
            Assert.assertTrue((boolean)connection.isClosed());
        }
        finally {
            testGateway.stop();
        }
    }

    @Test
    public void testReconnect() throws Exception {
        String connectionId1 = "Test RPC Connection ID 1";
        String connectionId2 = "Test RPC Connection ID 2";
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        TestRegistrationGateway testGateway = new TestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID 1"), new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID 2")});
        this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
        TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, this.rpcService.getExecutor(), (RpcService)this.rpcService);
        connection.start();
        String actualConnectionId1 = connection.getConnectionFuture().get();
        Assert.assertEquals((Object)actualConnectionId1, (Object)"Test RPC Connection ID 1");
        Assert.assertTrue((boolean)connection.tryReconnect());
        String actualConnectionId2 = connection.getConnectionFuture().get();
        Assert.assertEquals((Object)actualConnectionId2, (Object)"Test RPC Connection ID 2");
    }

    private static class TestRpcConnection
    extends RegisteredRpcConnection<UUID, TestRegistrationGateway, RetryingRegistrationTest.TestRegistrationSuccess> {
        private final Object lock = new Object();
        private final RpcService rpcService;
        private CompletableFuture<String> connectionFuture;

        public TestRpcConnection(String targetAddress, UUID targetLeaderId, Executor executor, RpcService rpcService) {
            super(LoggerFactory.getLogger(RegisteredRpcConnectionTest.class), targetAddress, (Serializable)targetLeaderId, executor);
            this.rpcService = rpcService;
            this.connectionFuture = new CompletableFuture();
        }

        protected RetryingRegistration<UUID, TestRegistrationGateway, RetryingRegistrationTest.TestRegistrationSuccess> generateRegistration() {
            return new RetryingRegistrationTest.TestRetryingRegistration(this.rpcService, this.getTargetAddress(), (UUID)this.getTargetLeaderId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRegistrationSuccess(RetryingRegistrationTest.TestRegistrationSuccess success) {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.complete(success.getCorrelationId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRegistrationFailure(Throwable failure) {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.completeExceptionally(failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryReconnect() {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.cancel(false);
                this.connectionFuture = new CompletableFuture();
            }
            return super.tryReconnect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<String> getConnectionFuture() {
            Object object = this.lock;
            synchronized (object) {
                return this.connectionFuture;
            }
        }
    }
}

