/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.exceptions.ResourceManagerException;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceActions;
import org.apache.flink.util.function.FunctionWithException;

public class TestingResourceActionsBuilder {
    private BiConsumer<InstanceID, Exception> releaseResourceConsumer = (ignoredA, ignoredB) -> {};
    private FunctionWithException<ResourceProfile, Collection<ResourceProfile>, ResourceManagerException> allocateResourceFunction = ignored -> Collections.singleton(ResourceProfile.UNKNOWN);
    private Consumer<Tuple3<JobID, AllocationID, Exception>> notifyAllocationFailureConsumer = ignored -> {};

    public TestingResourceActionsBuilder setReleaseResourceConsumer(BiConsumer<InstanceID, Exception> releaseResourceConsumer) {
        this.releaseResourceConsumer = releaseResourceConsumer;
        return this;
    }

    public TestingResourceActionsBuilder setAllocateResourceFunction(FunctionWithException<ResourceProfile, Collection<ResourceProfile>, ResourceManagerException> allocateResourceFunction) {
        this.allocateResourceFunction = allocateResourceFunction;
        return this;
    }

    public TestingResourceActionsBuilder setAllocateResourceConsumer(Consumer<ResourceProfile> allocateResourceConsumer) {
        this.allocateResourceFunction = resourceProfile -> {
            allocateResourceConsumer.accept((ResourceProfile)resourceProfile);
            return Collections.singleton(ResourceProfile.UNKNOWN);
        };
        return this;
    }

    public TestingResourceActionsBuilder setNotifyAllocationFailureConsumer(Consumer<Tuple3<JobID, AllocationID, Exception>> notifyAllocationFailureConsumer) {
        this.notifyAllocationFailureConsumer = notifyAllocationFailureConsumer;
        return this;
    }

    public TestingResourceActions build() {
        return new TestingResourceActions(this.releaseResourceConsumer, this.allocateResourceFunction, this.notifyAllocationFailureConsumer);
    }
}

