/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.FileUpload;
import org.apache.flink.runtime.rest.MultipartUploadResource;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.RestClientConfiguration;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.testingUtils.TestingUtils;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class RestClientMultipartTest
extends TestLogger {
    @ClassRule
    public static final MultipartUploadResource MULTIPART_UPLOAD_RESOURCE = new MultipartUploadResource();
    private static RestClient restClient;

    @BeforeClass
    public static void setupClient() throws ConfigurationException {
        restClient = new RestClient(RestClientConfiguration.fromConfiguration((Configuration)new Configuration()), (Executor)TestingUtils.defaultExecutor());
    }

    @After
    public void reset() {
        MULTIPART_UPLOAD_RESOURCE.resetState();
    }

    @AfterClass
    public static void teardownClient() {
        if (restClient != null) {
            restClient.shutdown(Time.seconds((long)10L));
        }
    }

    @Test
    public void testMixedMultipart() throws Exception {
        Collection files = MULTIPART_UPLOAD_RESOURCE.getFilesToUpload().stream().map(file -> new FileUpload(file.toPath(), "application/octet-stream")).collect(Collectors.toList());
        MultipartUploadResource.TestRequestBody json = new MultipartUploadResource.TestRequestBody();
        CompletableFuture responseFuture = restClient.sendRequest(MULTIPART_UPLOAD_RESOURCE.getServerSocketAddress().getHostName(), MULTIPART_UPLOAD_RESOURCE.getServerSocketAddress().getPort(), MULTIPART_UPLOAD_RESOURCE.getMixedHandler().getMessageHeaders(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)json, files);
        responseFuture.get();
        Assert.assertEquals((Object)json, (Object)RestClientMultipartTest.MULTIPART_UPLOAD_RESOURCE.getMixedHandler().lastReceivedRequest);
    }

    @Test
    public void testJsonMultipart() throws Exception {
        MultipartUploadResource.TestRequestBody json = new MultipartUploadResource.TestRequestBody();
        CompletableFuture responseFuture = restClient.sendRequest(MULTIPART_UPLOAD_RESOURCE.getServerSocketAddress().getHostName(), MULTIPART_UPLOAD_RESOURCE.getServerSocketAddress().getPort(), MULTIPART_UPLOAD_RESOURCE.getJsonHandler().getMessageHeaders(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)json, Collections.emptyList());
        responseFuture.get();
        Assert.assertEquals((Object)json, (Object)RestClientMultipartTest.MULTIPART_UPLOAD_RESOURCE.getJsonHandler().lastReceivedRequest);
    }

    @Test
    public void testFileMultipart() throws Exception {
        Collection files = MULTIPART_UPLOAD_RESOURCE.getFilesToUpload().stream().map(file -> new FileUpload(file.toPath(), "application/octet-stream")).collect(Collectors.toList());
        CompletableFuture responseFuture = restClient.sendRequest(MULTIPART_UPLOAD_RESOURCE.getServerSocketAddress().getHostName(), MULTIPART_UPLOAD_RESOURCE.getServerSocketAddress().getPort(), MULTIPART_UPLOAD_RESOURCE.getFileHandler().getMessageHeaders(), (MessageParameters)EmptyMessageParameters.getInstance(), (RequestBody)EmptyRequestBody.getInstance(), files);
        responseFuture.get();
    }
}

